/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal;

import com.ibm.ejs.ras.TrLevelConstants;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.provisioning.packages.PackageIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class TraceSpecification {
    private static Comparator<TraceElement> SPEC_COMPARATOR = new Comparator<TraceElement>(){

        @Override
        public int compare(TraceElement spec1, TraceElement spec2) {
            return spec1.groupName.compareTo(spec2.groupName);
        }
    };
    final List<TraceElement> specs;
    final boolean fineTraceEnabled;
    TraceSpecificationException ex = null;
    private PackageIndex<Integer> safeLevelsIndex = null;
    private boolean suppressSensitiveTrace = false;

    public TraceSpecification(String s, PackageIndex<Integer> safeLevelIndex, boolean suppressSensitiveTrace) {
        StringTokenizer specString = new StringTokenizer(s, ":");
        this.safeLevelsIndex = safeLevelIndex;
        this.suppressSensitiveTrace = suppressSensitiveTrace;
        ArrayList<TraceElement> newSpec = new ArrayList<TraceElement>();
        boolean finerTrace = false;
        boolean hasUserSetDefaultLevel = false;
        while (specString.hasMoreTokens()) {
            String clazz = "*";
            String level = "info";
            String setting = "enabled";
            StringTokenizer specElement = new StringTokenizer(specString.nextToken(), "=");
            if (specElement.hasMoreTokens()) {
                clazz = specElement.nextToken().trim();
                if ("*".equals(clazz)) {
                    hasUserSetDefaultLevel = true;
                }
                if (specElement.hasMoreTokens()) {
                    level = specElement.nextToken().trim();
                    if (specElement.hasMoreTokens()) {
                        setting = specElement.nextToken().trim();
                    }
                }
            } else {
                hasUserSetDefaultLevel = true;
            }
            finerTrace |= this.addSpecToList(newSpec, s, clazz, level, setting);
        }
        if (!hasUserSetDefaultLevel || newSpec.isEmpty()) {
            finerTrace |= this.addSpecToList(newSpec, s, "*", "info", "enabled");
        }
        Collections.sort(newSpec, SPEC_COMPARATOR);
        this.specs = Collections.unmodifiableList(newSpec);
        this.fineTraceEnabled = finerTrace;
    }

    public String toDisplayString() {
        StringBuilder sb = new StringBuilder();
        for (TraceElement spec : this.specs) {
            sb.append(spec.toDisplayString()).append(':');
        }
        return sb.substring(0, sb.length() - 1);
    }

    private boolean addSpecToList(List<TraceElement> updatedSpecList, String specString, String clazz, String level, String enableString) {
        boolean enableSetting;
        TraceSpecificationException tex = null;
        boolean enable = true;
        String fullString = clazz + "=" + level + "=" + enableString;
        String setLower = enableString.trim().toLowerCase();
        if (setLower.equals("enabled") || setLower.equals("on")) {
            enableSetting = true;
        } else if (setLower.equals("disabled") || setLower.equals("off")) {
            enableSetting = false;
            enable = false;
        } else {
            tex = new TraceSpecificationException("Unknown trace setting, must be either 'enabled' or 'disabled'", "TRACE_STRING_BAD_ACTION", enableString, fullString);
            enableSetting = true;
            tex.setPreviousException(this.ex);
            this.ex = tex;
        }
        int found = -1;
        int traceLevel = 0;
        int traceLevelCount = 0;
        for (int i = 0; i < TrLevelConstants.traceLevels.length; ++i) {
            String[] traceLevelsRow = TrLevelConstants.traceLevels[i];
            for (int j = 0; j < traceLevelsRow.length; ++j) {
                if (level.equalsIgnoreCase(traceLevelsRow[j])) {
                    found = i;
                    traceLevel = traceLevelCount;
                    break;
                }
                ++traceLevelCount;
            }
            if (found >= 0) break;
        }
        if (found < 0) {
            tex = new TraceSpecificationException("Unknown trace level", "TRACE_STRING_BAD_LEVEL", level, fullString);
            tex.setPreviousException(this.ex);
            this.ex = tex;
        } else if (tex == null) {
            TraceElement spec = new TraceElement(clazz, found, traceLevel, enableSetting, fullString);
            updatedSpecList.add(spec);
            return enable && found >= 0 && TrLevelConstants.levels[found].intValue() < Level.INFO.intValue();
        }
        return false;
    }

    public TraceSpecificationException getExceptions() {
        return this.ex;
    }

    public final List<TraceElement> getSpecs() {
        return this.specs;
    }

    public boolean isAnyTraceEnabled() {
        return this.fineTraceEnabled;
    }

    public static TraceComponent getTc() {
        return TraceComponentHolder.instance;
    }

    public void warnUnmatchedSpecs() {
        StringBuilder sb = new StringBuilder();
        for (TraceElement spec : this.specs) {
            if (spec.getMatched()) continue;
            sb.append(spec.toDisplayString()).append(':');
        }
        if (sb.length() > 0) {
            Tr.info(TraceSpecification.getTc(), "UNKNOWN_TRACE_SPEC", sb.substring(0, sb.length() - 1));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fineTraceEnabled ? 1231 : 1237);
        result = 31 * result + (this.specs == null ? 0 : this.specs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TraceSpecification other = (TraceSpecification)obj;
        if (this.fineTraceEnabled != other.fineTraceEnabled) {
            return false;
        }
        if (this.specs == null) {
            if (other.specs != null) {
                return false;
            }
        } else {
            String oSpecs;
            if (other.specs == null) {
                return false;
            }
            if (this.specs.size() != other.specs.size()) {
                return false;
            }
            String mySpecs = this.specs.toString();
            if (!mySpecs.equals(oSpecs = other.specs.toString())) {
                return false;
            }
            if (this.suppressSensitiveTrace != other.suppressSensitiveTrace) {
                return false;
            }
        }
        return true;
    }

    public boolean isSensitiveTraceSuppressed() {
        return this.suppressSensitiveTrace;
    }

    public PackageIndex<Integer> getSafeLevelsIndex() {
        return this.safeLevelsIndex;
    }

    public static class TraceSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        final String msgKey;
        final String badElement;
        final String fullSpecification;
        TraceSpecificationException previousException;

        public TraceSpecificationException(String message, String msgKey, String badElement, String fullSpecification) {
            super(message);
            this.msgKey = msgKey;
            this.badElement = badElement;
            this.fullSpecification = fullSpecification;
        }

        @Override
        public String getLocalizedMessage() {
            return Tr.formatMessage(TraceComponentHolder.instance, this.msgKey, this.badElement, this.fullSpecification);
        }

        public final TraceSpecificationException getPreviousException() {
            return this.previousException;
        }

        protected final void setPreviousException(TraceSpecificationException prevException) {
            this.previousException = prevException;
        }

        public void warning(boolean delegateInitialized) {
            if (delegateInitialized) {
                Tr.warning(TraceComponentHolder.instance, this.msgKey, this.badElement, this.fullSpecification);
            } else {
                System.err.println(this.getLocalizedMessage());
            }
        }
    }

    public static final class TraceElement {
        public final String groupName;
        public final int fineLevel;
        public final int specTraceLevel;
        public final String fullString;
        public final boolean action;
        protected boolean matched = false;

        TraceElement(String clazz, int fineLevel, int traceLevel, boolean enableValue, String fullString) {
            this.groupName = clazz;
            this.fineLevel = fineLevel;
            this.specTraceLevel = traceLevel;
            this.action = enableValue;
            this.fullString = fullString;
        }

        public boolean getMatched() {
            return this.matched;
        }

        public void setMatched(boolean matched) {
            this.matched = matched;
        }

        public String toDisplayString() {
            return this.fullString.replace("=enabled", "");
        }

        public String toString() {
            return this.fullString;
        }
    }

    private static final class TraceComponentHolder {
        static final TraceComponent instance = Tr.register(TraceSpecification.class, "logging", "com.ibm.ws.logging.internal.resources.LoggingMessages");

        private TraceComponentHolder() {
        }
    }
}

