/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.generator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.internal.generator.ArgumentProcessor;
import com.ibm.ws.kernel.feature.internal.generator.DefaultConfigurationList;
import com.ibm.ws.kernel.feature.internal.generator.FeatureList;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListException;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListOptions;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.MessageFormat;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FeatureListGenerator {
    private final FeatureListOptions options;
    static final long serialVersionUID = 904153401497159254L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FeatureListGenerator(FeatureListOptions options) {
        this.options = options;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        try {
            ArgumentProcessor ap = new ArgumentProcessor(args);
            FeatureListGenerator flg = new FeatureListGenerator(ap.getOptions());
            System.exit(flg.generate().getValue());
        }
        catch (FeatureListException ap) {
            void fle;
            FFDCFilter.processException((Throwable)ap, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListGenerator", (String)"43", null, (Object[])new Object[]{args});
            System.out.println(fle.getMessage());
            System.exit(FeatureListOptions.ReturnCode.RUNTIME_EXCEPTION.getValue());
        }
    }

    private FeatureListOptions.ReturnCode generate() {
        if (this.options.getReturnCode().getValue() > 0) {
            return this.options.getReturnCode();
        }
        if (this.options.getReturnCode() == FeatureListOptions.ReturnCode.GENERATE_ACTION) {
            String productName = this.options.getProductName();
            boolean coreProduct = productName.equals("core");
            ManifestFileProcessor mfp = new ManifestFileProcessor();
            Map<String, ProvisioningFeatureDefinition> features = mfp.getFeatureDefinitions(productName);
            Map<String, ProvisioningFeatureDefinition> coreFeatures = coreProduct ? null : mfp.getFeatureDefinitions("core");
            String location = mfp.getProdFeatureLocation(productName);
            String productId = mfp.getProdFeatureId(productName);
            if (!coreProduct) {
                if (features == null) {
                    if (location != null) {
                        System.out.println(MessageFormat.format(ArgumentProcessor.messages.getString("error.prod.ext.not.found"), productName, location));
                        return FeatureListOptions.ReturnCode.PRODUCT_EXT_NOT_FOUND;
                    }
                    System.out.println(MessageFormat.format(ArgumentProcessor.messages.getString("error.prod.ext.not.defined"), productName));
                    return FeatureListOptions.ReturnCode.PRODUCT_EXT_NOT_DEFINED;
                }
                if (features.isEmpty()) {
                    System.out.println(MessageFormat.format(ArgumentProcessor.messages.getString("error.prod.ext.features.not.found"), productName));
                    return FeatureListOptions.ReturnCode.PRODUCT_EXT_NO_FEATURES_FOUND;
                }
            }
            FeatureListUtils utils = new FeatureListUtils(this.options);
            utils.writeStartDocument();
            utils.startFeatureInfo(this.options.getProductName(), location, productId);
            FeatureList fl = new FeatureList(this.options, features, coreFeatures, utils);
            fl.writeFeatureList(mfp);
            DefaultConfigurationList dcl = new DefaultConfigurationList(this.options, features, utils);
            dcl.writeDefaultConfiguration(mfp);
            utils.endFeatureInfo();
            utils.writeEndDocument();
            if (this.options.getReturnCode() == FeatureListOptions.ReturnCode.GENERATE_ACTION) {
                return FeatureListOptions.ReturnCode.OK;
            }
        }
        return this.options.getReturnCode();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListGenerator", FeatureListGenerator.class, null, null);
    }
}

