/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.Ed25519PublicBCPGKey;
import org.bouncycastle.bcpg.Ed25519SecretBCPGKey;
import org.bouncycastle.bcpg.Ed448PublicBCPGKey;
import org.bouncycastle.bcpg.Ed448SecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.OctetArrayBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.bcpg.X25519SecretBCPGKey;
import org.bouncycastle.bcpg.X448PublicBCPGKey;
import org.bouncycastle.bcpg.X448SecretBCPGKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKdfParameters;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class BcPGPKeyConverter
extends PGPKeyConverter {
    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        BCPGKey bCPGKey = this.getPrivateBCPGKey(pGPPublicKey, asymmetricKeyParameter);
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), bCPGKey);
    }

    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        BCPGKey bCPGKey = this.getPublicBCPGKey(n, pGPAlgorithmParameters, asymmetricKeyParameter);
        return new PGPPublicKey(new PublicKeyPacket(n, date, bCPGKey), new BcKeyFingerprintCalculator());
    }

    public AsymmetricKeyParameter getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    return new DSAPrivateKeyParameters(dSASecretBCPGKey.getX(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    if (CryptlibObjectIdentifiers.curvey25519.equals(eCDHPublicBCPGKey.getCurveOID())) {
                        return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, Arrays.reverseInPlace(BigIntegers.asUnsignedByteArray(((ECSecretBCPGKey)bCPGKey).getX()))));
                    }
                    return this.implGetPrivateKeyEC(eCDHPublicBCPGKey, (ECSecretBCPGKey)bCPGKey);
                }
                case 25: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, 32, Arrays.reverseInPlace(bCPGKey.getEncoded())));
                }
                case 26: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X448, 56, Arrays.reverseInPlace(bCPGKey.getEncoded())));
                }
                case 19: {
                    return this.implGetPrivateKeyEC((ECDSAPublicBCPGKey)publicKeyPacket.getKey(), (ECSecretBCPGKey)bCPGKey);
                }
                case 22: {
                    if (((EdDSAPublicBCPGKey)publicKeyPacket.getKey()).getCurveOID().equals(EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPrivateKeyPKCS8(EdECObjectIdentifiers.id_Ed448, 57, bCPGKey);
                    }
                    return this.implGetPrivateKeyPKCS8(EdECObjectIdentifiers.id_Ed25519, 32, bCPGKey);
                }
                case 27: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, 32, bCPGKey.getEncoded()));
                }
                case 28: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed448, 57, bCPGKey.getEncoded()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    return new ElGamalPrivateKeyParameters(elGamalSecretBCPGKey.getX(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    return new RSAPrivateCrtKeyParameters(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public AsymmetricKeyParameter getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new DSAPublicKeyParameters(dSAPublicBCPGKey.getY(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    if (eCDHPublicBCPGKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                        byte[] byArray = BigIntegers.asUnsignedByteArray(eCDHPublicBCPGKey.getEncodedPoint());
                        if (byArray.length < 1 || 64 != byArray[0]) {
                            throw new IllegalArgumentException("Invalid Curve25519 public key");
                        }
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_X25519, byArray, 1);
                    }
                    return this.implGetPublicKeyEC(eCDHPublicBCPGKey);
                }
                case 25: {
                    return this.implGetPublicKeyX509((X25519PublicBCPGKey)publicKeyPacket.getKey(), EdECObjectIdentifiers.id_X25519);
                }
                case 26: {
                    return this.implGetPublicKeyX509((X448PublicBCPGKey)publicKeyPacket.getKey(), EdECObjectIdentifiers.id_X448);
                }
                case 19: {
                    return this.implGetPublicKeyEC((ECDSAPublicBCPGKey)publicKeyPacket.getKey());
                }
                case 22: {
                    EdDSAPublicBCPGKey edDSAPublicBCPGKey = (EdDSAPublicBCPGKey)publicKeyPacket.getKey();
                    byte[] byArray = BigIntegers.asUnsignedByteArray(edDSAPublicBCPGKey.getEncodedPoint());
                    if (byArray.length < 1) {
                        throw new IllegalArgumentException("Invalid EdDSA public key");
                    }
                    if (byArray[0] == 64 && !edDSAPublicBCPGKey.getCurveOID().equals(EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_Ed25519, byArray, 1);
                    }
                    if (edDSAPublicBCPGKey.getCurveOID().equals(EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_Ed448, byArray, 0);
                    }
                    throw new IllegalArgumentException("Invalid EdDSA public key");
                }
                case 27: {
                    return this.implGetPublicKeyX509((Ed25519PublicBCPGKey)publicKeyPacket.getKey(), EdECObjectIdentifiers.id_Ed25519);
                }
                case 28: {
                    return this.implGetPublicKeyX509((Ed448PublicBCPGKey)publicKeyPacket.getKey(), EdECObjectIdentifiers.id_Ed448);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    return new ElGamalPublicKeyParameters(elGamalPublicBCPGKey.getY(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new RSAKeyParameters(false, rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    private BCPGKey getPrivateBCPGKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        switch (pGPPublicKey.getAlgorithm()) {
            case 17: {
                DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)asymmetricKeyParameter;
                return new DSASecretBCPGKey(dSAPrivateKeyParameters.getX());
            }
            case 18: {
                if (asymmetricKeyParameter instanceof X25519PrivateKeyParameters) {
                    return new ECSecretBCPGKey(new BigInteger(1, Arrays.reverseInPlace(((X25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded())));
                }
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
                return new ECSecretBCPGKey(eCPrivateKeyParameters.getD());
            }
            case 25: {
                return new X25519SecretBCPGKey(Arrays.reverseInPlace(((X25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded()));
            }
            case 26: {
                return new X448SecretBCPGKey(Arrays.reverseInPlace(((X448PrivateKeyParameters)asymmetricKeyParameter).getEncoded()));
            }
            case 19: {
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
                return new ECSecretBCPGKey(eCPrivateKeyParameters.getD());
            }
            case 22: {
                return new EdSecretBCPGKey(new BigInteger(1, ((Ed25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded()));
            }
            case 27: {
                return new Ed25519SecretBCPGKey(((Ed25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded());
            }
            case 28: {
                return new Ed448SecretBCPGKey(((Ed448PrivateKeyParameters)asymmetricKeyParameter).getEncoded());
            }
            case 16: 
            case 20: {
                ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricKeyParameter;
                return new ElGamalSecretBCPGKey(elGamalPrivateKeyParameters.getX());
            }
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricKeyParameter;
                return new RSASecretBCPGKey(rSAPrivateCrtKeyParameters.getExponent(), rSAPrivateCrtKeyParameters.getP(), rSAPrivateCrtKeyParameters.getQ());
            }
        }
        throw new PGPException("unknown key class");
    }

    private BCPGKey getPublicBCPGKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            return new RSAPublicBCPGKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent());
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            return new DSAPublicBCPGKey(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG(), dSAPublicKeyParameters.getY());
        }
        if (asymmetricKeyParameter instanceof ElGamalPublicKeyParameters) {
            ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)asymmetricKeyParameter;
            ElGamalParameters elGamalParameters = elGamalPublicKeyParameters.getParameters();
            return new ElGamalPublicBCPGKey(elGamalParameters.getP(), elGamalParameters.getG(), elGamalPublicKeyParameters.getY());
        }
        if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
            ECNamedDomainParameters eCNamedDomainParameters = (ECNamedDomainParameters)eCPublicKeyParameters.getParameters();
            if (n == 18) {
                PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(eCNamedDomainParameters.getName(), pGPAlgorithmParameters);
                return new ECDHPublicBCPGKey(eCNamedDomainParameters.getName(), eCPublicKeyParameters.getQ(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
            }
            if (n == 19) {
                return new ECDSAPublicBCPGKey(eCNamedDomainParameters.getName(), eCPublicKeyParameters.getQ());
            }
            throw new PGPException("unknown EC algorithm");
        }
        if (n == 27) {
            byte[] byArray = new byte[32];
            ((Ed25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
            return new Ed25519PublicBCPGKey(byArray);
        }
        if (asymmetricKeyParameter instanceof Ed25519PublicKeyParameters) {
            byte[] byArray = new byte[33];
            byArray[0] = 64;
            ((Ed25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 1);
            return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, byArray));
        }
        if (asymmetricKeyParameter instanceof Ed448PublicKeyParameters) {
            byte[] byArray = new byte[57];
            ((Ed448PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
            return new Ed448PublicBCPGKey(byArray);
        }
        if (n == 25) {
            byte[] byArray = new byte[32];
            ((X25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
            return new X25519PublicBCPGKey(byArray);
        }
        if (asymmetricKeyParameter instanceof X25519PublicKeyParameters) {
            byte[] byArray = new byte[33];
            byArray[0] = 64;
            ((X25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 1);
            PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(CryptlibObjectIdentifiers.curvey25519, pGPAlgorithmParameters);
            return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, byArray), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
        }
        if (asymmetricKeyParameter instanceof X448PublicKeyParameters) {
            byte[] byArray = new byte[56];
            ((X448PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
            return new X448PublicBCPGKey(byArray);
        }
        throw new PGPException("unknown key class");
    }

    private AsymmetricKeyParameter implGetPublicKeyX509(OctetArrayBCPGKey octetArrayBCPGKey, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        byte[] byArray = Arrays.clone(octetArrayBCPGKey.getKey());
        return PublicKeyFactory.createKey(new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), Arrays.copyOfRange(byArray, 0, byArray.length)));
    }

    private AsymmetricKeyParameter implGetPublicKeyX509(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray, int n) throws IOException {
        return PublicKeyFactory.createKey(new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), Arrays.copyOfRange(byArray, n, byArray.length)));
    }

    private ECNamedDomainParameters implGetParametersEC(ECPublicBCPGKey eCPublicBCPGKey) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCPublicBCPGKey.getCurveOID();
        X9ECParameters x9ECParameters = BcUtil.getX9Parameters(aSN1ObjectIdentifier);
        return new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    private AsymmetricKeyParameter implGetPrivateKeyEC(ECPublicBCPGKey eCPublicBCPGKey, ECSecretBCPGKey eCSecretBCPGKey) throws PGPException {
        ECNamedDomainParameters eCNamedDomainParameters = this.implGetParametersEC(eCPublicBCPGKey);
        return new ECPrivateKeyParameters(eCSecretBCPGKey.getX(), (ECDomainParameters)eCNamedDomainParameters);
    }

    private AsymmetricKeyParameter implGetPrivateKeyPKCS8(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, BCPGKey bCPGKey) throws IOException {
        return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(aSN1ObjectIdentifier, BigIntegers.asUnsignedByteArray(n, ((EdSecretBCPGKey)bCPGKey).getX())));
    }

    private AsymmetricKeyParameter implGetPublicKeyEC(ECPublicBCPGKey eCPublicBCPGKey) throws PGPException {
        ECNamedDomainParameters eCNamedDomainParameters = this.implGetParametersEC(eCPublicBCPGKey);
        ECPoint eCPoint = BcUtil.decodePoint(eCPublicBCPGKey.getEncodedPoint(), eCNamedDomainParameters.getCurve());
        return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)eCNamedDomainParameters);
    }
}

