/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.InstalledFeature;
import com.ibm.ws.install.InstalledFeatureCollection;
import com.ibm.ws.install.ReapplyFixException;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.Director;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.asset.ServerAsset;
import com.ibm.ws.install.internal.asset.ServerPackageAsset;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class InstallKernelImpl
implements InstallKernel,
InstallKernelInteractive {
    private static final String FEATURE = "FEATURE";
    private static final String IFIX = "IFIX";
    private Director director = null;

    public InstallKernelImpl() {
        this.director = new Director();
    }

    public InstallKernelImpl(File installRoot) {
        this.director = new Director(installRoot);
    }

    @Override
    public void setUserAgent(String kernelUser) {
        this.director.setUserAgent(kernelUser);
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.director.setRepositoryUrl(repositoryUrl);
    }

    @Override
    public void setRepositoryProperties(Properties repoProperties) {
        this.director.setRepositoryProperties(repoProperties);
    }

    @Override
    public void addListener(InstallEventListener listener, String notificationType) {
        this.director.addListener(listener, notificationType);
    }

    @Override
    public void removeListener(InstallEventListener listener) {
        this.director.removeListener(listener);
    }

    protected void setLocale(Locale locale) {
        InstallLogUtils.Messages.setLocale(locale);
    }

    public Collection<String> install(String assetType, Collection<String> ids, String toExtension, boolean acceptLicense, InstallConstants.ExistsAction existsAction, String userId, String password) throws InstallException {
        Collection<String> installed;
        this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_INSTALL", new Object[0]));
        try {
            this.director.refresh();
            if (assetType.equalsIgnoreCase(FEATURE)) {
                this.director.installFeatures(ids, toExtension, acceptLicense, userId, password);
            } else if (assetType.equalsIgnoreCase(IFIX)) {
                this.director.installFixes(ids, userId, password);
            } else {
                InstallException e = new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNSUPPORTED_ASSETTYPE", assetType));
                this.director.log(Level.SEVERE, e.getMessage());
                this.director.log(Level.FINEST, null, e);
                throw e;
            }
            this.director.install(existsAction, false, false);
            installed = this.director.getInstalledFeatureNames();
            this.director.reapplyFixIfNeeded();
        }
        catch (ReapplyFixException e) {
            throw e;
        }
        catch (InstallException e) {
            throw e;
        }
        finally {
            this.director.setScriptsPermission(176);
            this.director.cleanUp();
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_INSTALL", new Object[0]));
        return installed;
    }

    @Override
    public Collection<String> installFeature(String featureId, String toExtension, boolean acceptLicense, InstallConstants.ExistsAction existsAction) throws InstallException {
        return this.installFeature(featureId, toExtension, acceptLicense, existsAction, null, null);
    }

    @Override
    public Collection<String> installFeature(String featureId, String toExtension, boolean acceptLicense, InstallConstants.ExistsAction existsAction, String userId, String password) throws InstallException {
        ArrayList<String> featureIds = new ArrayList<String>(1);
        if (featureId != null) {
            featureIds.add(featureId);
        }
        return this.installFeature(featureIds, toExtension, acceptLicense, existsAction, userId, password);
    }

    @Override
    public Collection<String> installFeature(Collection<String> featureIds, String toExtension, boolean acceptLicense, InstallConstants.ExistsAction existsAction) throws InstallException {
        return this.installFeature(featureIds, toExtension, acceptLicense, existsAction, null, null);
    }

    public Collection<String> installLocalFeature(String esaLocation, String toExtension, boolean acceptLicense, InstallConstants.ExistsAction existsAction) throws InstallException {
        Collection<String> installed;
        this.director.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_INSTALL_FEATURES", esaLocation));
        this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_INSTALL", new Object[0]));
        try {
            this.director.refresh();
            this.director.installFeature(esaLocation, toExtension, acceptLicense);
            this.director.install(existsAction, false, false);
            installed = this.director.getInstalledFeatureNames();
            this.director.reapplyFixIfNeeded();
        }
        catch (InstallException e) {
            throw e;
        }
        finally {
            this.director.setScriptsPermission(176);
            this.director.cleanUp();
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_INSTALL", new Object[0]));
        return installed;
    }

    public Collection<String> installLocalFeatureNoResolve(String esaLocation, String toExtension, boolean acceptLicense, InstallConstants.ExistsAction existsAction) throws InstallException {
        Collection<String> installed;
        this.director.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_INSTALL_FEATURES", esaLocation));
        this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_INSTALL", new Object[0]));
        try {
            this.director.refresh();
            this.director.installFeatureNoResolve(esaLocation, toExtension, acceptLicense);
            this.director.install(existsAction, false, false, true);
            installed = this.director.getInstalledFeatureNames();
            this.director.reapplyFixIfNeeded();
        }
        catch (InstallException e) {
            throw e;
        }
        finally {
            this.director.setScriptsPermission(176);
            this.director.cleanUp();
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_INSTALL", new Object[0]));
        return installed;
    }

    @Override
    public Collection<String> installFeature(Collection<String> featureIds, File fromDir, String toExtension, boolean acceptLicense, InstallConstants.ExistsAction existsAction, boolean offlineOnly) throws InstallException {
        Collection<String> installed;
        this.director.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_INSTALL_FEATURES", featureIds));
        this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_INSTALL", new Object[0]));
        try {
            this.director.refresh();
            this.director.installFeature(featureIds, fromDir, toExtension, acceptLicense, offlineOnly);
            this.director.install(existsAction, false, false);
            installed = this.director.getInstalledFeatureNames();
        }
        catch (InstallException e) {
            throw e;
        }
        finally {
            this.director.setScriptsPermission(176);
            this.director.cleanUp();
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_INSTALL", new Object[0]));
        return installed;
    }

    @Override
    public Collection<String> installFeature(Collection<String> featureIds, String toExtension, boolean acceptLicense, InstallConstants.ExistsAction existsAction, String userId, String password) throws InstallException {
        this.director.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_INSTALL_FEATURES", featureIds));
        return this.install(FEATURE, featureIds, toExtension, acceptLicense, existsAction, userId, password);
    }

    @Override
    public ServerPackageAsset deployServerPackage(File archiveFile, String toExtension, boolean downloadDependencies) throws InstallException {
        this.director.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_DEPLOY_FILE", archiveFile));
        this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_DEPLOY", new Object[0]));
        ServerPackageAsset spa = null;
        try {
            this.director.refresh();
            spa = this.director.resolveServerPackage(archiveFile);
            for (ServerAsset server : spa.getServers()) {
                if (!InstallUtils.serverExists(server.getServerName())) continue;
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_SERVER_PACKAGE_SERVER_ALREADY_INSTALLED", archiveFile.getAbsolutePath(), server.getServerName()), 22);
            }
            this.director.install(InstallConstants.ExistsAction.replace, true, downloadDependencies);
        }
        catch (InstallException ie) {
            throw ie;
        }
        finally {
            this.director.setScriptsPermission(176);
            this.director.cleanUp();
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_DEPLOY", new Object[0]));
        return spa;
    }

    @Override
    public Collection<String> getServerFeaturesToInstall(Set<ServerAsset> servers, boolean offlineOnly) throws InstallException, IOException {
        this.director.fireProgressEvent(8, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING_MISSING_SERVER_FEATURES", new Object[0]));
        InstallUtils.FeaturesPlatforms fep = this.director.getServerFeaturesAndPlatformsToInstall(servers, offlineOnly);
        return fep.getFeatures();
    }

    @Override
    public InstallUtils.FeaturesPlatforms getServerFeaturesAndPlatformsToInstall(Set<ServerAsset> servers, boolean offlineOnly) throws InstallException, IOException {
        this.director.fireProgressEvent(8, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING_MISSING_SERVER_FEATURES", new Object[0]));
        return this.director.getServerFeaturesAndPlatformsToInstall(servers, offlineOnly);
    }

    @Override
    public void installFix(String fixId) throws InstallException {
        this.installFix(fixId, null, null);
    }

    @Override
    public void installFix(String fixId, String userId, String password) throws InstallException {
        ArrayList<String> fixIds = new ArrayList<String>(1);
        fixIds.add(fixId);
        this.director.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_INSTALL_FIXES", fixIds));
        this.install(IFIX, fixIds, null, true, InstallConstants.ExistsAction.replace, userId, password);
    }

    private void uninstall(String assetType, Collection<String> ids, boolean force) throws InstallException {
        block7: {
            this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_UNINSTALL", new Object[0]));
            try {
                this.director.refresh();
                if (assetType.equalsIgnoreCase(FEATURE)) {
                    this.director.uninstall(ids, force);
                    break block7;
                }
                if (assetType.equalsIgnoreCase(IFIX)) {
                    this.director.uninstallFix(ids);
                    this.director.uninstall(true, (String)null, null);
                    break block7;
                }
                InstallException e = ExceptionUtils.createByKey("ERROR_UNSUPPORTED_ASSETTYPE", assetType);
                throw e;
            }
            catch (InstallException e) {
                throw e;
            }
            finally {
                this.director.setScriptsPermission(200);
                this.director.cleanUp();
            }
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_UNINSTALL", new Object[0]));
    }

    @Override
    public void uninstallFeature(String featureId, boolean force) throws InstallException {
        ArrayList<String> featureIds = new ArrayList<String>(1);
        if (featureId != null) {
            featureIds.add(featureId);
        }
        this.uninstall(FEATURE, featureIds, force);
    }

    @Override
    public void uninstallFeature(Collection<String> featureIds) throws InstallException {
        this.uninstall(FEATURE, featureIds, false);
    }

    @Override
    public void uninstallFix(String fixId) throws InstallException {
        ArrayList<String> fixIds = new ArrayList<String>(1);
        if (fixId != null) {
            fixIds.add(fixId);
        }
        this.uninstall(IFIX, fixIds, false);
    }

    @Override
    public void uninstallFix(Collection<String> fixIds) throws InstallException {
        this.director.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_UNINSTALL_FIXES", fixIds));
        this.uninstall(IFIX, fixIds, false);
    }

    public Set<InstallLicense> getLocalFeatureLicense(String esaLocation, Locale locale) throws InstallException {
        return this.director.getFeatureLicense(esaLocation, locale);
    }

    public Set<InstallLicense> getServerPackageFeatureLicense(File archive, boolean offlineOnly, Locale locale) throws InstallException {
        return this.director.getServerPackageFeatureLicense(archive, offlineOnly, locale);
    }

    public Set<InstallLicense> getServerFeatureLicense(File archive, boolean offlineOnly, Locale locale) throws InstallException, IOException {
        return this.director.getServerFeatureLicense(archive, offlineOnly, locale);
    }

    public Set<InstallLicense> getFeatureLicense(Collection<String> featureIds, File fromDir, String toExtension, boolean offlineOnly, Locale locale) throws InstallException {
        return this.director.getFeatureLicense(featureIds, fromDir, toExtension, offlineOnly, locale);
    }

    @Override
    public Set<InstallLicense> getFeatureLicense(String featureId, Locale locale) throws InstallException {
        return this.getFeatureLicense(featureId, locale, null, null);
    }

    @Override
    public Set<InstallLicense> getFeatureLicense(String featureId, Locale locale, String userId, String password) throws InstallException {
        ArrayList<String> featureIds = new ArrayList<String>(1);
        if (featureId != null) {
            featureIds.add(featureId);
        }
        return this.getFeatureLicense(featureIds, locale, userId, password);
    }

    @Override
    public Set<InstallLicense> getFeatureLicense(Collection<String> featureIds, Locale locale) throws InstallException {
        return this.getFeatureLicense(featureIds, locale, null, null);
    }

    @Override
    public Set<InstallLicense> getFeatureLicense(Collection<String> featureIds, Locale locale, String userId, String password) throws InstallException {
        return this.director.getFeatureLicense(featureIds, locale, userId, password);
    }

    @Override
    public Set<String> getInstalledLicense() {
        this.director.refresh();
        return this.director.getInstalledLicense();
    }

    @Override
    public Set<String> getInstalledFeatures(String installedBy) {
        this.director.refresh();
        return this.director.getInstalledFeatures(installedBy);
    }

    @Override
    public void enableConsoleLog(Level level) {
        boolean verbose = Level.FINEST.equals(level);
        this.director.enableConsoleLog(level, verbose);
    }

    public Map<ResourceType, List<RepositoryResource>> queryAssets(String searchStr, InstallConstants.AssetType type) throws InstallException {
        return this.director.queryAssets(searchStr, type);
    }

    public List<EsaResource> queryFeatures(String searchStr) throws InstallException {
        return this.director.queryFeatures(searchStr);
    }

    public Collection<String> downloadFeatureFeatureManager(Set<String> featureIdSet, File toDir, InstallConstants.DownloadOption downloadOption, InstallConstants.ExistsAction action, String user, String password) throws InstallException {
        Collection<String> installed;
        this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_INSTALL", new Object[0]));
        try {
            this.director.refresh();
            installed = this.director.downloadFeatureFeatureManager(featureIdSet, toDir, downloadOption, action, user, password);
        }
        catch (InstallException e) {
            throw e;
        }
        finally {
            this.director.cleanUp();
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_DOWNLOAD", new Object[0]));
        return installed;
    }

    public Map<String, Collection<String>> downloadAssetsInstallUtility(Set<String> assetIdSet, File toDir, InstallConstants.DownloadOption downloadOption, String user, String password, boolean isOverride) throws InstallException {
        Map<String, Collection<String>> installed;
        this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_DOWNLOAD", new Object[0]));
        try {
            this.director.refresh();
            installed = this.director.downloadAssetsInstallUtility(assetIdSet, toDir, downloadOption, user, password, isOverride);
        }
        catch (InstallException e) {
            throw e;
        }
        finally {
            this.director.cleanUp();
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_DOWNLOAD", new Object[0]));
        return installed;
    }

    @Override
    public void uninstallFeaturesByProductId(String productId) throws InstallException {
        this.uninstallFeaturesByProductId(productId, null);
    }

    @Override
    public void uninstallFeaturesByProductId(String productId, Collection<File> toBeDeleted) throws InstallException {
        String[] productIds = new String[]{productId};
        this.uninstallFeaturesByProductId(productIds, toBeDeleted);
    }

    @Override
    public void uninstallFeaturesByProductId(String[] productIds, Collection<File> toBeDeleted) throws InstallException {
        this.uninstallFeaturesByProductId(productIds, toBeDeleted, false);
    }

    @Override
    public void uninstallProductFeatures(String productId, Collection<File> toBeDeleted) throws InstallException {
        String[] productIds = new String[]{productId};
        this.uninstallProductFeatures(productIds, toBeDeleted);
    }

    @Override
    public void uninstallProductFeatures(String[] productIds, Collection<File> toBeDeleted) throws InstallException {
        this.uninstallFeaturesByProductId(productIds, toBeDeleted, true);
    }

    public void uninstallFeaturesByProductId(String[] productIds, Collection<File> toBeDeleted, boolean exceptPlatfromFeatuers) throws InstallException {
        this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_UNINSTALL", new Object[0]));
        try {
            this.director.refresh();
            this.director.uninstallFeaturesByProductId(productIds, exceptPlatfromFeatuers);
            this.director.uninstall(false, productIds, toBeDeleted);
        }
        catch (InstallException e) {
            throw e;
        }
        finally {
            this.director.cleanUp();
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_UNINSTALL", new Object[0]));
    }

    @Override
    public Map<String, InstalledFeature> getInstalledFeatures() {
        this.director.refresh();
        return this.director.getInstalledCoreFeatures();
    }

    @Override
    public Map<String, InstalledFeatureCollection> getInstalledFeatureCollections() {
        this.director.refresh();
        return this.director.getInstalledFeatureCollections();
    }

    @Override
    public void uninstallFeaturePrereqChecking(String featureId, boolean allowUserFeatureUninstall, boolean force) throws InstallException {
        ArrayList<String> featureIds = new ArrayList<String>();
        featureIds.add(featureId);
        this.director.uninstallFeaturesPrereqChecking(featureIds, allowUserFeatureUninstall, force);
    }

    @Override
    public void uninstallFeaturePrereqChecking(Collection<String> featureIds) throws InstallException {
        this.director.uninstallFeaturesPrereqChecking(featureIds, true, false);
    }

    @Override
    public void uninstallCoreFeaturePrereqChecking(Collection<String> featureIds) throws InstallException {
        this.director.uninstallFeaturesPrereqChecking(featureIds, false, false);
    }

    @Override
    public Map<String, Collection<String>> installAsset(Collection<String> assetIds, RepositoryConnectionList loginInfo, String proxyHost, String proxyPort, String proxyUser, String proxyPwd) throws InstallException {
        return this.installAsset(assetIds, null, loginInfo, proxyHost, proxyPort, proxyUser, proxyPwd);
    }

    @Override
    public Map<String, Collection<String>> installAsset(Collection<String> assetIds, File fromDir, RepositoryConnectionList loginInfo, String proxyHost, String proxyPort, String proxyUser, String proxyPwd) throws InstallException {
        return this.installAsset(assetIds, fromDir, loginInfo, proxyHost, proxyPort, proxyUser, proxyPwd, false);
    }

    @Override
    public Map<String, Collection<String>> installAsset(Collection<String> assetIds, File fromDir, RepositoryConnectionList loginInfo, String proxyHost, String proxyPort, String proxyUser, String proxyPwd, boolean downloadDependencies) throws InstallException {
        Map<String, Collection<String>> installed;
        this.director.fireProgressEvent(0, 0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_INSTALL", new Object[0]));
        try {
            this.director.refresh();
            RepositoryConfigUtils.setProxyAuthenticator(proxyHost, proxyPort, proxyUser, proxyPwd);
            try {
                this.director.installAssets(assetIds, loginInfo);
            }
            catch (InstallException e) {
                if (e.getRc() != 22 && fromDir != null) {
                    this.director.installAssets(assetIds, fromDir, loginInfo);
                }
                throw e;
            }
            this.director.checkResources();
            this.director.install(InstallConstants.ExistsAction.replace, true, downloadDependencies);
            installed = this.director.getInstalledAssetNames();
            this.director.reapplyFixIfNeeded();
        }
        catch (ReapplyFixException e) {
            throw e;
        }
        catch (InstallException e) {
            throw e;
        }
        finally {
            this.director.setScriptsPermission(176);
            this.director.cleanUp();
        }
        this.director.fireProgressEvent(255, 100, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_COMPLETED_INSTALL", new Object[0]));
        return installed;
    }

    @Override
    public void resolve(Collection<String> assetIds, boolean download) throws InstallException {
        this.director.refresh();
        this.director.resolve(assetIds, download);
    }

    @Override
    public void resolve(String feature, File esaFile, String toExtension) throws InstallException {
        this.director.refresh();
        this.director.resolve(feature, esaFile, toExtension);
    }

    @Override
    public void checkResources() throws InstallException {
        this.director.checkResources();
    }

    @Override
    public Set<InstallLicense> getFeatureLicense(Locale locale) throws InstallException {
        return this.director.getFeatureLicense(locale);
    }

    @Override
    public Collection<String> getSampleLicense(Locale locale) throws InstallException {
        return this.director.getSampleLicense(locale);
    }

    @Override
    public Collection<String> getSamplesOrOpenSources() {
        return this.director.getSamplesOrOpenSources();
    }

    @Override
    public int getInstallResourcesSize() {
        return this.director.getInstallResourcesSize();
    }

    @Override
    public int getLocalInstallAssetsSize() {
        return this.director.getLocalInstallAssetsSize();
    }

    @Override
    public int getPublicInstallResourcesSize() {
        return this.director.getPublicInstallResourcesSize();
    }

    @Override
    public int getPublicLocalInstallAssetsSize() {
        return this.director.getPublicLocalInstallAssetsSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Collection<String>> install(String toExtension, boolean rollbackAll, boolean downloadDependencies) throws InstallException {
        Map<String, Collection<String>> installed;
        try {
            this.director.downloadAssets(toExtension);
            this.director.log(Level.FINEST, "install(String toExtension, boolean rollbackAll,boolean downloadDependencies) - com.ibm.websphere.install.utility.ignoreWhenFileExists:" + InstallConstants.IGNORE_FILE_OPTION);
            if (Boolean.valueOf(InstallConstants.IGNORE_FILE_OPTION).booleanValue()) {
                this.director.install(InstallConstants.ExistsAction.ignore, rollbackAll, downloadDependencies);
            } else {
                this.director.install(InstallConstants.ExistsAction.replace, rollbackAll, downloadDependencies);
            }
            installed = this.director.getInstalledAssetNames();
            this.director.reapplyFixIfNeeded();
        }
        finally {
            this.director.setScriptsPermission(176);
            this.director.cleanUp();
        }
        return installed;
    }

    @Override
    public RepositoryConnectionList getLoginInfo() throws InstallException {
        return this.director.getRepositoryConnectionList();
    }

    @Override
    public void setLoginInfo(RepositoryConnectionList loginInfo) {
        this.director.setLoginInfo(loginInfo);
    }

    @Override
    public void setProxy(RestRepositoryConnectionProxy proxy) {
        this.director.setProxy(proxy);
    }

    @Override
    public void setFirePublicAssetOnly(boolean firePublicAssetOnly) {
        this.director.setFirePublicAssetOnly(firePublicAssetOnly);
    }

    @Override
    public boolean resolveExistingAssetsFromDirectoryRepo(Collection<String> featureNames, File repoDir, boolean isOverwrite) throws InstallException {
        return this.director.resolveExistingAssetsFromDirectoryRepo(featureNames, repoDir, isOverwrite);
    }

    @Override
    public void checkAssetsNotInstalled(Collection<String> assetIds) throws InstallException {
        this.director.checkAssetsNotInstalled(assetIds, false);
    }

    @Override
    public void checkAssetsNotInstalled(Collection<String> assetIds, boolean installingFeature) throws InstallException {
        this.director.checkAssetsNotInstalled(assetIds, installingFeature);
    }
}

