/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.FileSystem;
import com.ibm.ws.kernel.service.util.MemoryInformationException;
import com.ibm.ws.kernel.service.util.OperatingSystem;
import com.ibm.ws.kernel.service.util.OperatingSystemException;
import com.ibm.ws.kernel.service.util.OperatingSystemType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MemoryInformation {
    private static final TraceComponent tc = Tr.register(MemoryInformation.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    public static final long BYTES_IN_KB = 1024L;
    public static final long BYTES_IN_MB = 0x100000L;
    public static final long BYTES_IN_GB = 0x40000000L;
    public static final long BYTES_IN_TB = 0x10000000000L;
    public static final long BYTES_IN_PB = 0x4000000000000L;
    public static final long BYTES_IN_EB = 0x1000000000000000L;
    private final boolean cacheTotalRam;
    private long cachedTotalRam = -1L;
    private final boolean useLightweightAvailableRam;
    private static final MemoryInformation instance = new MemoryInformation();
    private static final Pattern spacePattern = Pattern.compile("\\s+");
    private static OperatingSystemMXBean osMxBean;
    private static MBeanServer mBeanServer;
    private static ObjectName osObjectName;
    private static String totalPhysicalMemoryAttribute;
    private static final DecimalFormat commaFormatter;
    private static final DecimalFormat percentFormatter;
    private static final DateFormat df;
    static final long serialVersionUID = 7343445230307238737L;

    public static MemoryInformation instance() {
        return instance;
    }

    public synchronized long getTotalMemory() throws MemoryInformationException {
        if (this.cacheTotalRam && this.cachedTotalRam != -1L) {
            return this.cachedTotalRam;
        }
        long result = -1L;
        if (OperatingSystem.instance().getOperatingSystemType() == OperatingSystemType.Linux && FileSystem.fileExists("/sys/fs/cgroup/memory/memory.limit_in_bytes")) {
            try {
                result = this.getTotalMemoryLinuxContainer();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.service.util.MemoryInformation", (String)"81", (Object)this, (Object[])new Object[0]);
            }
        }
        if (result == -1L) {
            try {
                result = this.getTotalMemoryJDK();
            }
            catch (MemoryInformationException memoryInformationException) {
                FFDCFilter.processException((Throwable)memoryInformationException, (String)"com.ibm.ws.kernel.service.util.MemoryInformation", (String)"90", (Object)this, (Object[])new Object[0]);
            }
        }
        if (result == -1L) {
            switch (OperatingSystem.instance().getOperatingSystemType()) {
                case Linux: {
                    result = this.getTotalMemoryLinux();
                    break;
                }
                case AIX: {
                    result = this.getTotalMemoryAix();
                    break;
                }
                case Mac: {
                    result = this.getTotalMemoryMac();
                    break;
                }
                case Windows: {
                    result = this.getTotalMemoryWindows();
                    break;
                }
                case HPUX: {
                    result = this.getTotalMemoryHp();
                    break;
                }
                case IBMi: {
                    result = this.getTotalMemoryIBMi();
                    break;
                }
                case Solaris: {
                    result = this.getTotalMemorySolaris();
                    break;
                }
                case zOS: {
                    result = this.getTotalMemoryzOS();
                    break;
                }
                default: {
                    throw this.getNotImplementedException();
                }
            }
        }
        if (this.cacheTotalRam) {
            this.cachedTotalRam = result;
        }
        return result;
    }

    public long getAvailableMemory() throws MemoryInformationException {
        if (this.useLightweightAvailableRam) {
            try {
                return this.getFreeMemoryJDK();
            }
            catch (MemoryInformationException memoryInformationException) {
                FFDCFilter.processException((Throwable)memoryInformationException, (String)"com.ibm.ws.kernel.service.util.MemoryInformation", (String)"218", (Object)this, (Object[])new Object[0]);
            }
        }
        switch (OperatingSystem.instance().getOperatingSystemType()) {
            case Linux: {
                return this.getAvailableMemoryLinux();
            }
            case AIX: {
                return this.getAvailableMemoryAix();
            }
            case Mac: {
                return this.getAvailableMemoryMac();
            }
            case Windows: {
                return this.getAvailableMemoryWindows();
            }
            case HPUX: {
                return this.getAvailableMemoryHp();
            }
            case IBMi: {
                return this.getAvailableMemoryIBMi();
            }
            case Solaris: {
                return this.getAvailableMemorySolaris();
            }
            case zOS: {
                return this.getAvailableMemoryzOS();
            }
        }
        throw this.getNotImplementedException();
    }

    public float getAvailableMemoryRatio() throws MemoryInformationException {
        long totalMemory = this.getTotalMemory();
        long availableMemory = this.getAvailableMemory();
        return (float)((double)availableMemory / (double)totalMemory);
    }

    public MemoryInformation() {
        this(true, false);
    }

    public MemoryInformation(boolean cacheTotalRam, boolean useLightweightAvailableRam) {
        this.cacheTotalRam = cacheTotalRam;
        this.useLightweightAvailableRam = useLightweightAvailableRam;
    }

    public static long inferBytes(String line) throws MemoryInformationException {
        long modifier = 1L;
        if ((line = line.toLowerCase()).contains("kb")) {
            modifier = 1024L;
            line = line.replaceAll("kb", "");
        } else if (line.contains("kilobytes")) {
            modifier = 1024L;
            line = line.replaceAll("kilobytes", "");
        } else if (line.contains("mb")) {
            modifier = 0x100000L;
            line = line.replaceAll("mb", "");
        } else if (line.contains("megabytes")) {
            modifier = 0x100000L;
            line = line.replaceAll("megabytes", "");
        } else if (line.contains("gb")) {
            modifier = 0x40000000L;
            line = line.replaceAll("gb", "");
        } else if (line.contains("gigabytes")) {
            modifier = 0x40000000L;
            line = line.replaceAll("gigabytes", "");
        } else if (line.contains("tb")) {
            modifier = 0x10000000000L;
            line = line.replaceAll("tb", "");
        } else if (line.contains("terabytes")) {
            modifier = 0x10000000000L;
            line = line.replaceAll("terabytes", "");
        } else if (line.contains("pb")) {
            modifier = 0x4000000000000L;
            line = line.replaceAll("pb", "");
        } else if (line.contains("petabytes")) {
            modifier = 0x4000000000000L;
            line = line.replaceAll("petabytes", "");
        } else if (line.contains("eb")) {
            modifier = 0x1000000000000000L;
            line = line.replaceAll("eb", "");
        } else if (line.contains("exabytes")) {
            modifier = 0x1000000000000000L;
            line = line.replaceAll("exabytes", "");
        } else {
            line = line.replaceAll("b", "");
            line = line.replaceAll("bytes", "");
        }
        return Long.parseLong(line.trim()) * modifier;
    }

    private MemoryInformationException getNotImplementedException() {
        return new MemoryInformationException("Unimplemented operating system " + (Object)((Object)OperatingSystem.instance().getOperatingSystemType()) + " (" + System.getProperty("os.name") + ")");
    }

    private long getTotalMemoryLinuxContainer() throws NumberFormatException, FileNotFoundException, IOException {
        String limitInBytes;
        long result = -1L;
        if (FileSystem.fileExists("/sys/fs/cgroup/memory/memory.limit_in_bytes") && (limitInBytes = FileSystem.readFirstLine("/sys/fs/cgroup/memory/memory.limit_in_bytes")) != null && !limitInBytes.equals("18446744073709551615") && (result = Long.parseLong(limitInBytes)) == 0x7FFFFFFFFFFFF000L) {
            result = -1L;
        }
        return result;
    }

    @FFDCIgnore(value={IOException.class})
    private long getTotalMemoryLinux() throws MemoryInformationException {
        try {
            long cgroupLimit = this.getTotalMemoryLinuxContainer();
            if (cgroupLimit > 0L) {
                return cgroupLimit;
            }
            List<String> lines = FileSystem.readAllLines("/proc/meminfo");
            for (String meminfoLine : lines) {
                if (!meminfoLine.startsWith("MemTotal:")) continue;
                return this.parseLinuxMeminfoLine(meminfoLine);
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"/proc/meminfo", lines}));
        }
        catch (IOException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long parseLinuxMeminfoLine(String line) throws MemoryInformationException {
        line = line.substring(line.indexOf(58) + 1).trim();
        int i = line.lastIndexOf(32);
        int modifier = 1;
        if (i != -1) {
            String modifierString = line.substring(i + 1);
            line = line.substring(0, i);
            if (modifierString.equals("kB")) {
                modifier = 1024;
            } else {
                throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"/proc/meminfo", modifierString}));
            }
        }
        return Long.parseLong(line) * (long)modifier;
    }

    @FFDCIgnore(value={IOException.class, OperatingSystemException.class})
    private long getAvailableMemoryLinux() throws MemoryInformationException {
        try {
            long cgroupLimit = this.getTotalMemoryLinuxContainer();
            if (cgroupLimit > 0L && FileSystem.fileExists("/sys/fs/cgroup/memory/memory.stat")) {
                List<String> memoryStatLines = FileSystem.readAllLines("/sys/fs/cgroup/memory/memory.stat");
                long activeFile = -1L;
                long selfActiveFile = -1L;
                long inactiveFile = -1L;
                long selfInactiveFile = -1L;
                long used = -1L;
                long selfUsed = -1L;
                for (String memoryStatLine : memoryStatLines) {
                    if (memoryStatLine.startsWith("total_active_file")) {
                        activeFile = Long.parseLong(memoryStatLine.substring(memoryStatLine.indexOf(32) + 1));
                        continue;
                    }
                    if (memoryStatLine.startsWith("total_inactive_file")) {
                        inactiveFile = Long.parseLong(memoryStatLine.substring(memoryStatLine.indexOf(32) + 1));
                        continue;
                    }
                    if (memoryStatLine.startsWith("total_rss")) {
                        used = Long.parseLong(memoryStatLine.substring(memoryStatLine.indexOf(32) + 1));
                        continue;
                    }
                    if (memoryStatLine.startsWith("active_file")) {
                        selfActiveFile = Long.parseLong(memoryStatLine.substring(memoryStatLine.indexOf(32) + 1));
                        continue;
                    }
                    if (memoryStatLine.startsWith("inactive_file")) {
                        selfInactiveFile = Long.parseLong(memoryStatLine.substring(memoryStatLine.indexOf(32) + 1));
                        continue;
                    }
                    if (!memoryStatLine.startsWith("rss")) continue;
                    selfUsed = Long.parseLong(memoryStatLine.substring(memoryStatLine.indexOf(32) + 1));
                }
                if (used == -1L) {
                    used = selfUsed;
                }
                if (activeFile == -1L) {
                    activeFile = selfActiveFile;
                }
                if (inactiveFile == -1L) {
                    inactiveFile = selfInactiveFile;
                }
                if (activeFile != -1L && inactiveFile != -1L) {
                    long available = cgroupLimit - used + this.applySwappiness(activeFile + inactiveFile);
                    if (available >= cgroupLimit) {
                        available = cgroupLimit - used;
                    }
                    return available;
                }
                if (used != -1L) {
                    return cgroupLimit - used;
                }
            }
            long fileCache = 0L;
            long slabReclaimable = 0L;
            long buffers = 0L;
            long cached = 0L;
            long free = 0L;
            List<String> lines = FileSystem.readAllLines("/proc/meminfo");
            for (String meminfoLine : lines) {
                if (meminfoLine.startsWith("MemAvailable:")) {
                    return this.parseLinuxMeminfoLine(meminfoLine);
                }
                if (meminfoLine.startsWith("MemFree:")) {
                    free = this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (meminfoLine.startsWith("Cached:")) {
                    cached = this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (meminfoLine.startsWith("Buffers:")) {
                    buffers = this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (meminfoLine.startsWith("SReclaimable:")) {
                    slabReclaimable = this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (meminfoLine.startsWith("Active(file):")) {
                    fileCache += this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (!meminfoLine.startsWith("Inactive(file):")) continue;
                fileCache += this.parseLinuxMeminfoLine(meminfoLine);
            }
            long watermark_low = 0L;
            for (String zoneinfoLine : FileSystem.readAllLines("/proc/zoneinfo")) {
                if (!(zoneinfoLine = zoneinfoLine.trim()).startsWith("low")) continue;
                watermark_low += Long.parseLong(zoneinfoLine.substring(3).trim());
            }
            long availableFallback = 0L;
            if (fileCache > 0L && slabReclaimable > 0L && (watermark_low *= (long)OperatingSystem.getPageSize()) > 0L) {
                fileCache -= Math.min(fileCache / 2L, watermark_low);
                availableFallback = free - watermark_low + fileCache + slabReclaimable - Math.min(slabReclaimable / 2L, watermark_low);
            } else {
                availableFallback = free + buffers + this.applySwappiness(cached);
            }
            if (availableFallback > 0L) {
                return availableFallback;
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"/proc/meminfo", lines}));
        }
        catch (IOException e) {
            throw new MemoryInformationException(e);
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long applySwappiness(long cached) throws IOException, MemoryInformationException {
        int swappiness = MemoryInformation.getSwappiness();
        if (swappiness >= 50) {
            cached = (long)((double)cached * ((double)(100 - swappiness) / 100.0));
        }
        return cached;
    }

    @FFDCIgnore(value={IOException.class})
    public static synchronized int getSwappiness() throws MemoryInformationException {
        try {
            String fileToRead = "/proc/sys/vm/swappiness";
            if (FileSystem.fileExists("/sys/fs/cgroup/memory/memory.swappiness")) {
                fileToRead = "/sys/fs/cgroup/memory/memory.swappiness";
            }
            return Integer.parseInt(FileSystem.readFirstLine(fileToRead));
        }
        catch (IOException e) {
            throw new MemoryInformationException(e);
        }
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getTotalMemoryMac() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("/usr/sbin/sysctl", "hw.memsize");
            if (lines.size() == 1) {
                String line = lines.get(0);
                int i = line.indexOf(": ");
                if (i != -1) {
                    return Long.parseLong(line.substring(i + 2));
                }
                throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"/usr/sbin/sysctl", lines}));
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"/usr/sbin/sysctl", lines}));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getAvailableMemoryMac() throws MemoryInformationException {
        try {
            long available = 0L;
            List<String> vmstatLines = OperatingSystem.executeProgram("/usr/bin/vm_stat");
            for (String vmstatLine : vmstatLines) {
                if (vmstatLine.startsWith("Pages free:")) {
                    available += this.processMacVmStatLine(vmstatLine);
                    continue;
                }
                if (vmstatLine.startsWith("Pages inactive:")) {
                    available += this.processMacVmStatLine(vmstatLine);
                    continue;
                }
                if (vmstatLine.startsWith("Pages speculative:")) {
                    available += this.processMacVmStatLine(vmstatLine);
                    continue;
                }
                if (!vmstatLine.startsWith("File-backed pages:")) continue;
                available += this.processMacVmStatLine(vmstatLine);
            }
            if (available <= 0L) {
                throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"vm_stat", vmstatLines}));
            }
            return available *= (long)OperatingSystem.getPageSize();
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long processMacVmStatLine(String line) {
        line = line.substring(line.indexOf(58) + 1).trim();
        line = line.substring(0, line.length() - 1);
        return Long.parseLong(line);
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getTotalMemoryWindows() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("wmic", "os", "get", "totalvisiblememorysize", "/format:list");
            for (String line : lines) {
                if (!line.startsWith("TotalVisibleMemorySize=")) continue;
                return this.processWmicLine(line) * 1024L;
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"wmic", lines}));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long processWmicLine(String line) {
        return Long.parseLong(line.substring(line.indexOf(61) + 1));
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getAvailableMemoryWindows() throws MemoryInformationException {
        try {
            long available = 0L;
            List<String> lines = OperatingSystem.executeProgram("wmic", "path", "Win32_PerfFormattedData_PerfOS_Memory", "get", "/format:list");
            for (String line : lines) {
                if (line.startsWith("AvailableBytes=")) {
                    available += this.processWmicLine(line);
                    continue;
                }
                if (!line.startsWith("CacheBytes=")) continue;
                available += this.processWmicLine(line);
            }
            if (available <= 0L) {
                throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"wmic", lines}));
            }
            return available;
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getTotalMemoryAix() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("/usr/sbin/lsattr", "-El", "sys0");
            for (String line : lines) {
                if (!line.startsWith("realmem")) continue;
                line = line.substring(7);
                line = line.substring(0, line.indexOf("Amount"));
                line = line.trim();
                return Long.parseLong(line) * 1024L;
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"lsattr", lines}));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getAvailableMemoryAix() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("/usr/bin/svmon", "-O", "summary=basic,unit=KB");
            for (String line : lines) {
                if (!line.startsWith("memory")) continue;
                String[] pieces = spacePattern.split(line);
                if (pieces.length >= 7) {
                    return Long.parseLong(pieces[6]) * 1024L;
                }
                throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"svmon", lines}));
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"svmon", lines}));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getTotalMemoryHp() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("vmstat", "1", "1");
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).trim().startsWith("r")) continue;
                String[] pieces = spacePattern.split(lines.get(i + 2));
                return (Long.parseLong(pieces[3]) + Long.parseLong(pieces[4])) * 1024L;
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"vmstat", lines}));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getAvailableMemoryHp() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("vmstat", "1", "1");
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).trim().startsWith("r")) continue;
                String[] pieces = spacePattern.split(lines.get(i + 2));
                return Long.parseLong(pieces[4]) * 1024L;
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"vmstat", lines}));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getTotalMemoryIBMi() throws MemoryInformationException {
        return this.getTotalMemoryJDK();
    }

    private long getAvailableMemoryIBMi() throws MemoryInformationException {
        return this.getFreeMemoryJDK();
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getTotalMemorySolaris() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("prtconf");
            for (String line : lines) {
                if (!line.toLowerCase().startsWith("memory")) continue;
                line = line.substring(line.indexOf(58) + 1).trim();
                return MemoryInformation.inferBytes(line);
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"prtdiag", lines}));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    @FFDCIgnore(value={OperatingSystemException.class})
    private long getAvailableMemorySolaris() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("vmstat", "1", "1");
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).trim().startsWith("r")) continue;
                String[] pieces = spacePattern.split(lines.get(i + 2));
                return Long.parseLong(pieces[4]) * 1024L;
            }
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unexpected", (Object[])new Object[]{"vmstat", lines}));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getTotalMemoryzOS() throws MemoryInformationException {
        return this.getTotalMemoryJDK();
    }

    private long getAvailableMemoryzOS() throws MemoryInformationException {
        long result = this.getFreeMemoryJDK();
        if (result <= 0L) {
            throw new MemoryInformationException(Tr.formatMessage((TraceComponent)tc, (String)"memory.information.unavailable", (Object[])new Object[0]));
        }
        return result;
    }

    @FFDCIgnore(value={MalformedObjectNameException.class, MBeanException.class})
    private synchronized void ensureInitializedMBean() throws MemoryInformationException {
        if (osMxBean == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ensureInitializedMBean needs initialization", (Object[])new Object[0]);
            }
            osMxBean = ManagementFactory.getOperatingSystemMXBean();
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                osObjectName = new ObjectName("java.lang", "type", "OperatingSystem");
                try {
                    mBeanServer.getAttribute(osObjectName, "TotalPhysicalMemory");
                    totalPhysicalMemoryAttribute = "TotalPhysicalMemory";
                }
                catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Could not find TotalPhysicalMemory attribute", (Object[])new Object[]{e});
                    }
                    totalPhysicalMemoryAttribute = "TotalPhysicalMemorySize";
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Set totalPhysicalMemoryAttribute to " + totalPhysicalMemoryAttribute), (Object[])new Object[0]);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new MemoryInformationException(e);
            }
        }
    }

    @FFDCIgnore(value={Throwable.class})
    private synchronized long getTotalMemoryJDK() throws MemoryInformationException {
        try {
            this.ensureInitializedMBean();
            return (Long)mBeanServer.getAttribute(osObjectName, totalPhysicalMemoryAttribute);
        }
        catch (Throwable e) {
            throw new MemoryInformationException(e);
        }
    }

    @FFDCIgnore(value={Throwable.class})
    private synchronized long getFreeMemoryJDK() throws MemoryInformationException {
        try {
            this.ensureInitializedMBean();
            return (Long)mBeanServer.getAttribute(osObjectName, "FreePhysicalMemorySize");
        }
        catch (Throwable e) {
            throw new MemoryInformationException(e);
        }
    }

    public static void main(String ... args) throws Throwable {
        MemoryInformation.out(MemoryInformation.class.getName() + " started");
        MemoryInformation.out("Operating System      : " + String.format("%15s", new Object[]{OperatingSystem.instance().getOperatingSystemType()}));
        MemoryInformation.out("Available memory      : " + String.format("%15s", commaFormatter.format(MemoryInformation.instance().getAvailableMemory())));
        MemoryInformation.out("Available memory (JDK): " + String.format("%15s", commaFormatter.format(new MemoryInformation(true, true).getAvailableMemory())));
        MemoryInformation.out("Total memory          : " + String.format("%15s", commaFormatter.format(MemoryInformation.instance().getTotalMemory())));
        MemoryInformation.out("Available memory %    : " + String.format("%15s", percentFormatter.format((double)MemoryInformation.instance().getAvailableMemoryRatio() * 100.0)));
    }

    private static void out(String message) {
        System.out.println("[" + df.format(new Date()) + "] " + message);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        commaFormatter = new DecimalFormat("#,###");
        percentFormatter = new DecimalFormat("#.00");
        df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }
}

