/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.server.internal;

import com.ibm.websphere.kernel.server.ServerEndpointControlMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.launch.service.PauseableComponent;
import com.ibm.ws.kernel.launch.service.PauseableComponentController;
import com.ibm.ws.kernel.launch.service.PauseableComponentControllerRequestFailedException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ServerEndpointControlMBean.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "jmx.objectname=WebSphere:feature=kernel,name=ServerEndpointControl"})
public class ServerEndpointControlMBeanImpl
extends StandardMBean
implements ServerEndpointControlMBean {
    @Reference(service=PauseableComponentController.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    private PauseableComponentController pauseableComponentController;
    static final long serialVersionUID = -7623810533791328837L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ServerEndpointControlMBeanImpl() throws NotCompliantMBeanException {
        super(ServerEndpointControlMBean.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void pause() throws MBeanException {
        try {
            this.pauseableComponentController.pause();
        }
        catch (PauseableComponentControllerRequestFailedException pauseableComponentControllerRequestFailedException) {
            void ex;
            FFDCFilter.processException((Throwable)pauseableComponentControllerRequestFailedException, (String)"com.ibm.ws.kernel.server.internal.ServerEndpointControlMBeanImpl", (String)"72", (Object)this, (Object[])new Object[0]);
            throw new MBeanException(new Exception(ex.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void pause(String targets) throws MBeanException {
        try {
            this.pauseableComponentController.pause(targets);
        }
        catch (PauseableComponentControllerRequestFailedException pauseableComponentControllerRequestFailedException) {
            void ex;
            FFDCFilter.processException((Throwable)pauseableComponentControllerRequestFailedException, (String)"com.ibm.ws.kernel.server.internal.ServerEndpointControlMBeanImpl", (String)"88", (Object)this, (Object[])new Object[]{targets});
            throw new MBeanException(new Exception(ex.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resume() throws MBeanException {
        try {
            this.pauseableComponentController.resume();
        }
        catch (PauseableComponentControllerRequestFailedException pauseableComponentControllerRequestFailedException) {
            void ex;
            FFDCFilter.processException((Throwable)pauseableComponentControllerRequestFailedException, (String)"com.ibm.ws.kernel.server.internal.ServerEndpointControlMBeanImpl", (String)"104", (Object)this, (Object[])new Object[0]);
            throw new MBeanException(new Exception(ex.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resume(String targets) throws MBeanException {
        try {
            this.pauseableComponentController.resume(targets);
        }
        catch (PauseableComponentControllerRequestFailedException pauseableComponentControllerRequestFailedException) {
            void ex;
            FFDCFilter.processException((Throwable)pauseableComponentControllerRequestFailedException, (String)"com.ibm.ws.kernel.server.internal.ServerEndpointControlMBeanImpl", (String)"120", (Object)this, (Object[])new Object[]{targets});
            throw new MBeanException(new Exception(ex.getLocalizedMessage()));
        }
    }

    @Override
    public boolean isPaused() {
        return this.pauseableComponentController.isPaused();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isPaused(String targets) throws MBeanException {
        try {
            return this.pauseableComponentController.isPaused(targets);
        }
        catch (PauseableComponentControllerRequestFailedException pauseableComponentControllerRequestFailedException) {
            void ex;
            FFDCFilter.processException((Throwable)pauseableComponentControllerRequestFailedException, (String)"com.ibm.ws.kernel.server.internal.ServerEndpointControlMBeanImpl", (String)"146", (Object)this, (Object[])new Object[]{targets});
            throw new MBeanException(new Exception(ex.getLocalizedMessage()));
        }
    }

    @Override
    public List<String> listEndpoints() {
        Collection pauseableComponents = this.pauseableComponentController.getPauseableComponents();
        ArrayList<String> endpoints = new ArrayList<String>();
        for (PauseableComponent pauseableComponent : pauseableComponents) {
            endpoints.add(pauseableComponent.getName());
        }
        return endpoints;
    }

    @Override
    protected final String getDescription(MBeanInfo info) {
        return "MBean to pause or resume a server endpoint.";
    }

    @Override
    protected final String getDescription(MBeanOperationInfo info) {
        String opName = info.getName();
        String opDescription = new String();
        switch (opName) {
            case "listEndpoints": {
                opDescription = "Returns the name of all endpoints that can be paused/resumed";
                break;
            }
            case "isPaused": {
                opDescription = "Returns true if the server endpoint(s) specified by target(s) is paused, otherwise false.";
                break;
            }
            case "resume": {
                opDescription = "Resumes the server endpoint(s) specified by target(s)";
                break;
            }
            case "pause": {
                opDescription = "Pauses the server endpoint(s) specified by target(s)";
                break;
            }
            default: {
                opDescription = "Operation exposed for management";
            }
        }
        return opDescription;
    }

    @Override
    public boolean isActive(String targets) {
        return this.pauseableComponentController.isActive(targets);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.server.internal.ServerEndpointControlMBeanImpl", ServerEndpointControlMBeanImpl.class, null, null);
    }
}

