/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.LogQueryBean;
import com.ibm.websphere.logging.hpel.reader.LogRepositoryException;
import com.ibm.websphere.logging.hpel.reader.LogRepositoryRuntimeException;
import com.ibm.websphere.logging.hpel.reader.RemoteAllResults;
import com.ibm.websphere.logging.hpel.reader.RemoteInstanceDetails;
import com.ibm.websphere.logging.hpel.reader.RemoteInstanceResult;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import com.ibm.websphere.logging.hpel.reader.RepositoryReader;
import com.ibm.websphere.logging.hpel.reader.ServerInstanceLogRecordList;
import com.ibm.ws.logging.hpel.impl.RemoteLogRecordIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRemoteRepositoryReader
implements RepositoryReader {
    private static final String thisClass = AbstractRemoteRepositoryReader.class.getName();
    private static final Logger logger = Logger.getLogger(thisClass);
    private final Locale locale;
    private final int maxRecords;

    protected AbstractRemoteRepositoryReader(Locale locale) {
        this(-1, locale);
    }

    protected AbstractRemoteRepositoryReader(int maxRecords, Locale locale) {
        this.locale = locale;
        this.maxRecords = maxRecords;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    private Iterator<RepositoryLogRecord> getIterator(RemoteInstanceDetails indicator, RepositoryPointer after, int offset, int length) {
        return new RemoteLogRecordIterator(this, indicator, after, offset, length, this.locale);
    }

    private ServerInstanceLogRecordList getLogListForServerInstance(RemoteInstanceDetails instance, final RepositoryPointer after) throws LogRepositoryException {
        RemoteInstanceResult result = this.readLogRecords(instance, after, 0, 0, this.locale);
        final RemoteInstanceDetails indicator = new RemoteInstanceDetails(instance.query, result.getStartTime(), instance.procPath);
        indicator.setCache(result.getCache());
        final Properties header = result.getLogHeader();
        final Set<String> subProcs = result.getSubProcs();
        return new ServerInstanceLogRecordList(){

            @Override
            public Properties getHeader() {
                return header;
            }

            @Override
            public Iterable<RepositoryLogRecord> range(final int offset, final int length) {
                return new Iterable<RepositoryLogRecord>(){

                    @Override
                    public Iterator<RepositoryLogRecord> iterator() {
                        return AbstractRemoteRepositoryReader.this.getIterator(indicator, after, offset, length);
                    }
                };
            }

            @Override
            public Iterator<RepositoryLogRecord> iterator() {
                return AbstractRemoteRepositoryReader.this.getIterator(indicator, after, 0, -1);
            }

            @Override
            public Map<String, ServerInstanceLogRecordList> getChildren() {
                return new AbstractMap<String, ServerInstanceLogRecordList>(){

                    @Override
                    public Set<Map.Entry<String, ServerInstanceLogRecordList>> entrySet() {
                        return new AbstractSet<Map.Entry<String, ServerInstanceLogRecordList>>(){

                            @Override
                            public Iterator<Map.Entry<String, ServerInstanceLogRecordList>> iterator() {
                                return new Iterator<Map.Entry<String, ServerInstanceLogRecordList>>(){
                                    final Iterator<String> it;
                                    {
                                        this.it = subProcs.iterator();
                                    }

                                    @Override
                                    public boolean hasNext() {
                                        return this.it.hasNext();
                                    }

                                    @Override
                                    public Map.Entry<String, ServerInstanceLogRecordList> next() {
                                        final String key = this.it.next();
                                        return new Map.Entry<String, ServerInstanceLogRecordList>(){

                                            @Override
                                            public String getKey() {
                                                return key;
                                            }

                                            @Override
                                            public ServerInstanceLogRecordList getValue() {
                                                String[] subKeys = Arrays.copyOf(indicator.getProcPath(), indicator.getProcPath().length + 1);
                                                subKeys[subKeys.length - 1] = key;
                                                RemoteInstanceDetails kidIndicator = new RemoteInstanceDetails(indicator.query, indicator.startTime, subKeys);
                                                try {
                                                    return AbstractRemoteRepositoryReader.this.getLogListForServerInstance(kidIndicator, null);
                                                }
                                                catch (LogRepositoryException e) {
                                                    throw new LogRepositoryRuntimeException(e);
                                                }
                                            }

                                            @Override
                                            public ServerInstanceLogRecordList setValue(ServerInstanceLogRecordList object) {
                                                throw new UnsupportedOperationException("This class is a read-only implementation");
                                            }
                                        };
                                    }

                                    @Override
                                    public void remove() {
                                        throw new UnsupportedOperationException("This class is a read-only implementation");
                                    }
                                };
                            }

                            @Override
                            public int size() {
                                return subProcs.size();
                            }
                        };
                    }
                };
            }

            @Override
            public Date getStartTime() {
                return indicator.startTime;
            }
        };
    }

    @Override
    public ServerInstanceLogRecordList getLogListForCurrentServerInstance() throws LogRepositoryException {
        return this.getLogListForServerInstance((Date)null);
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(Date time) throws LogRepositoryException {
        logger.entering(thisClass, "getLogListForServerInstance", time);
        LogQueryBean query = new LogQueryBean();
        ServerInstanceLogRecordList result = this.getLogListForServerInstance(new RemoteInstanceDetails(query, time, new String[0]), null);
        logger.exiting(thisClass, "getLogListForServerInstance", result);
        return result;
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after) throws LogRepositoryException {
        logger.entering(thisClass, "getLogListForServerInstance", after);
        LogQueryBean query = new LogQueryBean();
        ServerInstanceLogRecordList result = this.getLogListForServerInstance(new RemoteInstanceDetails(query, null, new String[0]), after);
        logger.exiting(thisClass, "getLogListForServerInstance", result);
        return result;
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(Date time, Level minLevel, Level maxLevel) throws LogRepositoryException {
        logger.entering(thisClass, "getLogListForServerInstance", new Object[]{time, minLevel, maxLevel});
        LogQueryBean query = new LogQueryBean();
        query.setLevels(minLevel, maxLevel);
        ServerInstanceLogRecordList result = this.getLogListForServerInstance(new RemoteInstanceDetails(query, time, new String[0]), null);
        logger.exiting(thisClass, "getLogListForServerInstance", result);
        return result;
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after, Level minLevel, Level maxLevel) throws LogRepositoryException {
        logger.entering(thisClass, "getLogListForServerInstance", new Object[]{after, minLevel, maxLevel});
        LogQueryBean query = new LogQueryBean();
        query.setLevels(minLevel, maxLevel);
        ServerInstanceLogRecordList result = this.getLogListForServerInstance(new RemoteInstanceDetails(query, null, new String[0]), after);
        logger.exiting(thisClass, "getLogListForServerInstance", result);
        return result;
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(Date time, int threadID) throws LogRepositoryException {
        logger.entering(thisClass, "getLogListForServerInstance", new Object[]{time, threadID});
        LogQueryBean query = new LogQueryBean();
        query.setThreadIDs(new String[]{Integer.toHexString(threadID)});
        ServerInstanceLogRecordList result = this.getLogListForServerInstance(new RemoteInstanceDetails(query, time, new String[0]), null);
        logger.exiting(thisClass, "getLogListForServerInstance", result);
        return result;
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after, int threadID) throws LogRepositoryException {
        logger.entering(thisClass, "getLogListForServerInstance", new Object[]{after, threadID});
        LogQueryBean query = new LogQueryBean();
        query.setThreadIDs(new String[]{Integer.toHexString(threadID)});
        ServerInstanceLogRecordList result = this.getLogListForServerInstance(new RemoteInstanceDetails(query, null, new String[0]), after);
        logger.exiting(thisClass, "getLogListForServerInstance", result);
        return result;
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(Date time, LogQueryBean query) throws LogRepositoryException {
        logger.entering(thisClass, "getLogListForServerInstance", new Object[]{time, query});
        ServerInstanceLogRecordList result = this.getLogListForServerInstance(new RemoteInstanceDetails(query, time, new String[0]), null);
        logger.exiting(thisClass, "getLogListForServerInstance", result);
        return result;
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after, LogQueryBean query) throws LogRepositoryException {
        logger.entering(thisClass, "getLogListForServerInstance", new Object[]{after, query});
        ServerInstanceLogRecordList result = this.getLogListForServerInstance(new RemoteInstanceDetails(query, null, new String[0]), after);
        logger.exiting(thisClass, "getLogListForServerInstance", result);
        return result;
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(LogQueryBean query) throws LogRepositoryException {
        return this.getLogLists(null, query);
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after, LogQueryBean query) throws LogRepositoryException {
        logger.entering(thisClass, "getLogLists", new Object[]{after, query});
        RemoteAllResults lists = this.readLogLists(query, after);
        ArrayList<ServerInstanceLogRecordList> result = new ArrayList<ServerInstanceLogRecordList>();
        if (lists != null) {
            boolean firstInstance = true;
            for (RemoteInstanceDetails indicator : lists.getLogLists()) {
                result.add(this.getLogListForServerInstance(indicator, firstInstance ? after : null));
                firstInstance = false;
            }
        }
        logger.exiting(thisClass, "getLogLists", result);
        return result;
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists() throws LogRepositoryException {
        logger.entering(thisClass, "getLogLists");
        LogQueryBean query = new LogQueryBean();
        Iterable<ServerInstanceLogRecordList> result = this.getLogLists(null, query);
        logger.exiting(thisClass, "getLogLists", result);
        return result;
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after) throws LogRepositoryException {
        logger.entering(thisClass, "getLogLists", new Object[]{after});
        LogQueryBean query = new LogQueryBean();
        Iterable<ServerInstanceLogRecordList> result = this.getLogLists(after, query);
        logger.exiting(thisClass, "getLogLists", result);
        return result;
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(Level minLevel, Level maxLevel) throws LogRepositoryException {
        logger.entering(thisClass, "getLogLists", new Object[]{minLevel, maxLevel});
        LogQueryBean query = new LogQueryBean();
        query.setLevels(minLevel, maxLevel);
        Iterable<ServerInstanceLogRecordList> result = this.getLogLists(null, query);
        logger.exiting(thisClass, "getLogLists", result);
        return result;
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after, Level minLevel, Level maxLevel) throws LogRepositoryException {
        logger.entering(thisClass, "getLogLists", new Object[]{after, minLevel, maxLevel});
        LogQueryBean query = new LogQueryBean();
        query.setLevels(minLevel, maxLevel);
        Iterable<ServerInstanceLogRecordList> result = this.getLogLists(after, query);
        logger.exiting(thisClass, "getLogLists", result);
        return result;
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(Date minTime, Date maxTime) throws LogRepositoryException {
        logger.entering(thisClass, "getLogLists", new Object[]{minTime, maxTime});
        LogQueryBean query = new LogQueryBean();
        query.setTime(minTime, maxTime);
        Iterable<ServerInstanceLogRecordList> result = this.getLogLists(null, query);
        logger.exiting(thisClass, "getLogLists", result);
        return result;
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after, Date maxTime) throws LogRepositoryException {
        logger.entering(thisClass, "getLogLists", new Object[]{after, maxTime});
        LogQueryBean query = new LogQueryBean();
        query.setTime(null, maxTime);
        Iterable<ServerInstanceLogRecordList> result = this.getLogLists(after, query);
        logger.exiting(thisClass, "getLogLists", result);
        return result;
    }

    public abstract RemoteAllResults readLogLists(LogQueryBean var1, RepositoryPointer var2) throws LogRepositoryException;

    public abstract RemoteInstanceResult readLogRecords(RemoteInstanceDetails var1, RepositoryPointer var2, int var3, int var4, Locale var5) throws LogRepositoryException;
}

