/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.internal;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import io.opencensus.implcore.internal.DaemonThreadFactory;
import io.opencensus.implcore.internal.EventQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DisruptorEventQueue
implements EventQueue {
    private static final int DISRUPTOR_BUFFER_SIZE = 8192;
    private static final DisruptorEventQueue eventQueue = new DisruptorEventQueue();
    private final Disruptor<DisruptorEvent> disruptor = new Disruptor((EventFactory)new DisruptorEventFactory(), 8192, (Executor)Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("OpenCensus.Disruptor")), ProducerType.MULTI, (WaitStrategy)new SleepingWaitStrategy());
    private final RingBuffer<DisruptorEvent> ringBuffer;

    private DisruptorEventQueue() {
        this.disruptor.handleEventsWith(new EventHandler[]{new DisruptorEventHandler()});
        this.disruptor.start();
        this.ringBuffer = this.disruptor.getRingBuffer();
    }

    public static DisruptorEventQueue getInstance() {
        return eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(EventQueue.Entry entry) {
        long sequence = this.ringBuffer.next();
        try {
            DisruptorEvent event = (DisruptorEvent)this.ringBuffer.get(sequence);
            event.setEntry(entry);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }

    private static final class DisruptorEventHandler
    implements EventHandler<DisruptorEvent> {
        private DisruptorEventHandler() {
        }

        public void onEvent(DisruptorEvent event, long sequence, boolean endOfBatch) {
            event.getEntry().process();
        }
    }

    private static final class DisruptorEventFactory
    implements EventFactory<DisruptorEvent> {
        private DisruptorEventFactory() {
        }

        public DisruptorEvent newInstance() {
            return new DisruptorEvent();
        }
    }

    private static final class DisruptorEvent {
        @Nullable
        private EventQueue.Entry entry;

        private DisruptorEvent() {
        }

        void setEntry(EventQueue.Entry entry) {
            this.entry = entry;
        }

        @Nullable
        EventQueue.Entry getEntry() {
            return this.entry;
        }
    }
}

