/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import io.opencensus.common.Clock;
import io.opencensus.common.Timestamp;
import io.opencensus.implcore.internal.TimestampConverter;
import io.opencensus.implcore.trace.internal.ConcurrentIntrusiveList;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Link;
import io.opencensus.trace.NetworkEvent;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.config.TraceParams;
import io.opencensus.trace.export.SpanData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SpanImpl
extends Span
implements ConcurrentIntrusiveList.Element<SpanImpl> {
    private static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private final SpanId parentSpanId;
    private final Boolean hasRemoteParent;
    private final TraceParams traceParams;
    private final StartEndHandler startEndHandler;
    private final String name;
    private final Clock clock;
    private final TimestampConverter timestampConverter;
    private final long startNanoTime;
    @GuardedBy(value="this")
    private AttributesWithCapacity attributes;
    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<Annotation>> annotations;
    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<NetworkEvent>> networkEvents;
    @GuardedBy(value="this")
    private TraceEvents<Link> links;
    @GuardedBy(value="this")
    private Status status;
    @GuardedBy(value="this")
    private long endNanoTime;
    @GuardedBy(value="this")
    private boolean hasBeenEnded;
    @GuardedBy(value="this")
    private boolean sampleToLocalSpanStore;
    private SpanImpl next = null;
    private SpanImpl prev = null;

    @VisibleForTesting
    public static SpanImpl startSpan(SpanContext context, @Nullable EnumSet<Span.Options> options, String name, @Nullable SpanId parentSpanId, @Nullable Boolean hasRemoteParent, TraceParams traceParams, StartEndHandler startEndHandler, @Nullable TimestampConverter timestampConverter, Clock clock) {
        SpanImpl span = new SpanImpl(context, options, name, parentSpanId, hasRemoteParent, traceParams, startEndHandler, timestampConverter, clock);
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            startEndHandler.onStart(span);
        }
        return span;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEndNanoTime() {
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            return this.hasBeenEnded ? this.endNanoTime : this.clock.nowNanos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatencyNs() {
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            return this.hasBeenEnded ? this.endNanoTime - this.startNanoTime : this.clock.nowNanos() - this.startNanoTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSampleToLocalSpanStore() {
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            Preconditions.checkState((boolean)this.hasBeenEnded, (Object)"Running span does not have the SampleToLocalSpanStore set.");
            return this.sampleToLocalSpanStore;
        }
    }

    @Nullable
    TimestampConverter getTimestampConverter() {
        return this.timestampConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpanData toSpanData() {
        Preconditions.checkState((boolean)this.getOptions().contains(Span.Options.RECORD_EVENTS), (Object)"Getting SpanData for a Span without RECORD_EVENTS option.");
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            SpanData.Attributes attributesSpanData = this.attributes == null ? SpanData.Attributes.create(Collections.emptyMap(), (int)0) : SpanData.Attributes.create((Map)this.attributes, (int)this.attributes.getNumberOfDroppedAttributes());
            SpanData.TimedEvents annotationsSpanData = SpanImpl.createTimedEvents(this.annotations, this.timestampConverter);
            SpanData.TimedEvents networkEventsSpanData = SpanImpl.createTimedEvents(this.networkEvents, this.timestampConverter);
            SpanData.Links linksSpanData = this.links == null ? SpanData.Links.create(Collections.emptyList(), (int)0) : SpanData.Links.create(new ArrayList(((TraceEvents)this.links).events), (int)((TraceEvents)this.links).getNumberOfDroppedEvents());
            return SpanData.create((SpanContext)this.getContext(), (SpanId)this.parentSpanId, (Boolean)this.hasRemoteParent, (String)this.name, (Timestamp)this.timestampConverter.convertNanoTime(this.startNanoTime), (SpanData.Attributes)attributesSpanData, annotationsSpanData, networkEventsSpanData, (SpanData.Links)linksSpanData, null, (Status)(this.hasBeenEnded ? this.status : null), this.hasBeenEnded ? this.timestampConverter.convertNanoTime(this.endNanoTime) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAttribute(String key, AttributeValue value) {
        if (!this.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            return;
        }
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling putAttributes() on an ended Span.");
                return;
            }
            this.getInitializedAttributes().putAttribute(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAttributes(Map<String, AttributeValue> attributes) {
        if (!this.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            return;
        }
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling putAttributes() on an ended Span.");
                return;
            }
            this.getInitializedAttributes().putAttributes(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(String description, Map<String, AttributeValue> attributes) {
        if (!this.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            return;
        }
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addAnnotation() on an ended Span.");
                return;
            }
            this.getInitializedAnnotations().addEvent(new EventWithNanoTime(this.clock.nowNanos(), Annotation.fromDescriptionAndAttributes((String)description, attributes)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(Annotation annotation) {
        if (!this.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            return;
        }
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addAnnotation() on an ended Span.");
                return;
            }
            this.getInitializedAnnotations().addEvent(new EventWithNanoTime(this.clock.nowNanos(), Preconditions.checkNotNull((Object)annotation, (Object)"annotation")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkEvent(NetworkEvent networkEvent) {
        if (!this.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            return;
        }
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addNetworkEvent() on an ended Span.");
                return;
            }
            this.getInitializedNetworkEvents().addEvent(new EventWithNanoTime(this.clock.nowNanos(), Preconditions.checkNotNull((Object)networkEvent, (Object)"networkEvent")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLink(Link link) {
        if (!this.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            return;
        }
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addLink() on an ended Span.");
                return;
            }
            this.getInitializedLinks().addEvent((Link)Preconditions.checkNotNull((Object)link, (Object)"link"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(EndSpanOptions options) {
        if (!this.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            return;
        }
        SpanImpl spanImpl = this;
        synchronized (spanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling end() on an ended Span.");
                return;
            }
            this.status = options.getStatus();
            this.sampleToLocalSpanStore = options.getSampleToLocalSpanStore();
            this.endNanoTime = this.clock.nowNanos();
            this.hasBeenEnded = true;
        }
        this.startEndHandler.onEnd(this);
    }

    @GuardedBy(value="this")
    private AttributesWithCapacity getInitializedAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesWithCapacity(this.traceParams.getMaxNumberOfAttributes());
        }
        return this.attributes;
    }

    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<Annotation>> getInitializedAnnotations() {
        if (this.annotations == null) {
            this.annotations = new TraceEvents(this.traceParams.getMaxNumberOfAnnotations());
        }
        return this.annotations;
    }

    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<NetworkEvent>> getInitializedNetworkEvents() {
        if (this.networkEvents == null) {
            this.networkEvents = new TraceEvents(this.traceParams.getMaxNumberOfNetworkEvents());
        }
        return this.networkEvents;
    }

    @GuardedBy(value="this")
    private TraceEvents<Link> getInitializedLinks() {
        if (this.links == null) {
            this.links = new TraceEvents(this.traceParams.getMaxNumberOfLinks());
        }
        return this.links;
    }

    private static <T> SpanData.TimedEvents<T> createTimedEvents(TraceEvents<EventWithNanoTime<T>> events, TimestampConverter timestampConverter) {
        if (events == null) {
            return SpanData.TimedEvents.create(Collections.emptyList(), (int)0);
        }
        ArrayList<SpanData.TimedEvent> eventsList = new ArrayList<SpanData.TimedEvent>(((TraceEvents)events).events.size());
        for (EventWithNanoTime networkEvent : ((TraceEvents)events).events) {
            eventsList.add(networkEvent.toSpanDataTimedEvent(timestampConverter));
        }
        return SpanData.TimedEvents.create(eventsList, (int)((TraceEvents)events).getNumberOfDroppedEvents());
    }

    @Override
    public SpanImpl getNext() {
        return this.next;
    }

    @Override
    public void setNext(SpanImpl element) {
        this.next = element;
    }

    @Override
    public SpanImpl getPrev() {
        return this.prev;
    }

    @Override
    public void setPrev(SpanImpl element) {
        this.prev = element;
    }

    private SpanImpl(SpanContext context, @Nullable EnumSet<Span.Options> options, String name, @Nullable SpanId parentSpanId, @Nullable Boolean hasRemoteParent, TraceParams traceParams, StartEndHandler startEndHandler, @Nullable TimestampConverter timestampConverter, Clock clock) {
        super(context, options);
        this.parentSpanId = parentSpanId;
        this.hasRemoteParent = hasRemoteParent;
        this.name = name;
        this.traceParams = traceParams;
        this.startEndHandler = startEndHandler;
        this.clock = clock;
        this.hasBeenEnded = false;
        this.sampleToLocalSpanStore = false;
        if (this.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            this.timestampConverter = timestampConverter != null ? timestampConverter : TimestampConverter.now(clock);
            this.startNanoTime = clock.nowNanos();
        } else {
            this.startNanoTime = 0L;
            this.timestampConverter = timestampConverter;
        }
    }

    private static final class EventWithNanoTime<T> {
        private final long nanoTime;
        private final T event;

        private EventWithNanoTime(long nanoTime, T event) {
            this.nanoTime = nanoTime;
            this.event = event;
        }

        private SpanData.TimedEvent<T> toSpanDataTimedEvent(TimestampConverter timestampConverter) {
            return SpanData.TimedEvent.create((Timestamp)timestampConverter.convertNanoTime(this.nanoTime), this.event);
        }
    }

    private static final class TraceEvents<T> {
        private int totalRecordedEvents = 0;
        private final EvictingQueue<T> events;

        private int getNumberOfDroppedEvents() {
            return this.totalRecordedEvents - this.events.size();
        }

        TraceEvents(int maxNumEvents) {
            this.events = EvictingQueue.create((int)maxNumEvents);
        }

        void addEvent(T event) {
            ++this.totalRecordedEvents;
            this.events.add(event);
        }
    }

    private static final class AttributesWithCapacity
    extends LinkedHashMap<String, AttributeValue> {
        private final int capacity;
        private int totalRecordedAttributes = 0;
        private static final long serialVersionUID = 42L;

        private AttributesWithCapacity(int capacity) {
            super(capacity + 1, 1.0f, true);
            this.capacity = capacity;
        }

        private void putAttribute(String key, AttributeValue value) {
            ++this.totalRecordedAttributes;
            this.put(key, value);
        }

        private void putAttributes(Map<String, AttributeValue> attributes) {
            this.totalRecordedAttributes += attributes.size();
            this.putAll(attributes);
        }

        private int getNumberOfDroppedAttributes() {
            return this.totalRecordedAttributes - this.size();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, AttributeValue> eldest) {
            return this.size() > this.capacity;
        }
    }

    public static interface StartEndHandler {
        public void onStart(SpanImpl var1);

        public void onEnd(SpanImpl var1);
    }
}

