/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace;

import io.opencensus.implcore.internal.EventQueue;
import io.opencensus.implcore.trace.SpanImpl;
import io.opencensus.implcore.trace.export.RunningSpanStoreImpl;
import io.opencensus.implcore.trace.export.SampledSpanStoreImpl;
import io.opencensus.implcore.trace.export.SpanExporterImpl;
import io.opencensus.trace.Span;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class StartEndHandlerImpl
implements SpanImpl.StartEndHandler {
    private final SpanExporterImpl spanExporter;
    private final RunningSpanStoreImpl runningSpanStore;
    private final SampledSpanStoreImpl sampledSpanStore;
    private final EventQueue eventQueue;
    private final boolean enqueueEventForNonSampledSpans;

    public StartEndHandlerImpl(SpanExporterImpl spanExporter, @Nullable RunningSpanStoreImpl runningSpanStore, @Nullable SampledSpanStoreImpl sampledSpanStore, EventQueue eventQueue) {
        this.spanExporter = spanExporter;
        this.runningSpanStore = runningSpanStore;
        this.sampledSpanStore = sampledSpanStore;
        this.enqueueEventForNonSampledSpans = runningSpanStore != null || sampledSpanStore != null;
        this.eventQueue = eventQueue;
    }

    @Override
    public void onStart(SpanImpl span) {
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS) && this.enqueueEventForNonSampledSpans) {
            this.eventQueue.enqueue(new SpanStartEvent(span, this.runningSpanStore));
        }
    }

    @Override
    public void onEnd(SpanImpl span) {
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS) && this.enqueueEventForNonSampledSpans || span.getContext().getTraceOptions().isSampled()) {
            this.eventQueue.enqueue(new SpanEndEvent(span, this.spanExporter, this.runningSpanStore, this.sampledSpanStore));
        }
    }

    private static final class SpanEndEvent
    implements EventQueue.Entry {
        private final SpanImpl span;
        private final RunningSpanStoreImpl runningSpanStore;
        private final SpanExporterImpl spanExporter;
        private final SampledSpanStoreImpl sampledSpanStore;

        SpanEndEvent(SpanImpl span, SpanExporterImpl spanExporter, @Nullable RunningSpanStoreImpl runningSpanStore, @Nullable SampledSpanStoreImpl sampledSpanStore) {
            this.span = span;
            this.runningSpanStore = runningSpanStore;
            this.spanExporter = spanExporter;
            this.sampledSpanStore = sampledSpanStore;
        }

        @Override
        public void process() {
            if (this.span.getContext().getTraceOptions().isSampled()) {
                this.spanExporter.addSpan(this.span);
            }
            if (this.runningSpanStore != null) {
                this.runningSpanStore.onEnd(this.span);
            }
            if (this.sampledSpanStore != null) {
                this.sampledSpanStore.considerForSampling(this.span);
            }
        }
    }

    private static final class SpanStartEvent
    implements EventQueue.Entry {
        private final SpanImpl span;
        private final RunningSpanStoreImpl activeSpansExporter;

        SpanStartEvent(SpanImpl span, @Nullable RunningSpanStoreImpl activeSpansExporter) {
            this.span = span;
            this.activeSpansExporter = activeSpansExporter;
        }

        @Override
        public void process() {
            if (this.activeSpansExporter != null) {
                this.activeSpansExporter.onStart(this.span);
            }
        }
    }
}

