/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace.propagation;

import com.google.common.base.Preconditions;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.propagation.BinaryFormat;
import java.text.ParseException;

public final class BinaryFormatImpl
extends BinaryFormat {
    private static final byte VERSION_ID = 0;
    private static final int VERSION_ID_OFFSET = 0;
    private static final byte ID_SIZE = 1;
    private static final byte TRACE_ID_FIELD_ID = 0;
    private static final int TRACE_ID_FIELD_ID_OFFSET = 1;
    private static final int TRACE_ID_OFFSET = 2;
    private static final byte SPAN_ID_FIELD_ID = 1;
    private static final int SPAN_ID_FIELD_ID_OFFSET = 18;
    private static final int SPAN_ID_OFFSET = 19;
    private static final byte TRACE_OPTION_FIELD_ID = 2;
    private static final int TRACE_OPTION_FIELD_ID_OFFSET = 27;
    private static final int TRACE_OPTIONS_OFFSET = 28;
    private static final int FORMAT_LENGTH = 29;

    public byte[] toBinaryValue(SpanContext spanContext) {
        Preconditions.checkNotNull((Object)spanContext, (Object)"spanContext");
        byte[] bytes = new byte[29];
        bytes[0] = 0;
        bytes[1] = 0;
        spanContext.getTraceId().copyBytesTo(bytes, 2);
        bytes[18] = 1;
        spanContext.getSpanId().copyBytesTo(bytes, 19);
        bytes[27] = 2;
        spanContext.getTraceOptions().copyBytesTo(bytes, 28);
        return bytes;
    }

    public SpanContext fromBinaryValue(byte[] bytes) throws ParseException {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes");
        if (bytes.length == 0 || bytes[0] != 0) {
            throw new ParseException("Unsupported version.", 0);
        }
        TraceId traceId = TraceId.INVALID;
        SpanId spanId = SpanId.INVALID;
        TraceOptions traceOptions = TraceOptions.DEFAULT;
        int pos = 1;
        try {
            if (bytes.length > pos && bytes[pos] == 0) {
                traceId = TraceId.fromBytes((byte[])bytes, (int)(pos + 1));
                pos += 17;
            }
            if (bytes.length > pos && bytes[pos] == 1) {
                spanId = SpanId.fromBytes((byte[])bytes, (int)(pos + 1));
                pos += 9;
            }
            if (bytes.length > pos && bytes[pos] == 2) {
                traceOptions = TraceOptions.fromBytes((byte[])bytes, (int)(pos + 1));
            }
            return SpanContext.create((TraceId)traceId, (SpanId)spanId, (TraceOptions)traceOptions);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("Invalid input: " + e.toString(), pos);
        }
    }
}

