/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import io.opencensus.common.Clock;
import io.opencensus.internal.EventQueue;
import io.opencensus.internal.SimpleEventQueue;
import io.opencensus.trace.SpanImpl;
import io.opencensus.trace.StartEndHandlerImpl;
import io.opencensus.trace.TraceComponent;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.TracerImpl;
import io.opencensus.trace.config.TraceConfig;
import io.opencensus.trace.config.TraceConfigImpl;
import io.opencensus.trace.export.ExportComponent;
import io.opencensus.trace.export.ExportComponentImpl;
import io.opencensus.trace.internal.RandomHandler;
import io.opencensus.trace.propagation.PropagationComponent;
import io.opencensus.trace.propagation.PropagationComponentImpl;

class TraceComponentImplBase
extends TraceComponent {
    private final ExportComponentImpl exportComponent;
    private final PropagationComponent propagationComponent = new PropagationComponentImpl();
    private final Clock clock;
    private final SpanImpl.StartEndHandler startEndHandler;
    private final TraceConfig traceConfig = new TraceConfigImpl();
    private final Tracer tracer;

    TraceComponentImplBase(Clock clock, RandomHandler randomHandler, EventQueue eventQueue) {
        this.clock = clock;
        this.exportComponent = eventQueue instanceof SimpleEventQueue ? ExportComponentImpl.createWithoutInProcessStores() : ExportComponentImpl.createWithInProcessStores();
        this.startEndHandler = new StartEndHandlerImpl(this.exportComponent.getSpanExporter(), this.exportComponent.getRunningSpanStore(), this.exportComponent.getSampledSpanStore(), eventQueue);
        this.tracer = new TracerImpl(randomHandler, this.startEndHandler, clock, this.traceConfig);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public PropagationComponent getPropagationComponent() {
        return this.propagationComponent;
    }

    public final Clock getClock() {
        return this.clock;
    }

    public ExportComponent getExportComponent() {
        return this.exportComponent;
    }

    public TraceConfig getTraceConfig() {
        return this.traceConfig;
    }
}

