/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.metrics;

import com.google.common.base.Preconditions;
import io.opencensus.common.Clock;
import io.opencensus.implcore.metrics.DerivedDoubleGaugeImpl;
import io.opencensus.implcore.metrics.DerivedLongGaugeImpl;
import io.opencensus.implcore.metrics.DoubleGaugeImpl;
import io.opencensus.implcore.metrics.LongGaugeImpl;
import io.opencensus.implcore.metrics.Meter;
import io.opencensus.metrics.DerivedDoubleGauge;
import io.opencensus.metrics.DerivedLongGauge;
import io.opencensus.metrics.DoubleGauge;
import io.opencensus.metrics.LongGauge;
import io.opencensus.metrics.MetricOptions;
import io.opencensus.metrics.MetricRegistry;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MetricRegistryImpl
extends MetricRegistry {
    private final RegisteredMeters registeredMeters = new RegisteredMeters();
    private final MetricProducer metricProducer;

    MetricRegistryImpl(Clock clock) {
        this.metricProducer = new MetricProducerForRegistry(this.registeredMeters, clock);
    }

    public LongGauge addLongGauge(String name, MetricOptions options) {
        LongGaugeImpl longGaugeMetric = new LongGaugeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys());
        this.registeredMeters.registerMeter(name, longGaugeMetric);
        return longGaugeMetric;
    }

    public DoubleGauge addDoubleGauge(String name, MetricOptions options) {
        DoubleGaugeImpl doubleGaugeMetric = new DoubleGaugeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys());
        this.registeredMeters.registerMeter(name, doubleGaugeMetric);
        return doubleGaugeMetric;
    }

    public DerivedLongGauge addDerivedLongGauge(String name, MetricOptions options) {
        DerivedLongGaugeImpl derivedLongGauge = new DerivedLongGaugeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys());
        this.registeredMeters.registerMeter(name, derivedLongGauge);
        return derivedLongGauge;
    }

    public DerivedDoubleGauge addDerivedDoubleGauge(String name, MetricOptions options) {
        DerivedDoubleGaugeImpl derivedDoubleGauge = new DerivedDoubleGaugeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys());
        this.registeredMeters.registerMeter(name, derivedDoubleGauge);
        return derivedDoubleGauge;
    }

    MetricProducer getMetricProducer() {
        return this.metricProducer;
    }

    private static final class MetricProducerForRegistry
    extends MetricProducer {
        private final RegisteredMeters registeredMeters;
        private final Clock clock;

        private MetricProducerForRegistry(RegisteredMeters registeredMeters, Clock clock) {
            this.registeredMeters = registeredMeters;
            this.clock = clock;
        }

        public Collection<Metric> getMetrics() {
            Map meters = this.registeredMeters.getRegisteredMeters();
            if (meters.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Metric> metrics = new ArrayList<Metric>(meters.size());
            for (Map.Entry entry : meters.entrySet()) {
                Metric metric = ((Meter)entry.getValue()).getMetric(this.clock);
                if (metric == null) continue;
                metrics.add(metric);
            }
            return Collections.unmodifiableCollection(metrics);
        }
    }

    private static final class RegisteredMeters {
        private volatile Map<String, Meter> registeredMeters = Collections.emptyMap();

        private RegisteredMeters() {
        }

        private Map<String, Meter> getRegisteredMeters() {
            return this.registeredMeters;
        }

        private synchronized void registerMeter(String meterName, Meter meter) {
            Meter existingMeter = this.registeredMeters.get(meterName);
            if (existingMeter != null) {
                throw new IllegalArgumentException("A different metric with the same name already registered.");
            }
            LinkedHashMap<String, Meter> registeredMetersCopy = new LinkedHashMap<String, Meter>(this.registeredMeters);
            registeredMetersCopy.put(meterName, meter);
            this.registeredMeters = Collections.unmodifiableMap(registeredMetersCopy);
        }
    }
}

