/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import io.opencensus.common.Scope;
import io.opencensus.implcore.internal.CurrentState;
import io.opencensus.implcore.internal.NoopScope;
import io.opencensus.implcore.tags.CurrentTagContextUtils;
import io.opencensus.implcore.tags.NoopTagContextBuilder;
import io.opencensus.implcore.tags.TagContextBuilderImpl;
import io.opencensus.implcore.tags.TagContextImpl;
import io.opencensus.implcore.tags.TagContextUtils;
import io.opencensus.tags.InternalUtils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.Tagger;
import java.util.Iterator;

public final class TaggerImpl
extends Tagger {
    private final CurrentState state;

    TaggerImpl(CurrentState state) {
        this.state = state;
    }

    public TagContextImpl empty() {
        return TagContextImpl.EMPTY;
    }

    public TagContextImpl getCurrentTagContext() {
        return this.state.getInternal() == CurrentState.State.DISABLED ? TagContextImpl.EMPTY : TaggerImpl.toTagContextImpl(CurrentTagContextUtils.getCurrentTagContext());
    }

    public TagContextBuilder emptyBuilder() {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopTagContextBuilder.INSTANCE : new TagContextBuilderImpl();
    }

    public TagContextBuilder currentBuilder() {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopTagContextBuilder.INSTANCE : this.toBuilder(CurrentTagContextUtils.getCurrentTagContext());
    }

    public TagContextBuilder toBuilder(TagContext tags) {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopTagContextBuilder.INSTANCE : TaggerImpl.toTagContextBuilderImpl(tags);
    }

    public Scope withTagContext(TagContext tags) {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopScope.getInstance() : CurrentTagContextUtils.withTagContext(TaggerImpl.toTagContextImpl(tags));
    }

    private static TagContextImpl toTagContextImpl(TagContext tags) {
        if (tags instanceof TagContextImpl) {
            return (TagContextImpl)tags;
        }
        Iterator i = InternalUtils.getTags((TagContext)tags);
        if (!i.hasNext()) {
            return TagContextImpl.EMPTY;
        }
        TagContextBuilderImpl builder = new TagContextBuilderImpl();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (tag == null) continue;
            TagContextUtils.addTagToBuilder(tag, builder);
        }
        return builder.build();
    }

    private static TagContextBuilderImpl toTagContextBuilderImpl(TagContext tags) {
        if (tags instanceof TagContextImpl) {
            return new TagContextBuilderImpl(((TagContextImpl)tags).getTags());
        }
        TagContextBuilderImpl builder = new TagContextBuilderImpl();
        Iterator i = InternalUtils.getTags((TagContext)tags);
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (tag == null) continue;
            TagContextUtils.addTagToBuilder(tag, builder);
        }
        return builder;
    }
}

