/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.temporary.metrics;

import io.opencensus.common.Timestamp;
import io.opencensus.implcore.temporary.metrics.AutoValue_TimeSeries;
import io.opencensus.implcore.temporary.metrics.LabelValue;
import io.opencensus.implcore.temporary.metrics.Point;
import io.opencensus.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class TimeSeries {
    TimeSeries() {
    }

    public static TimeSeries create(List<LabelValue> labelValues, List<Point> points, @Nullable Timestamp startTimestamp) {
        Utils.checkNotNull(labelValues, (Object)"labelValues");
        Utils.checkNotNull(points, (Object)"points");
        Utils.checkListElementNotNull(labelValues, (Object)"labelValue");
        Utils.checkListElementNotNull(points, (Object)"point");
        return new AutoValue_TimeSeries(Collections.unmodifiableList(new ArrayList<LabelValue>(labelValues)), Collections.unmodifiableList(new ArrayList<Point>(points)), startTimestamp);
    }

    public abstract List<LabelValue> getLabelValues();

    public abstract List<Point> getPoints();

    @Nullable
    public abstract Timestamp getStartTimestamp();
}

