/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.temporary.metrics;

import io.opencensus.implcore.temporary.metrics.AutoValue_MetricDescriptor;
import io.opencensus.implcore.temporary.metrics.LabelKey;
import io.opencensus.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class MetricDescriptor {
    MetricDescriptor() {
    }

    public static MetricDescriptor create(String name, String description, String unit, Type type, List<LabelKey> labelKeys) {
        Utils.checkNotNull(labelKeys, (Object)"labelKeys");
        Utils.checkListElementNotNull(labelKeys, (Object)"labelKey");
        return new AutoValue_MetricDescriptor(name, description, unit, type, Collections.unmodifiableList(new ArrayList<LabelKey>(labelKeys)));
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnit();

    public abstract Type getType();

    public abstract List<LabelKey> getLabelKeys();

    public static enum Type {
        GAUGE_INT64,
        GAUGE_DOUBLE,
        CUMULATIVE_INT64,
        CUMULATIVE_DOUBLE,
        CUMULATIVE_DISTRIBUTION;

    }
}

