/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.metrics;

import com.google.common.base.Preconditions;
import io.opencensus.common.Clock;
import io.opencensus.common.ToDoubleFunction;
import io.opencensus.common.ToLongFunction;
import io.opencensus.implcore.metrics.Gauge;
import io.opencensus.implcore.temporary.metrics.LabelKey;
import io.opencensus.implcore.temporary.metrics.LabelValue;
import io.opencensus.implcore.temporary.metrics.Metric;
import io.opencensus.implcore.temporary.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public final class MetricRegistryImpl
extends MetricRegistry {
    private final Clock clock;
    private volatile Set<Gauge> registeredGauges = Collections.emptySet();

    MetricRegistryImpl(Clock clock) {
        this.clock = clock;
    }

    @Override
    public <T> void addLongGauge(String name, String description, String unit, LinkedHashMap<LabelKey, LabelValue> labels, T obj, ToLongFunction<T> function) {
        Preconditions.checkNotNull(labels, (Object)"labels");
        this.registerGauge(new Gauge.LongGauge<T>((String)Preconditions.checkNotNull((Object)name, (Object)"name"), (String)Preconditions.checkNotNull((Object)description, (Object)"description"), (String)Preconditions.checkNotNull((Object)unit, (Object)"unit"), Collections.unmodifiableList(new ArrayList<LabelKey>(labels.keySet())), Collections.unmodifiableList(new ArrayList<LabelValue>(labels.values())), obj, (ToLongFunction)Preconditions.checkNotNull(function, (Object)"function")));
    }

    @Override
    public <T> void addDoubleGauge(String name, String description, String unit, LinkedHashMap<LabelKey, LabelValue> labels, T obj, ToDoubleFunction<T> function) {
        Preconditions.checkNotNull(labels, (Object)"labels");
        this.registerGauge(new Gauge.DoubleGauge<T>((String)Preconditions.checkNotNull((Object)name, (Object)"name"), (String)Preconditions.checkNotNull((Object)description, (Object)"description"), (String)Preconditions.checkNotNull((Object)unit, (Object)"unit"), Collections.unmodifiableList(new ArrayList<LabelKey>(labels.keySet())), Collections.unmodifiableList(new ArrayList<LabelValue>(labels.values())), obj, (ToDoubleFunction)Preconditions.checkNotNull(function, (Object)"function")));
    }

    @Override
    public Collection<Metric> getMetrics() {
        Set<Gauge> gaguges = this.registeredGauges;
        if (gaguges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (Gauge gauge : gaguges) {
            metrics.add(gauge.getMetric(this.clock));
        }
        return metrics;
    }

    private synchronized void registerGauge(Gauge gauge) {
        LinkedHashSet<Gauge> newGaguesList = new LinkedHashSet<Gauge>(this.registeredGauges);
        newGaguesList.add(gauge);
        this.registeredGauges = Collections.unmodifiableSet(newGaguesList);
    }
}

