/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.base.Preconditions;
import io.opencensus.common.Function;
import io.opencensus.implcore.internal.CheckerFrameworkUtils;
import io.opencensus.stats.BucketBoundaries;

abstract class MutableAggregation {
    private static final double TOLERANCE = 1.0E-6;

    private MutableAggregation() {
    }

    abstract void add(double var1);

    abstract void combine(MutableAggregation var1, double var2);

    abstract <T> T match(Function<? super MutableSum, T> var1, Function<? super MutableCount, T> var2, Function<? super MutableMean, T> var3, Function<? super MutableDistribution, T> var4);

    static final class MutableDistribution
    extends MutableAggregation {
        private double sum = 0.0;
        private double mean = 0.0;
        private long count = 0L;
        private double sumOfSquaredDeviations = 0.0;
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;
        private final BucketBoundaries bucketBoundaries;
        private final long[] bucketCounts;

        private MutableDistribution(BucketBoundaries bucketBoundaries) {
            this.bucketBoundaries = bucketBoundaries;
            this.bucketCounts = new long[bucketBoundaries.getBoundaries().size() + 1];
        }

        static MutableDistribution create(BucketBoundaries bucketBoundaries) {
            Preconditions.checkNotNull((Object)bucketBoundaries, (Object)"bucketBoundaries should not be null.");
            return new MutableDistribution(bucketBoundaries);
        }

        @Override
        void add(double value) {
            this.sum += value;
            ++this.count;
            double deltaFromMean = value - this.mean;
            this.mean += deltaFromMean / (double)this.count;
            double deltaFromMean2 = value - this.mean;
            this.sumOfSquaredDeviations += deltaFromMean * deltaFromMean2;
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            for (int i = 0; i < this.bucketBoundaries.getBoundaries().size(); ++i) {
                if (!(value < (Double)this.bucketBoundaries.getBoundaries().get(i))) continue;
                int n = i;
                this.bucketCounts[n] = this.bucketCounts[n] + 1L;
                return;
            }
            int n = this.bucketCounts.length - 1;
            this.bucketCounts[n] = this.bucketCounts[n] + 1L;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument((boolean)(other instanceof MutableDistribution), (Object)"MutableDistribution expected.");
            if (Math.abs(1.0 - fraction) > 1.0E-6) {
                return;
            }
            MutableDistribution mutableDistribution = (MutableDistribution)other;
            Preconditions.checkArgument((boolean)this.bucketBoundaries.equals(mutableDistribution.bucketBoundaries), (Object)"Bucket boundaries should match.");
            if (this.count + mutableDistribution.count > 0L) {
                double delta = mutableDistribution.mean - this.mean;
                this.sumOfSquaredDeviations = this.sumOfSquaredDeviations + mutableDistribution.sumOfSquaredDeviations + Math.pow(delta, 2.0) * (double)this.count * (double)mutableDistribution.count / (double)(this.count + mutableDistribution.count);
            }
            this.count += mutableDistribution.count;
            this.sum += mutableDistribution.sum;
            this.mean = this.sum / (double)this.count;
            if (mutableDistribution.min < this.min) {
                this.min = mutableDistribution.min;
            }
            if (mutableDistribution.max > this.max) {
                this.max = mutableDistribution.max;
            }
            long[] bucketCounts = mutableDistribution.getBucketCounts();
            for (int i = 0; i < bucketCounts.length; ++i) {
                int n = i;
                this.bucketCounts[n] = this.bucketCounts[n] + bucketCounts[i];
            }
        }

        double getMean() {
            return this.mean;
        }

        long getCount() {
            return this.count;
        }

        double getMin() {
            return this.min;
        }

        double getMax() {
            return this.max;
        }

        double getSumOfSquaredDeviations() {
            return this.sumOfSquaredDeviations;
        }

        long[] getBucketCounts() {
            return this.bucketCounts;
        }

        @Override
        final <T> T match(Function<? super MutableSum, T> p0, Function<? super MutableCount, T> p1, Function<? super MutableMean, T> p2, Function<? super MutableDistribution, T> p3) {
            return (T)CheckerFrameworkUtils.removeSuperFromFunctionParameterType(p3).apply((Object)this);
        }
    }

    static final class MutableMean
    extends MutableAggregation {
        private double sum = 0.0;
        private long count = 0L;

        private MutableMean() {
        }

        static MutableMean create() {
            return new MutableMean();
        }

        @Override
        void add(double value) {
            ++this.count;
            this.sum += value;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument((boolean)(other instanceof MutableMean), (Object)"MutableMean expected.");
            MutableMean mutableMean = (MutableMean)other;
            this.count += Math.round((double)mutableMean.count * fraction);
            this.sum += mutableMean.sum * fraction;
        }

        double getMean() {
            return this.getCount() == 0L ? 0.0 : this.getSum() / (double)this.getCount();
        }

        long getCount() {
            return this.count;
        }

        double getSum() {
            return this.sum;
        }

        @Override
        final <T> T match(Function<? super MutableSum, T> p0, Function<? super MutableCount, T> p1, Function<? super MutableMean, T> p2, Function<? super MutableDistribution, T> p3) {
            return (T)CheckerFrameworkUtils.removeSuperFromFunctionParameterType(p2).apply((Object)this);
        }
    }

    static final class MutableCount
    extends MutableAggregation {
        private long count = 0L;

        private MutableCount() {
        }

        static MutableCount create() {
            return new MutableCount();
        }

        @Override
        void add(double value) {
            ++this.count;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument((boolean)(other instanceof MutableCount), (Object)"MutableCount expected.");
            this.count += Math.round(fraction * (double)((MutableCount)other).getCount());
        }

        long getCount() {
            return this.count;
        }

        @Override
        final <T> T match(Function<? super MutableSum, T> p0, Function<? super MutableCount, T> p1, Function<? super MutableMean, T> p2, Function<? super MutableDistribution, T> p3) {
            return (T)CheckerFrameworkUtils.removeSuperFromFunctionParameterType(p1).apply((Object)this);
        }
    }

    static final class MutableSum
    extends MutableAggregation {
        private double sum = 0.0;

        private MutableSum() {
        }

        static MutableSum create() {
            return new MutableSum();
        }

        @Override
        void add(double value) {
            this.sum += value;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument((boolean)(other instanceof MutableSum), (Object)"MutableSum expected.");
            this.sum += fraction * ((MutableSum)other).getSum();
        }

        double getSum() {
            return this.sum;
        }

        @Override
        final <T> T match(Function<? super MutableSum, T> p0, Function<? super MutableCount, T> p1, Function<? super MutableMean, T> p2, Function<? super MutableDistribution, T> p3) {
            return (T)CheckerFrameworkUtils.removeSuperFromFunctionParameterType(p0).apply((Object)this);
        }
    }
}

