/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.base.Preconditions;
import io.opencensus.stats.StatsCollectionState;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CurrentStatsState {
    @GuardedBy(value="this")
    private StatsCollectionState currentState = StatsCollectionState.ENABLED;
    @GuardedBy(value="this")
    private boolean isRead;

    public synchronized StatsCollectionState get() {
        this.isRead = true;
        return this.getInternal();
    }

    synchronized StatsCollectionState getInternal() {
        return this.currentState;
    }

    synchronized boolean set(StatsCollectionState state) {
        Preconditions.checkState((!this.isRead ? 1 : 0) != 0, (Object)"State was already read, cannot set state.");
        if (state == this.currentState) {
            return false;
        }
        this.currentState = (StatsCollectionState)Preconditions.checkNotNull((Object)state, (Object)"state");
        return true;
    }
}

