/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.zipkin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.zipkin.AutoValue_ZipkinExporterConfiguration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;

@Immutable
public abstract class ZipkinExporterConfiguration {
    @VisibleForTesting
    static final Duration DEFAULT_DEADLINE = Duration.create((long)10L, (int)0);

    ZipkinExporterConfiguration() {
    }

    public abstract String getServiceName();

    public abstract String getV2Url();

    @Nullable
    public abstract Sender getSender();

    public abstract SpanBytesEncoder getEncoder();

    public abstract Duration getDeadline();

    public static Builder builder() {
        return new AutoValue_ZipkinExporterConfiguration.Builder().setV2Url("").setEncoder(SpanBytesEncoder.JSON_V2).setDeadline(DEFAULT_DEADLINE);
    }

    public static abstract class Builder {
        @VisibleForTesting
        static final Duration ZERO = Duration.fromMillis((long)0L);

        Builder() {
        }

        public abstract Builder setServiceName(String var1);

        public abstract Builder setV2Url(String var1);

        public abstract Builder setSender(Sender var1);

        public abstract Builder setEncoder(SpanBytesEncoder var1);

        public abstract Builder setDeadline(Duration var1);

        abstract Duration getDeadline();

        abstract String getV2Url();

        @Nullable
        abstract Sender getSender();

        abstract ZipkinExporterConfiguration autoBuild();

        public ZipkinExporterConfiguration build() {
            Preconditions.checkArgument((this.getDeadline().compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Deadline must be positive.");
            Preconditions.checkArgument((!this.getV2Url().isEmpty() || this.getSender() != null ? 1 : 0) != 0, (Object)"Neither Zipkin V2 URL nor Zipkin sender is specified.");
            return this.autoBuild();
        }
    }
}

