/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.zipkin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.exporter.trace.zipkin.ZipkinExporterHandler;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public final class ZipkinExporter {
    private static final String REGISTER_NAME = ZipkinExporter.class.getName();
    private static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    private ZipkinExporter() {
    }

    public static void createAndRegister(String v2Url, String serviceName) {
        ZipkinExporter.createAndRegister(SpanBytesEncoder.JSON_V2, (Sender)URLConnectionSender.create((String)v2Url), serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister(SpanBytesEncoder encoder, Sender sender, String serviceName) {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Zipkin exporter is already registered.");
            ZipkinExporterHandler newHandler = new ZipkinExporterHandler(encoder, sender, serviceName);
            handler = newHandler;
            ZipkinExporter.register(Tracing.getExportComponent().getSpanExporter(), newHandler);
        }
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter, SpanExporter.Handler handler) {
        spanExporter.registerHandler(REGISTER_NAME, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler != null ? 1 : 0) != 0, (Object)"Zipkin exporter is not registered.");
            ZipkinExporter.unregister(Tracing.getExportComponent().getSpanExporter());
            handler = null;
        }
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }
}

