/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.stackdriver;

import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.cloud.trace.v1.TraceServiceClient;
import com.google.cloud.trace.v1.TraceServiceSettings;
import com.google.common.io.BaseEncoding;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.TraceSpan;
import com.google.devtools.cloudtrace.v1.Traces;
import io.opencensus.common.Duration;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.NetworkEvent;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;

final class StackdriverV1ExporterHandler
extends SpanExporter.Handler {
    private static final String STATUS_CODE = "g.co/status/code";
    private static final String STATUS_DESCRIPTION = "g.co/status/description";
    private static final String ANNOTATION_LABEL = "ANNOTATION-";
    private static final String NETWORK_EVENT_LABEL = "NETWORK-";
    private static final String AGENT_LABEL_KEY = "g.co/agent";
    private static final String AGENT_LABEL_VALUE = "opencensus-java [0.8.0]";
    private final String projectId;
    private final TraceServiceClient traceServiceClient;

    private StackdriverV1ExporterHandler(String projectId, TraceServiceClient traceServiceClient) {
        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
        this.traceServiceClient = traceServiceClient;
    }

    static StackdriverV1ExporterHandler createWithCredentials(Credentials credentials, String projectId) throws IOException {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        TraceServiceSettings traceServiceSettings = TraceServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials)).build();
        return new StackdriverV1ExporterHandler(projectId, TraceServiceClient.create((TraceServiceSettings)traceServiceSettings));
    }

    static StackdriverV1ExporterHandler create(String projectId) throws IOException {
        return new StackdriverV1ExporterHandler(projectId, TraceServiceClient.create());
    }

    private Trace generateTrace(SpanData spanData) {
        SpanContext context = spanData.getContext();
        TraceSpan.Builder spanBuilder = TraceSpan.newBuilder().setSpanId(StackdriverV1ExporterHandler.encodeSpanId(context.getSpanId())).setKind(StackdriverV1ExporterHandler.toSpanKindProto(spanData)).setName(spanData.getName()).setStartTime(StackdriverV1ExporterHandler.toTimestampProto(spanData.getStartTimestamp())).setEndTime(StackdriverV1ExporterHandler.toTimestampProto(spanData.getEndTimestamp()));
        if (spanData.getParentSpanId() != null && spanData.getParentSpanId().isValid()) {
            spanBuilder.setParentSpanId(StackdriverV1ExporterHandler.encodeSpanId(spanData.getParentSpanId()));
        }
        for (Map.Entry entry : spanData.getAttributes().getAttributeMap().entrySet()) {
            spanBuilder.putLabels((String)entry.getKey(), StackdriverV1ExporterHandler.attributeValueToString((AttributeValue)entry.getValue()));
        }
        int seq = 0;
        for (SpanData.TimedEvent annotation : spanData.getAnnotations().getEvents()) {
            spanBuilder.putLabels(ANNOTATION_LABEL + String.format("%03d", seq++), StackdriverV1ExporterHandler.renderAnnotation((SpanData.TimedEvent<Annotation>)annotation, spanData.getStartTimestamp()));
        }
        seq = 0;
        for (SpanData.TimedEvent networkEvent : spanData.getNetworkEvents().getEvents()) {
            spanBuilder.putLabels(NETWORK_EVENT_LABEL + String.format("%03d", seq++), StackdriverV1ExporterHandler.renderNetworkEvents((SpanData.TimedEvent<NetworkEvent>)networkEvent, spanData.getStartTimestamp()));
        }
        spanBuilder.putLabels(STATUS_CODE, spanData.getStatus().getCanonicalCode().toString());
        if (spanData.getStatus().getDescription() != null) {
            spanBuilder.putLabels(STATUS_DESCRIPTION, spanData.getStatus().getDescription());
        }
        spanBuilder.putLabels(AGENT_LABEL_KEY, AGENT_LABEL_VALUE);
        Trace.Builder builder = Trace.newBuilder().setProjectId(this.projectId).setTraceId(StackdriverV1ExporterHandler.encodeTraceId(context.getTraceId())).addSpans(spanBuilder.build());
        return builder.build();
    }

    private static long encodeSpanId(SpanId spanId) {
        return ByteBuffer.wrap(spanId.getBytes()).getLong();
    }

    private static String encodeTraceId(TraceId traceId) {
        return BaseEncoding.base16().lowerCase().encode(traceId.getBytes());
    }

    private static TraceSpan.SpanKind toSpanKindProto(SpanData spanData) {
        if (Boolean.TRUE.equals(spanData.getHasRemoteParent())) {
            return TraceSpan.SpanKind.RPC_SERVER;
        }
        if (spanData.getName().startsWith("Sent.")) {
            return TraceSpan.SpanKind.RPC_CLIENT;
        }
        return TraceSpan.SpanKind.SPAN_KIND_UNSPECIFIED;
    }

    private static String renderNetworkEvents(SpanData.TimedEvent<NetworkEvent> timedEvent, Timestamp start) {
        StringBuilder stringBuilder = new StringBuilder();
        StackdriverV1ExporterHandler.renderDelay(stringBuilder, timedEvent.getTimestamp().subtractTimestamp(start));
        NetworkEvent networkEvent = (NetworkEvent)timedEvent.getEvent();
        if (networkEvent.getType() == NetworkEvent.Type.RECV) {
            stringBuilder.append("Received");
        } else if (networkEvent.getType() == NetworkEvent.Type.SENT) {
            stringBuilder.append("Sent");
        } else {
            stringBuilder.append("Unknown");
        }
        stringBuilder.append(" message_id=");
        stringBuilder.append(networkEvent.getMessageId());
        stringBuilder.append(" uncompressed_size=");
        stringBuilder.append(networkEvent.getUncompressedMessageSize());
        stringBuilder.append(" compressed_size=");
        stringBuilder.append(networkEvent.getCompressedMessageSize());
        if (networkEvent.getKernelTimestamp() != null) {
            stringBuilder.append(" kernel_timestamp=");
            stringBuilder.append(networkEvent.getKernelTimestamp().toString());
        }
        return stringBuilder.toString();
    }

    private static String renderAnnotation(SpanData.TimedEvent<Annotation> timedEvent, Timestamp start) {
        StringBuilder stringBuilder = new StringBuilder();
        StackdriverV1ExporterHandler.renderDelay(stringBuilder, timedEvent.getTimestamp().subtractTimestamp(start));
        Annotation annotation = (Annotation)timedEvent.getEvent();
        stringBuilder.append(annotation.getDescription());
        if (!annotation.getAttributes().isEmpty()) {
            stringBuilder.append(" ");
            stringBuilder.append(StackdriverV1ExporterHandler.renderAttributes(annotation.getAttributes()));
        }
        return stringBuilder.toString();
    }

    private static void renderDelay(StringBuilder stringBuilder, Duration delay) {
        long delayUs = delay.getSeconds() * 1000000L + (long)(delay.getNanos() / 1000);
        stringBuilder.append("[@");
        stringBuilder.append(delayUs);
        stringBuilder.append(" us] ");
    }

    private static String renderAttributes(Map<String, AttributeValue> attributes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attributes:{");
        boolean first = true;
        for (Map.Entry<String, AttributeValue> entry : attributes.entrySet()) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(StackdriverV1ExporterHandler.attributeValueToString(entry.getValue()));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static com.google.protobuf.Timestamp toTimestampProto(Timestamp timestamp) {
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(timestamp.getSeconds()).setNanos(timestamp.getNanos()).build();
    }

    private static String attributeValueToString(AttributeValue attributeValue) {
        return (String)attributeValue.match((Function)new Function<String, String>(){

            public String apply(String stringValue) {
                return stringValue;
            }
        }, (Function)new Function<Boolean, String>(){

            public String apply(Boolean booleanValue) {
                return booleanValue.toString();
            }
        }, (Function)new Function<Long, String>(){

            public String apply(Long longValue) {
                return longValue.toString();
            }
        }, Functions.returnNull());
    }

    public void export(Collection<SpanData> spanDataList) {
        Traces.Builder tracesBuilder = Traces.newBuilder();
        for (SpanData spanData : spanDataList) {
            tracesBuilder.addTraces(this.generateTrace(spanData));
        }
        this.traceServiceClient.patchTraces(PatchTracesRequest.newBuilder().setProjectId(this.projectId).setTraces(tracesBuilder.build()).build());
    }
}

