/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.stackdriver;

import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.cloud.trace.v2.TraceServiceClient;
import com.google.cloud.trace.v2.TraceServiceSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.ProjectName;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.devtools.cloudtrace.v2.SpanName;
import com.google.devtools.cloudtrace.v2.TruncatableString;
import com.google.protobuf.Int32Value;
import com.google.rpc.Status;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Scope;
import io.opencensus.common.Timestamp;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Link;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.Status;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

final class StackdriverV2ExporterHandler
extends SpanExporter.Handler {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Sampler probabilitySampler = Samplers.probabilitySampler((double)1.0E-4);
    private static final String AGENT_LABEL_KEY = "g.co/agent";
    private static final String AGENT_LABEL_VALUE_STRING = "opencensus-java [0.14.0]";
    private static final String SERVER_PREFIX = "Recv.";
    private static final String CLIENT_PREFIX = "Sent.";
    private static final com.google.devtools.cloudtrace.v2.AttributeValue AGENT_LABEL_VALUE = com.google.devtools.cloudtrace.v2.AttributeValue.newBuilder().setStringValue(StackdriverV2ExporterHandler.toTruncatableStringProto("opencensus-java [0.14.0]")).build();
    private static final ImmutableMap<String, String> HTTP_ATTRIBUTE_MAPPING = ImmutableMap.builder().put((Object)"http.host", (Object)"/http/host").put((Object)"http.method", (Object)"/http/method").put((Object)"http.path", (Object)"/http/path").put((Object)"http.route", (Object)"/http/route").put((Object)"http.user_agent", (Object)"/http/user_agent").put((Object)"http.status_code", (Object)"/http/status_code").build();
    private final String projectId;
    private final TraceServiceClient traceServiceClient;
    private final ProjectName projectName;

    @VisibleForTesting
    StackdriverV2ExporterHandler(String projectId, TraceServiceClient traceServiceClient) {
        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
        this.traceServiceClient = traceServiceClient;
        this.projectName = ProjectName.newBuilder().setProject(projectId).build();
        Tracing.getExportComponent().getSampledSpanStore().registerSpanNamesForCollection(Collections.singletonList("ExportStackdriverTraces"));
    }

    static StackdriverV2ExporterHandler createWithCredentials(Credentials credentials, String projectId) throws IOException {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        TraceServiceSettings traceServiceSettings = ((TraceServiceSettings.Builder)TraceServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials))).build();
        return new StackdriverV2ExporterHandler(projectId, TraceServiceClient.create((TraceServiceSettings)traceServiceSettings));
    }

    static StackdriverV2ExporterHandler create(String projectId) throws IOException {
        return new StackdriverV2ExporterHandler(projectId, TraceServiceClient.create());
    }

    @VisibleForTesting
    Span generateSpan(SpanData spanData) {
        Timestamp end;
        SpanContext context = spanData.getContext();
        String traceIdHex = StackdriverV2ExporterHandler.encodeTraceId(context.getTraceId());
        String spanIdHex = StackdriverV2ExporterHandler.encodeSpanId(context.getSpanId());
        SpanName spanName = SpanName.newBuilder().setProject(this.projectId).setTrace(traceIdHex).setSpan(spanIdHex).build();
        Span.Builder spanBuilder = Span.newBuilder().setName(spanName.toString()).setSpanId(StackdriverV2ExporterHandler.encodeSpanId(context.getSpanId())).setDisplayName(StackdriverV2ExporterHandler.toTruncatableStringProto(StackdriverV2ExporterHandler.toDisplayName(spanData.getName(), spanData.getKind()))).setStartTime(StackdriverV2ExporterHandler.toTimestampProto(spanData.getStartTimestamp())).setAttributes(StackdriverV2ExporterHandler.toAttributesProto(spanData.getAttributes())).setTimeEvents(StackdriverV2ExporterHandler.toTimeEventsProto((SpanData.TimedEvents<Annotation>)spanData.getAnnotations(), (SpanData.TimedEvents<MessageEvent>)spanData.getMessageEvents()));
        Status status = spanData.getStatus();
        if (status != null) {
            spanBuilder.setStatus(StackdriverV2ExporterHandler.toStatusProto(status));
        }
        if ((end = spanData.getEndTimestamp()) != null) {
            spanBuilder.setEndTime(StackdriverV2ExporterHandler.toTimestampProto(end));
        }
        spanBuilder.setLinks(StackdriverV2ExporterHandler.toLinksProto(spanData.getLinks()));
        Integer childSpanCount = spanData.getChildSpanCount();
        if (childSpanCount != null) {
            spanBuilder.setChildSpanCount(Int32Value.newBuilder().setValue(childSpanCount.intValue()).build());
        }
        if (spanData.getParentSpanId() != null && spanData.getParentSpanId().isValid()) {
            spanBuilder.setParentSpanId(StackdriverV2ExporterHandler.encodeSpanId(spanData.getParentSpanId()));
        }
        return spanBuilder.build();
    }

    private static String encodeSpanId(SpanId spanId) {
        return BaseEncoding.base16().lowerCase().encode(spanId.getBytes());
    }

    private static String encodeTraceId(TraceId traceId) {
        return BaseEncoding.base16().lowerCase().encode(traceId.getBytes());
    }

    private static Span.TimeEvents toTimeEventsProto(SpanData.TimedEvents<Annotation> annotationTimedEvents, SpanData.TimedEvents<MessageEvent> messageEventTimedEvents) {
        Span.TimeEvents.Builder timeEventsBuilder = Span.TimeEvents.newBuilder();
        timeEventsBuilder.setDroppedAnnotationsCount(annotationTimedEvents.getDroppedEventsCount());
        for (SpanData.TimedEvent annotation : annotationTimedEvents.getEvents()) {
            timeEventsBuilder.addTimeEvent(StackdriverV2ExporterHandler.toTimeAnnotationProto((SpanData.TimedEvent<Annotation>)annotation));
        }
        timeEventsBuilder.setDroppedMessageEventsCount(messageEventTimedEvents.getDroppedEventsCount());
        for (SpanData.TimedEvent networkEvent : messageEventTimedEvents.getEvents()) {
            timeEventsBuilder.addTimeEvent(StackdriverV2ExporterHandler.toTimeMessageEventProto((SpanData.TimedEvent<MessageEvent>)networkEvent));
        }
        return timeEventsBuilder.build();
    }

    private static Span.TimeEvent toTimeAnnotationProto(SpanData.TimedEvent<Annotation> timedEvent) {
        Span.TimeEvent.Builder timeEventBuilder = Span.TimeEvent.newBuilder().setTime(StackdriverV2ExporterHandler.toTimestampProto(timedEvent.getTimestamp()));
        Annotation annotation = (Annotation)timedEvent.getEvent();
        timeEventBuilder.setAnnotation(Span.TimeEvent.Annotation.newBuilder().setDescription(StackdriverV2ExporterHandler.toTruncatableStringProto(annotation.getDescription())).setAttributes(StackdriverV2ExporterHandler.toAttributesBuilderProto(annotation.getAttributes(), 0)).build());
        return timeEventBuilder.build();
    }

    private static Span.TimeEvent toTimeMessageEventProto(SpanData.TimedEvent<MessageEvent> timedEvent) {
        Span.TimeEvent.Builder timeEventBuilder = Span.TimeEvent.newBuilder().setTime(StackdriverV2ExporterHandler.toTimestampProto(timedEvent.getTimestamp()));
        MessageEvent messageEvent = (MessageEvent)timedEvent.getEvent();
        timeEventBuilder.setMessageEvent(Span.TimeEvent.MessageEvent.newBuilder().setId(messageEvent.getMessageId()).setCompressedSizeBytes(messageEvent.getCompressedMessageSize()).setUncompressedSizeBytes(messageEvent.getUncompressedMessageSize()).setType(StackdriverV2ExporterHandler.toMessageEventTypeProto(messageEvent)).build());
        return timeEventBuilder.build();
    }

    private static Span.TimeEvent.MessageEvent.Type toMessageEventTypeProto(MessageEvent messageEvent) {
        if (messageEvent.getType() == MessageEvent.Type.RECEIVED) {
            return Span.TimeEvent.MessageEvent.Type.RECEIVED;
        }
        return Span.TimeEvent.MessageEvent.Type.SENT;
    }

    private static Span.Attributes toAttributesProto(SpanData.Attributes attributes) {
        Span.Attributes.Builder attributesBuilder = StackdriverV2ExporterHandler.toAttributesBuilderProto(attributes.getAttributeMap(), attributes.getDroppedAttributesCount());
        attributesBuilder.putAttributeMap(AGENT_LABEL_KEY, AGENT_LABEL_VALUE);
        return attributesBuilder.build();
    }

    private static Span.Attributes.Builder toAttributesBuilderProto(Map<String, AttributeValue> attributes, int droppedAttributesCount) {
        Span.Attributes.Builder attributesBuilder = Span.Attributes.newBuilder().setDroppedAttributesCount(droppedAttributesCount);
        for (Map.Entry<String, AttributeValue> label : attributes.entrySet()) {
            attributesBuilder.putAttributeMap(StackdriverV2ExporterHandler.mapKey(label.getKey()), StackdriverV2ExporterHandler.toAttributeValueProto(label.getValue()));
        }
        return attributesBuilder;
    }

    private static String mapKey(String key) {
        if (HTTP_ATTRIBUTE_MAPPING.containsKey((Object)key)) {
            return (String)HTTP_ATTRIBUTE_MAPPING.get((Object)key);
        }
        return key;
    }

    private static com.google.rpc.Status toStatusProto(Status status) {
        Status.Builder statusBuilder = com.google.rpc.Status.newBuilder().setCode(status.getCanonicalCode().value());
        if (status.getDescription() != null) {
            statusBuilder.setMessage(status.getDescription());
        }
        return statusBuilder.build();
    }

    private static TruncatableString toTruncatableStringProto(String string) {
        return TruncatableString.newBuilder().setValue(string).setTruncatedByteCount(0).build();
    }

    private static com.google.protobuf.Timestamp toTimestampProto(Timestamp timestamp) {
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(timestamp.getSeconds()).setNanos(timestamp.getNanos()).build();
    }

    private static com.google.devtools.cloudtrace.v2.AttributeValue toAttributeValueProto(AttributeValue attributeValue) {
        final AttributeValue.Builder attributeValueBuilder = com.google.devtools.cloudtrace.v2.AttributeValue.newBuilder();
        attributeValue.match((Function)new Function<String, Void>(){

            public Void apply(String stringValue) {
                attributeValueBuilder.setStringValue(StackdriverV2ExporterHandler.toTruncatableStringProto(stringValue));
                return null;
            }
        }, (Function)new Function<Boolean, Void>(){

            public Void apply(Boolean booleanValue) {
                attributeValueBuilder.setBoolValue(booleanValue.booleanValue());
                return null;
            }
        }, (Function)new Function<Long, Void>(){

            public Void apply(Long longValue) {
                attributeValueBuilder.setIntValue(longValue.longValue());
                return null;
            }
        }, Functions.returnNull());
        return attributeValueBuilder.build();
    }

    private static Span.Link.Type toLinkTypeProto(Link.Type type) {
        if (type == Link.Type.PARENT_LINKED_SPAN) {
            return Span.Link.Type.PARENT_LINKED_SPAN;
        }
        return Span.Link.Type.CHILD_LINKED_SPAN;
    }

    private static String toDisplayName(String spanName, Span.Kind spanKind) {
        if (spanKind == Span.Kind.SERVER && !spanName.startsWith(SERVER_PREFIX)) {
            return SERVER_PREFIX + spanName;
        }
        if (spanKind == Span.Kind.CLIENT && !spanName.startsWith(CLIENT_PREFIX)) {
            return CLIENT_PREFIX + spanName;
        }
        return spanName;
    }

    private static Span.Link toLinkProto(Link link) {
        Preconditions.checkNotNull((Object)link);
        return Span.Link.newBuilder().setTraceId(StackdriverV2ExporterHandler.encodeTraceId(link.getTraceId())).setSpanId(StackdriverV2ExporterHandler.encodeSpanId(link.getSpanId())).setType(StackdriverV2ExporterHandler.toLinkTypeProto(link.getType())).setAttributes(StackdriverV2ExporterHandler.toAttributesBuilderProto(link.getAttributes(), 0)).build();
    }

    private static Span.Links toLinksProto(SpanData.Links links) {
        Span.Links.Builder linksBuilder = Span.Links.newBuilder().setDroppedLinksCount(links.getDroppedLinksCount());
        for (Link link : links.getLinks()) {
            linksBuilder.addLink(StackdriverV2ExporterHandler.toLinkProto(link));
        }
        return linksBuilder.build();
    }

    public void export(Collection<SpanData> spanDataList) {
        try (Scope scope = tracer.spanBuilder("ExportStackdriverTraces").setSampler(probabilitySampler).setRecordEvents(true).startScopedSpan();){
            ArrayList<Span> spans = new ArrayList<Span>(spanDataList.size());
            for (SpanData spanData : spanDataList) {
                spans.add(this.generateSpan(spanData));
            }
            this.traceServiceClient.batchWriteSpans(this.projectName, spans);
        }
    }
}

