/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.ocagent;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.UInt32Value;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.proto.agent.trace.v1.UpdatedLibraryConfig;
import io.opencensus.proto.trace.v1.ConstantSampler;
import io.opencensus.proto.trace.v1.ProbabilitySampler;
import io.opencensus.proto.trace.v1.Span;
import io.opencensus.proto.trace.v1.Status;
import io.opencensus.proto.trace.v1.TraceConfig;
import io.opencensus.proto.trace.v1.TruncatableString;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Link;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.Status;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.Tracestate;
import io.opencensus.trace.config.TraceParams;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.samplers.Samplers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class TraceProtoUtils {
    private static final Function<String, io.opencensus.proto.trace.v1.AttributeValue> stringAttributeValueFunction = new Function<String, io.opencensus.proto.trace.v1.AttributeValue>(){

        public io.opencensus.proto.trace.v1.AttributeValue apply(String stringValue) {
            return io.opencensus.proto.trace.v1.AttributeValue.newBuilder().setStringValue(TraceProtoUtils.toTruncatableStringProto(stringValue)).build();
        }
    };
    private static final Function<Boolean, io.opencensus.proto.trace.v1.AttributeValue> booleanAttributeValueFunction = new Function<Boolean, io.opencensus.proto.trace.v1.AttributeValue>(){

        public io.opencensus.proto.trace.v1.AttributeValue apply(Boolean booleanValue) {
            return io.opencensus.proto.trace.v1.AttributeValue.newBuilder().setBoolValue(booleanValue.booleanValue()).build();
        }
    };
    private static final Function<Long, io.opencensus.proto.trace.v1.AttributeValue> longAttributeValueFunction = new Function<Long, io.opencensus.proto.trace.v1.AttributeValue>(){

        public io.opencensus.proto.trace.v1.AttributeValue apply(Long longValue) {
            return io.opencensus.proto.trace.v1.AttributeValue.newBuilder().setIntValue(longValue.longValue()).build();
        }
    };
    private static final Function<Double, io.opencensus.proto.trace.v1.AttributeValue> doubleAttributeValueFunction = new Function<Double, io.opencensus.proto.trace.v1.AttributeValue>(){

        public io.opencensus.proto.trace.v1.AttributeValue apply(Double doubleValue) {
            return io.opencensus.proto.trace.v1.AttributeValue.newBuilder().setDoubleValue(doubleValue.doubleValue()).build();
        }
    };

    static Span toSpanProto(SpanData spanData) {
        SpanId parentSpanId;
        Boolean hasRemoteParent;
        Integer childSpanCount;
        Timestamp end;
        Status status;
        SpanContext spanContext = spanData.getContext();
        TraceId traceId = spanContext.getTraceId();
        SpanId spanId = spanContext.getSpanId();
        Span.Builder spanBuilder = Span.newBuilder().setTraceId(TraceProtoUtils.toByteString(traceId.getBytes())).setSpanId(TraceProtoUtils.toByteString(spanId.getBytes())).setTracestate(TraceProtoUtils.toTracestateProto(spanContext.getTracestate())).setName(TraceProtoUtils.toTruncatableStringProto(spanData.getName())).setStartTime(TraceProtoUtils.toTimestampProto(spanData.getStartTimestamp())).setAttributes(TraceProtoUtils.toAttributesProto(spanData.getAttributes())).setTimeEvents(TraceProtoUtils.toTimeEventsProto((SpanData.TimedEvents<Annotation>)spanData.getAnnotations(), (SpanData.TimedEvents<MessageEvent>)spanData.getMessageEvents())).setLinks(TraceProtoUtils.toLinksProto(spanData.getLinks()));
        Span.Kind kind = spanData.getKind();
        if (kind != null) {
            spanBuilder.setKind(TraceProtoUtils.toSpanKindProto(kind));
        }
        if ((status = spanData.getStatus()) != null) {
            spanBuilder.setStatus(TraceProtoUtils.toStatusProto(status));
        }
        if ((end = spanData.getEndTimestamp()) != null) {
            spanBuilder.setEndTime(TraceProtoUtils.toTimestampProto(end));
        }
        if ((childSpanCount = spanData.getChildSpanCount()) != null) {
            spanBuilder.setChildSpanCount(UInt32Value.newBuilder().setValue(childSpanCount.intValue()).build());
        }
        if ((hasRemoteParent = spanData.getHasRemoteParent()) != null) {
            spanBuilder.setSameProcessAsParentSpan(BoolValue.of((hasRemoteParent == false ? 1 : 0) != 0));
        }
        if ((parentSpanId = spanData.getParentSpanId()) != null && parentSpanId.isValid()) {
            spanBuilder.setParentSpanId(TraceProtoUtils.toByteString(parentSpanId.getBytes()));
        }
        return spanBuilder.build();
    }

    @VisibleForTesting
    static ByteString toByteString(byte[] bytes) {
        return ByteString.copyFrom((byte[])bytes);
    }

    private static Span.Tracestate toTracestateProto(Tracestate tracestate) {
        return Span.Tracestate.newBuilder().addAllEntries(TraceProtoUtils.toEntriesProto(tracestate.getEntries())).build();
    }

    private static List<Span.Tracestate.Entry> toEntriesProto(List<Tracestate.Entry> entries) {
        ArrayList<Span.Tracestate.Entry> entriesProto = new ArrayList<Span.Tracestate.Entry>();
        for (Tracestate.Entry entry : entries) {
            entriesProto.add(Span.Tracestate.Entry.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return entriesProto;
    }

    private static Span.SpanKind toSpanKindProto(Span.Kind kind) {
        switch (kind) {
            case CLIENT: {
                return Span.SpanKind.CLIENT;
            }
            case SERVER: {
                return Span.SpanKind.SERVER;
            }
        }
        return Span.SpanKind.UNRECOGNIZED;
    }

    private static Span.TimeEvents toTimeEventsProto(SpanData.TimedEvents<Annotation> annotationTimedEvents, SpanData.TimedEvents<MessageEvent> messageEventTimedEvents) {
        Span.TimeEvents.Builder timeEventsBuilder = Span.TimeEvents.newBuilder();
        timeEventsBuilder.setDroppedAnnotationsCount(annotationTimedEvents.getDroppedEventsCount());
        for (SpanData.TimedEvent annotation : annotationTimedEvents.getEvents()) {
            timeEventsBuilder.addTimeEvent(TraceProtoUtils.toTimeAnnotationProto((SpanData.TimedEvent<Annotation>)annotation));
        }
        timeEventsBuilder.setDroppedMessageEventsCount(messageEventTimedEvents.getDroppedEventsCount());
        for (SpanData.TimedEvent networkEvent : messageEventTimedEvents.getEvents()) {
            timeEventsBuilder.addTimeEvent(TraceProtoUtils.toTimeMessageEventProto((SpanData.TimedEvent<MessageEvent>)networkEvent));
        }
        return timeEventsBuilder.build();
    }

    private static Span.TimeEvent toTimeAnnotationProto(SpanData.TimedEvent<Annotation> timedEvent) {
        Span.TimeEvent.Builder timeEventBuilder = Span.TimeEvent.newBuilder().setTime(TraceProtoUtils.toTimestampProto(timedEvent.getTimestamp()));
        Annotation annotation = (Annotation)timedEvent.getEvent();
        timeEventBuilder.setAnnotation(Span.TimeEvent.Annotation.newBuilder().setDescription(TraceProtoUtils.toTruncatableStringProto(annotation.getDescription())).setAttributes(TraceProtoUtils.toAttributesBuilderProto(annotation.getAttributes(), 0)).build());
        return timeEventBuilder.build();
    }

    private static Span.TimeEvent toTimeMessageEventProto(SpanData.TimedEvent<MessageEvent> timedEvent) {
        Span.TimeEvent.Builder timeEventBuilder = Span.TimeEvent.newBuilder().setTime(TraceProtoUtils.toTimestampProto(timedEvent.getTimestamp()));
        MessageEvent messageEvent = (MessageEvent)timedEvent.getEvent();
        timeEventBuilder.setMessageEvent(Span.TimeEvent.MessageEvent.newBuilder().setId(messageEvent.getMessageId()).setCompressedSize(messageEvent.getCompressedMessageSize()).setUncompressedSize(messageEvent.getUncompressedMessageSize()).setType(TraceProtoUtils.toMessageEventTypeProto(messageEvent)).build());
        return timeEventBuilder.build();
    }

    private static Span.TimeEvent.MessageEvent.Type toMessageEventTypeProto(MessageEvent messageEvent) {
        if (messageEvent.getType() == MessageEvent.Type.RECEIVED) {
            return Span.TimeEvent.MessageEvent.Type.RECEIVED;
        }
        return Span.TimeEvent.MessageEvent.Type.SENT;
    }

    private static Span.Attributes toAttributesProto(SpanData.Attributes attributes) {
        Span.Attributes.Builder attributesBuilder = TraceProtoUtils.toAttributesBuilderProto(attributes.getAttributeMap(), attributes.getDroppedAttributesCount());
        return attributesBuilder.build();
    }

    private static Span.Attributes.Builder toAttributesBuilderProto(Map<String, AttributeValue> attributes, int droppedAttributesCount) {
        Span.Attributes.Builder attributesBuilder = Span.Attributes.newBuilder().setDroppedAttributesCount(droppedAttributesCount);
        for (Map.Entry<String, AttributeValue> label : attributes.entrySet()) {
            io.opencensus.proto.trace.v1.AttributeValue value = TraceProtoUtils.toAttributeValueProto(label.getValue());
            if (value == null) continue;
            attributesBuilder.putAttributeMap(label.getKey(), value);
        }
        return attributesBuilder;
    }

    @Nullable
    private static io.opencensus.proto.trace.v1.AttributeValue toAttributeValueProto(AttributeValue attributeValue) {
        return (io.opencensus.proto.trace.v1.AttributeValue)attributeValue.match(stringAttributeValueFunction, booleanAttributeValueFunction, longAttributeValueFunction, doubleAttributeValueFunction, Functions.returnNull());
    }

    private static io.opencensus.proto.trace.v1.Status toStatusProto(Status status) {
        Status.Builder statusBuilder = io.opencensus.proto.trace.v1.Status.newBuilder().setCode(status.getCanonicalCode().value());
        if (status.getDescription() != null) {
            statusBuilder.setMessage(status.getDescription());
        }
        return statusBuilder.build();
    }

    @VisibleForTesting
    static TruncatableString toTruncatableStringProto(String string) {
        return TruncatableString.newBuilder().setValue(string).setTruncatedByteCount(0).build();
    }

    static com.google.protobuf.Timestamp toTimestampProto(Timestamp timestamp) {
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(timestamp.getSeconds()).setNanos(timestamp.getNanos()).build();
    }

    private static Span.Link.Type toLinkTypeProto(Link.Type type) {
        if (type == Link.Type.PARENT_LINKED_SPAN) {
            return Span.Link.Type.PARENT_LINKED_SPAN;
        }
        return Span.Link.Type.CHILD_LINKED_SPAN;
    }

    private static Span.Link toLinkProto(Link link) {
        return Span.Link.newBuilder().setTraceId(TraceProtoUtils.toByteString(link.getTraceId().getBytes())).setSpanId(TraceProtoUtils.toByteString(link.getSpanId().getBytes())).setType(TraceProtoUtils.toLinkTypeProto(link.getType())).setAttributes(TraceProtoUtils.toAttributesBuilderProto(link.getAttributes(), 0)).build();
    }

    private static Span.Links toLinksProto(SpanData.Links links) {
        Span.Links.Builder linksBuilder = Span.Links.newBuilder().setDroppedLinksCount(links.getDroppedLinksCount());
        for (Link link : links.getLinks()) {
            linksBuilder.addLink(TraceProtoUtils.toLinkProto(link));
        }
        return linksBuilder.build();
    }

    static TraceConfig toTraceConfigProto(TraceParams traceParams) {
        TraceConfig.Builder traceConfigProtoBuilder = TraceConfig.newBuilder();
        Sampler librarySampler = traceParams.getSampler();
        if (Samplers.alwaysSample().equals(librarySampler)) {
            traceConfigProtoBuilder.setConstantSampler(ConstantSampler.newBuilder().setDecision(ConstantSampler.ConstantDecision.ALWAYS_ON).build());
        } else if (Samplers.neverSample().equals(librarySampler)) {
            traceConfigProtoBuilder.setConstantSampler(ConstantSampler.newBuilder().setDecision(ConstantSampler.ConstantDecision.ALWAYS_OFF).build());
        } else {
            double samplingProbability = TraceProtoUtils.parseSamplingProbability(librarySampler);
            traceConfigProtoBuilder.setProbabilitySampler(ProbabilitySampler.newBuilder().setSamplingProbability(samplingProbability).build());
        }
        return traceConfigProtoBuilder.build();
    }

    private static double parseSamplingProbability(Sampler sampler) {
        String description = sampler.getDescription();
        int leftParenIndex = description.indexOf("{");
        int rightParenIndex = description.indexOf("}");
        return Double.parseDouble(description.substring(leftParenIndex + 1, rightParenIndex));
    }

    static TraceParams fromTraceConfigProto(TraceConfig traceConfigProto, TraceParams currentTraceParams) {
        TraceParams.Builder builder = currentTraceParams.toBuilder();
        if (traceConfigProto.hasConstantSampler()) {
            ConstantSampler constantSampler = traceConfigProto.getConstantSampler();
            ConstantSampler.ConstantDecision decision = constantSampler.getDecision();
            if (ConstantSampler.ConstantDecision.ALWAYS_ON.equals((Object)decision)) {
                builder.setSampler(Samplers.alwaysSample());
            } else if (ConstantSampler.ConstantDecision.ALWAYS_OFF.equals((Object)decision)) {
                builder.setSampler(Samplers.neverSample());
            }
        } else if (traceConfigProto.hasProbabilitySampler()) {
            builder.setSampler(Samplers.probabilitySampler((double)traceConfigProto.getProbabilitySampler().getSamplingProbability()));
        }
        return builder.build();
    }

    static TraceConfig getCurrentTraceConfig(io.opencensus.trace.config.TraceConfig traceConfig) {
        TraceParams traceParams = traceConfig.getActiveTraceParams();
        return TraceProtoUtils.toTraceConfigProto(traceParams);
    }

    static TraceParams getUpdatedTraceParams(UpdatedLibraryConfig config, io.opencensus.trace.config.TraceConfig traceConfig) {
        TraceParams currentParams = traceConfig.getActiveTraceParams();
        TraceConfig traceConfigProto = config.getConfig();
        return TraceProtoUtils.fromTraceConfigProto(traceConfigProto, currentParams);
    }

    private TraceProtoUtils() {
    }
}

