/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.ocagent;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.opencensus.exporter.trace.ocagent.TraceProtoUtils;
import io.opencensus.proto.agent.common.v1.Node;
import io.opencensus.proto.agent.trace.v1.CurrentLibraryConfig;
import io.opencensus.proto.agent.trace.v1.TraceServiceGrpc;
import io.opencensus.proto.agent.trace.v1.UpdatedLibraryConfig;
import io.opencensus.proto.trace.v1.TraceConfig;
import io.opencensus.trace.config.TraceParams;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class OcAgentTraceServiceConfigRpcHandler {
    private static final Logger logger = Logger.getLogger(OcAgentTraceServiceConfigRpcHandler.class.getName());
    @Nullable
    @GuardedBy(value="this")
    private StreamObserver<CurrentLibraryConfig> currentConfigObserver;
    @Nullable
    @GuardedBy(value="this")
    private Status terminateStatus;
    private final io.opencensus.trace.config.TraceConfig traceConfig;

    private OcAgentTraceServiceConfigRpcHandler(io.opencensus.trace.config.TraceConfig traceConfig) {
        this.traceConfig = traceConfig;
    }

    private synchronized void setCurrentConfigObserver(StreamObserver<CurrentLibraryConfig> currentConfigObserver) {
        this.currentConfigObserver = currentConfigObserver;
    }

    static OcAgentTraceServiceConfigRpcHandler create(TraceServiceGrpc.TraceServiceStub stub, io.opencensus.trace.config.TraceConfig traceConfig) {
        OcAgentTraceServiceConfigRpcHandler configRpcHandler = new OcAgentTraceServiceConfigRpcHandler(traceConfig);
        UpdatedLibraryConfigObserver updatedLibraryConfigObserver = new UpdatedLibraryConfigObserver(traceConfig, configRpcHandler);
        try {
            StreamObserver currentConfigObserver = stub.config((StreamObserver)updatedLibraryConfigObserver);
            configRpcHandler.setCurrentConfigObserver((StreamObserver<CurrentLibraryConfig>)currentConfigObserver);
        }
        catch (StatusRuntimeException e) {
            configRpcHandler.onComplete(e);
        }
        return configRpcHandler;
    }

    synchronized void sendInitialMessage(Node node) {
        TraceConfig currentTraceConfigProto = TraceProtoUtils.getCurrentTraceConfig(this.traceConfig);
        CurrentLibraryConfig firstConfig = CurrentLibraryConfig.newBuilder().setNode(node).setConfig(currentTraceConfigProto).build();
        this.sendCurrentConfig(firstConfig);
    }

    private synchronized void sendCurrentConfig() {
        TraceConfig currentTraceConfigProto = TraceProtoUtils.getCurrentTraceConfig(this.traceConfig);
        CurrentLibraryConfig currentLibraryConfig = CurrentLibraryConfig.newBuilder().setConfig(currentTraceConfigProto).build();
        this.sendCurrentConfig(currentLibraryConfig);
    }

    private synchronized void sendCurrentConfig(CurrentLibraryConfig currentLibraryConfig) {
        if (this.isCompleted() || this.currentConfigObserver == null) {
            return;
        }
        try {
            this.currentConfigObserver.onNext((Object)currentLibraryConfig);
        }
        catch (Exception e) {
            this.onComplete(e);
        }
    }

    synchronized void onComplete(@Nullable Throwable error) {
        if (this.isCompleted()) {
            return;
        }
        this.currentConfigObserver = null;
        Status status = error == null ? Status.OK : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus() : Status.UNKNOWN);
        this.terminateStatus = status;
    }

    synchronized boolean isCompleted() {
        return this.terminateStatus != null;
    }

    @Nullable
    @VisibleForTesting
    synchronized Status getTerminateStatus() {
        return this.terminateStatus;
    }

    @VisibleForTesting
    static class UpdatedLibraryConfigObserver
    implements StreamObserver<UpdatedLibraryConfig> {
        private final io.opencensus.trace.config.TraceConfig traceConfig;
        private final OcAgentTraceServiceConfigRpcHandler configRpcHandler;

        @VisibleForTesting
        UpdatedLibraryConfigObserver(io.opencensus.trace.config.TraceConfig traceConfig, OcAgentTraceServiceConfigRpcHandler configRpcHandler) {
            this.traceConfig = traceConfig;
            this.configRpcHandler = configRpcHandler;
        }

        public void onNext(UpdatedLibraryConfig value) {
            TraceParams updatedTraceParams = TraceProtoUtils.getUpdatedTraceParams(value, this.traceConfig);
            this.traceConfig.updateActiveTraceParams(updatedTraceParams);
            this.configRpcHandler.sendCurrentConfig();
        }

        public void onError(Throwable t) {
            logger.log(Level.WARNING, "Config stream is disconnected.", t);
            this.configRpcHandler.onComplete(t);
        }

        public void onCompleted() {
            this.configRpcHandler.onComplete(null);
        }
    }
}

