/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.logging;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LoggingExporter {
    private static final Logger logger = Logger.getLogger(LoggingExporter.class.getName());
    private static final String REGISTER_NAME = LoggingExporter.class.getName();
    private static final LoggingExporterHandler HANDLER = new LoggingExporterHandler();

    private LoggingExporter() {
    }

    public static void register() {
        LoggingExporter.register(Tracing.getExportComponent().getSpanExporter());
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter) {
        spanExporter.registerHandler(REGISTER_NAME, (SpanExporter.Handler)HANDLER);
    }

    public static void unregister() {
        LoggingExporter.unregister(Tracing.getExportComponent().getSpanExporter());
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }

    @VisibleForTesting
    static final class LoggingExporterHandler
    extends SpanExporter.Handler {
        LoggingExporterHandler() {
        }

        public void export(Collection<SpanData> spanDataList) {
            for (SpanData spanData : spanDataList) {
                logger.log(Level.INFO, spanData.toString());
            }
        }
    }
}

