/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.jaeger;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.MustBeClosed;
import com.uber.jaeger.senders.HttpSender;
import com.uber.jaeger.thriftjava.Log;
import com.uber.jaeger.thriftjava.Process;
import com.uber.jaeger.thriftjava.Span;
import com.uber.jaeger.thriftjava.SpanRef;
import com.uber.jaeger.thriftjava.SpanRefType;
import com.uber.jaeger.thriftjava.Tag;
import com.uber.jaeger.thriftjava.TagType;
import io.opencensus.common.Function;
import io.opencensus.common.Scope;
import io.opencensus.common.Timestamp;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Link;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.Status;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TException;

@NotThreadSafe
final class JaegerExporterHandler
extends SpanExporter.Handler {
    private static final String EXPORT_SPAN_NAME = "ExportJaegerTraces";
    private static final String DESCRIPTION = "description";
    private static final Logger logger = Logger.getLogger(JaegerExporterHandler.class.getName());
    private static final Sampler lowProbabilitySampler = Samplers.probabilitySampler((double)1.0E-4);
    private static final Tracer tracer = Tracing.getTracer();
    private static final Function<? super String, Tag> stringAttributeConverter = new Function<String, Tag>(){

        public Tag apply(String value) {
            Tag tag = new Tag();
            tag.setVType(TagType.STRING);
            tag.setVStr(value);
            return tag;
        }
    };
    private static final Function<? super Boolean, Tag> booleanAttributeConverter = new Function<Boolean, Tag>(){

        public Tag apply(Boolean value) {
            Tag tag = new Tag();
            tag.setVType(TagType.BOOL);
            tag.setVBool(value.booleanValue());
            return tag;
        }
    };
    private static final Function<? super Long, Tag> longAttributeConverter = new Function<Long, Tag>(){

        public Tag apply(Long value) {
            Tag tag = new Tag();
            tag.setVType(TagType.LONG);
            tag.setVLong(value.longValue());
            return tag;
        }
    };
    private static final Function<Object, Tag> defaultAttributeConverter = new Function<Object, Tag>(){

        public Tag apply(Object value) {
            Tag tag = new Tag();
            tag.setVType(TagType.STRING);
            tag.setVStr(value.toString());
            return tag;
        }
    };
    private final byte[] spanIdBuffer = new byte[8];
    private final byte[] traceIdBuffer = new byte[16];
    private final byte[] optionsBuffer = new byte[4];
    private final HttpSender sender;
    private final Process process;

    JaegerExporterHandler(HttpSender sender, Process process) {
        this.sender = (HttpSender)Preconditions.checkNotNull((Object)sender, (Object)"Jaeger sender must NOT be null.");
        this.process = (Process)Preconditions.checkNotNull((Object)process, (Object)"Process sending traces must NOT be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Collection<SpanData> spanDataList) {
        Scope exportScope = JaegerExporterHandler.newExportScope();
        try {
            this.doExport(spanDataList);
        }
        catch (TException e) {
            tracer.getCurrentSpan().setStatus(Status.UNKNOWN.withDescription(JaegerExporterHandler.getMessageOrDefault(e)));
            logger.log(Level.WARNING, "Failed to export traces to Jaeger: " + (Object)((Object)e));
        }
        finally {
            exportScope.close();
        }
    }

    @MustBeClosed
    private static Scope newExportScope() {
        return tracer.spanBuilder(EXPORT_SPAN_NAME).setSampler(lowProbabilitySampler).startScopedSpan();
    }

    private void doExport(Collection<SpanData> spanDataList) throws TException {
        List<Span> spans = this.spanDataToJaegerThriftSpans(spanDataList);
        this.sender.send(this.process, spans);
    }

    private static String getMessageOrDefault(TException e) {
        return e.getMessage() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getMessage();
    }

    private List<Span> spanDataToJaegerThriftSpans(Collection<SpanData> spanDataList) {
        ArrayList spans = Lists.newArrayListWithExpectedSize((int)spanDataList.size());
        for (SpanData spanData : spanDataList) {
            spans.add(this.spanDataToJaegerThriftSpan(spanData));
        }
        return spans;
    }

    private Span spanDataToJaegerThriftSpan(SpanData spanData) {
        long startTimeInMicros = JaegerExporterHandler.timestampToMicros(spanData.getStartTimestamp());
        long endTimeInMicros = JaegerExporterHandler.timestampToMicros(spanData.getEndTimestamp());
        SpanContext context = spanData.getContext();
        this.copyToBuffer(context.getTraceId());
        return new Span(this.traceIdLow(), this.traceIdHigh(), this.spanIdToLong(context.getSpanId()), this.spanIdToLong(spanData.getParentSpanId()), spanData.getName(), this.optionsToFlags(context.getTraceOptions()), startTimeInMicros, endTimeInMicros - startTimeInMicros).setReferences(this.linksToReferences(spanData.getLinks().getLinks())).setTags(JaegerExporterHandler.attributesToTags(spanData.getAttributes().getAttributeMap())).setLogs(JaegerExporterHandler.annotationEventsToLogs(spanData.getAnnotations().getEvents()));
    }

    private void copyToBuffer(TraceId traceId) {
        traceId.copyBytesTo(this.traceIdBuffer, 0);
    }

    private long traceIdHigh() {
        return Longs.fromBytes((byte)this.traceIdBuffer[0], (byte)this.traceIdBuffer[1], (byte)this.traceIdBuffer[2], (byte)this.traceIdBuffer[3], (byte)this.traceIdBuffer[4], (byte)this.traceIdBuffer[5], (byte)this.traceIdBuffer[6], (byte)this.traceIdBuffer[7]);
    }

    private long traceIdLow() {
        return Longs.fromBytes((byte)this.traceIdBuffer[8], (byte)this.traceIdBuffer[9], (byte)this.traceIdBuffer[10], (byte)this.traceIdBuffer[11], (byte)this.traceIdBuffer[12], (byte)this.traceIdBuffer[13], (byte)this.traceIdBuffer[14], (byte)this.traceIdBuffer[15]);
    }

    private long spanIdToLong(@Nullable SpanId spanId) {
        if (spanId == null) {
            return 0L;
        }
        spanId.copyBytesTo(this.spanIdBuffer, 0);
        return Longs.fromByteArray((byte[])this.spanIdBuffer);
    }

    private int optionsToFlags(TraceOptions traceOptions) {
        traceOptions.copyBytesTo(this.optionsBuffer, this.optionsBuffer.length - 1);
        return Ints.fromByteArray((byte[])this.optionsBuffer);
    }

    private List<SpanRef> linksToReferences(List<Link> links) {
        ArrayList spanRefs = Lists.newArrayListWithExpectedSize((int)links.size());
        for (Link link : links) {
            this.copyToBuffer(link.getTraceId());
            spanRefs.add(new SpanRef(JaegerExporterHandler.linkTypeToRefType(link.getType()), this.traceIdLow(), this.traceIdHigh(), this.spanIdToLong(link.getSpanId())));
        }
        return spanRefs;
    }

    private static long timestampToMicros(@Nullable Timestamp timestamp) {
        return timestamp == null ? 0L : TimeUnit.SECONDS.toMicros(timestamp.getSeconds()) + TimeUnit.NANOSECONDS.toMicros(timestamp.getNanos());
    }

    private static SpanRefType linkTypeToRefType(Link.Type type) {
        switch (type) {
            case CHILD_LINKED_SPAN: {
                return SpanRefType.CHILD_OF;
            }
            case PARENT_LINKED_SPAN: {
                return SpanRefType.FOLLOWS_FROM;
            }
        }
        throw new UnsupportedOperationException(String.format("Failed to convert link type [%s] to a Jaeger SpanRefType.", type));
    }

    private static List<Tag> attributesToTags(Map<String, AttributeValue> attributes) {
        ArrayList tags = Lists.newArrayListWithExpectedSize((int)attributes.size());
        for (Map.Entry<String, AttributeValue> entry : attributes.entrySet()) {
            Tag tag = (Tag)entry.getValue().match(stringAttributeConverter, booleanAttributeConverter, longAttributeConverter, defaultAttributeConverter);
            tag.setKey(entry.getKey());
            tags.add(tag);
        }
        return tags;
    }

    private static List<Log> annotationEventsToLogs(List<SpanData.TimedEvent<Annotation>> events) {
        ArrayList logs = Lists.newArrayListWithExpectedSize((int)events.size());
        for (SpanData.TimedEvent<Annotation> event : events) {
            long timestampsInMicros = JaegerExporterHandler.timestampToMicros(event.getTimestamp());
            List<Tag> tags = JaegerExporterHandler.attributesToTags(((Annotation)event.getEvent()).getAttributes());
            tags.add(JaegerExporterHandler.descriptionToTag(((Annotation)event.getEvent()).getDescription()));
            Log log = new Log(timestampsInMicros, tags);
            logs.add(log);
        }
        return logs;
    }

    private static Tag descriptionToTag(String description) {
        Tag tag = new Tag(DESCRIPTION, TagType.STRING);
        tag.setVStr(description);
        return tag;
    }
}

