/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.metrics.ocagent;

import com.google.protobuf.DoubleValue;
import com.google.protobuf.Int64Value;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.data.AttachmentValue;
import io.opencensus.metrics.data.Exemplar;
import io.opencensus.metrics.export.Distribution;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Summary;
import io.opencensus.metrics.export.TimeSeries;
import io.opencensus.proto.metrics.v1.DistributionValue;
import io.opencensus.proto.metrics.v1.LabelValue;
import io.opencensus.proto.metrics.v1.Metric;
import io.opencensus.proto.metrics.v1.MetricDescriptor;
import io.opencensus.proto.metrics.v1.Point;
import io.opencensus.proto.metrics.v1.SummaryValue;
import io.opencensus.proto.metrics.v1.TimeSeries;
import io.opencensus.proto.resource.v1.Resource;
import io.opencensus.resource.Resource;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class MetricsProtoUtils {
    static Metric toMetricProto(io.opencensus.metrics.export.Metric metric, @Nullable Resource resource) {
        Metric.Builder builder = Metric.newBuilder();
        builder.setMetricDescriptor(MetricsProtoUtils.toMetricDescriptorProto(metric.getMetricDescriptor()));
        for (TimeSeries timeSeries : metric.getTimeSeriesList()) {
            builder.addTimeseries(MetricsProtoUtils.toTimeSeriesProto(timeSeries));
        }
        if (resource != null) {
            builder.setResource(MetricsProtoUtils.toResourceProto(resource));
        }
        return builder.build();
    }

    private static io.opencensus.proto.metrics.v1.MetricDescriptor toMetricDescriptorProto(MetricDescriptor metricDescriptor) {
        MetricDescriptor.Builder builder = io.opencensus.proto.metrics.v1.MetricDescriptor.newBuilder();
        builder.setName(metricDescriptor.getName()).setDescription(metricDescriptor.getDescription()).setUnit(metricDescriptor.getUnit()).setType(MetricsProtoUtils.toTypeProto(metricDescriptor.getType()));
        for (LabelKey labelKey : metricDescriptor.getLabelKeys()) {
            builder.addLabelKeys(MetricsProtoUtils.toLabelKeyProto(labelKey));
        }
        return builder.build();
    }

    private static MetricDescriptor.Type toTypeProto(MetricDescriptor.Type type) {
        switch (type) {
            case CUMULATIVE_INT64: {
                return MetricDescriptor.Type.CUMULATIVE_INT64;
            }
            case CUMULATIVE_DOUBLE: {
                return MetricDescriptor.Type.CUMULATIVE_DOUBLE;
            }
            case CUMULATIVE_DISTRIBUTION: {
                return MetricDescriptor.Type.CUMULATIVE_DISTRIBUTION;
            }
            case GAUGE_INT64: {
                return MetricDescriptor.Type.GAUGE_INT64;
            }
            case GAUGE_DOUBLE: {
                return MetricDescriptor.Type.GAUGE_DOUBLE;
            }
            case GAUGE_DISTRIBUTION: {
                return MetricDescriptor.Type.GAUGE_DISTRIBUTION;
            }
            case SUMMARY: {
                return MetricDescriptor.Type.SUMMARY;
            }
        }
        return MetricDescriptor.Type.UNRECOGNIZED;
    }

    private static io.opencensus.proto.metrics.v1.LabelKey toLabelKeyProto(LabelKey labelKey) {
        return io.opencensus.proto.metrics.v1.LabelKey.newBuilder().setKey(labelKey.getKey()).setDescription(labelKey.getDescription()).build();
    }

    private static io.opencensus.proto.resource.v1.Resource toResourceProto(Resource resource) {
        Resource.Builder builder = io.opencensus.proto.resource.v1.Resource.newBuilder();
        if (resource.getType() != null) {
            builder.setType(resource.getType());
        }
        builder.putAllLabels(resource.getLabels());
        return builder.build();
    }

    private static io.opencensus.proto.metrics.v1.TimeSeries toTimeSeriesProto(TimeSeries timeSeries) {
        TimeSeries.Builder builder = io.opencensus.proto.metrics.v1.TimeSeries.newBuilder();
        if (timeSeries.getStartTimestamp() != null) {
            builder.setStartTimestamp(MetricsProtoUtils.toTimestampProto(timeSeries.getStartTimestamp()));
        }
        for (LabelValue labelValue : timeSeries.getLabelValues()) {
            builder.addLabelValues(MetricsProtoUtils.toLabelValueProto(labelValue));
        }
        for (io.opencensus.metrics.export.Point point : timeSeries.getPoints()) {
            builder.addPoints(MetricsProtoUtils.toPointProto(point));
        }
        return builder.build();
    }

    private static io.opencensus.proto.metrics.v1.LabelValue toLabelValueProto(LabelValue labelValue) {
        LabelValue.Builder builder = io.opencensus.proto.metrics.v1.LabelValue.newBuilder();
        if (labelValue.getValue() == null) {
            builder.setHasValue(false);
        } else {
            builder.setHasValue(true).setValue(labelValue.getValue());
        }
        return builder.build();
    }

    private static Point toPointProto(io.opencensus.metrics.export.Point point) {
        final Point.Builder builder = Point.newBuilder();
        builder.setTimestamp(MetricsProtoUtils.toTimestampProto(point.getTimestamp()));
        point.getValue().match((Function)new Function<Double, Void>(){

            public Void apply(Double arg) {
                builder.setDoubleValue(arg.doubleValue());
                return null;
            }
        }, (Function)new Function<Long, Void>(){

            public Void apply(Long arg) {
                builder.setInt64Value(arg.longValue());
                return null;
            }
        }, (Function)new Function<Distribution, Void>(){

            public Void apply(Distribution arg) {
                builder.setDistributionValue(MetricsProtoUtils.toDistributionProto(arg));
                return null;
            }
        }, (Function)new Function<Summary, Void>(){

            public Void apply(Summary arg) {
                builder.setSummaryValue(MetricsProtoUtils.toSummaryProto(arg));
                return null;
            }
        }, Functions.throwAssertionError());
        return builder.build();
    }

    private static DistributionValue toDistributionProto(Distribution distribution) {
        DistributionValue.Builder builder = DistributionValue.newBuilder();
        builder.setSum(distribution.getSum()).setCount(distribution.getCount()).setSumOfSquaredDeviation(distribution.getSumOfSquaredDeviations());
        if (distribution.getBucketOptions() != null) {
            builder.setBucketOptions(MetricsProtoUtils.toBucketOptionsProto(distribution.getBucketOptions()));
        }
        for (Distribution.Bucket bucket : distribution.getBuckets()) {
            builder.addBuckets(MetricsProtoUtils.toBucketProto(bucket));
        }
        return builder.build();
    }

    private static DistributionValue.BucketOptions toBucketOptionsProto(Distribution.BucketOptions bucketOptions) {
        final DistributionValue.BucketOptions.Builder builder = DistributionValue.BucketOptions.newBuilder();
        bucketOptions.match((Function)new Function<Distribution.BucketOptions.ExplicitOptions, Void>(){

            public Void apply(Distribution.BucketOptions.ExplicitOptions arg) {
                builder.setExplicit(DistributionValue.BucketOptions.Explicit.newBuilder().addAllBounds((Iterable)arg.getBucketBoundaries()).build());
                return null;
            }
        }, Functions.throwAssertionError());
        return builder.build();
    }

    private static DistributionValue.Bucket toBucketProto(Distribution.Bucket bucket) {
        DistributionValue.Bucket.Builder builder = DistributionValue.Bucket.newBuilder().setCount(bucket.getCount());
        Exemplar exemplar = bucket.getExemplar();
        if (exemplar != null) {
            builder.setExemplar(MetricsProtoUtils.toExemplarProto(exemplar));
        }
        return builder.build();
    }

    private static DistributionValue.Exemplar toExemplarProto(Exemplar exemplar) {
        HashMap stringAttachments = new HashMap();
        for (Map.Entry entry : exemplar.getAttachments().entrySet()) {
            stringAttachments.put(entry.getKey(), ((AttachmentValue)entry.getValue()).getValue());
        }
        return DistributionValue.Exemplar.newBuilder().setValue(exemplar.getValue()).setTimestamp(MetricsProtoUtils.toTimestampProto(exemplar.getTimestamp())).putAllAttachments(stringAttachments).build();
    }

    private static SummaryValue toSummaryProto(Summary summary) {
        SummaryValue.Builder builder = SummaryValue.newBuilder();
        if (summary.getSum() != null) {
            builder.setSum(DoubleValue.of((double)summary.getSum()));
        }
        if (summary.getCount() != null) {
            builder.setCount(Int64Value.of((long)summary.getCount()));
        }
        builder.setSnapshot(MetricsProtoUtils.toSnapshotProto(summary.getSnapshot()));
        return builder.build();
    }

    private static SummaryValue.Snapshot toSnapshotProto(Summary.Snapshot snapshot) {
        SummaryValue.Snapshot.Builder builder = SummaryValue.Snapshot.newBuilder();
        if (snapshot.getSum() != null) {
            builder.setSum(DoubleValue.of((double)snapshot.getSum()));
        }
        if (snapshot.getCount() != null) {
            builder.setCount(Int64Value.of((long)snapshot.getCount()));
        }
        for (Summary.Snapshot.ValueAtPercentile valueAtPercentile : snapshot.getValueAtPercentiles()) {
            builder.addPercentileValues(SummaryValue.Snapshot.ValueAtPercentile.newBuilder().setValue(valueAtPercentile.getValue()).setPercentile(valueAtPercentile.getPercentile()).build());
        }
        return builder.build();
    }

    static com.google.protobuf.Timestamp toTimestampProto(Timestamp timestamp) {
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(timestamp.getSeconds()).setNanos(timestamp.getNanos()).build();
    }

    private MetricsProtoUtils() {
    }
}

