/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.logcorrelation.log4j2;

import io.opencensus.contrib.logcorrelation.log4j2.OpenCensusTraceContextDataInjector;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.unsafe.ContextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.TriConsumer;

final class ContextDataUtils {
    private ContextDataUtils() {
    }

    static StringMap injectContextData(OpenCensusTraceContextDataInjector.SpanSelection spanSelection, @Nullable List<Property> properties, StringMap reusable) {
        if (properties == null || properties.isEmpty()) {
            return ContextDataUtils.shareableRawContextData(spanSelection);
        }
        ContextDataUtils.putProperties(properties, reusable);
        reusable.putAll(ContextDataUtils.nonShareableRawContextData(spanSelection));
        return reusable;
    }

    private static void putProperties(Collection<Property> properties, StringMap stringMap) {
        for (Property property : properties) {
            stringMap.putValue(property.getName(), (Object)property.getValue());
        }
    }

    private static StringMap shareableRawContextData(OpenCensusTraceContextDataInjector.SpanSelection spanSelection) {
        SpanContext spanContext = ContextDataUtils.shouldAddTracingDataToLogEvent(spanSelection);
        return spanContext == null ? ContextDataUtils.getShareableContextData() : ContextDataUtils.getShareableContextAndTracingData(spanContext);
    }

    static ReadOnlyStringMap nonShareableRawContextData(OpenCensusTraceContextDataInjector.SpanSelection spanSelection) {
        SpanContext spanContext = ContextDataUtils.shouldAddTracingDataToLogEvent(spanSelection);
        return spanContext == null ? ContextDataUtils.getNonShareableContextData() : ContextDataUtils.getShareableContextAndTracingData(spanContext);
    }

    @Nullable
    private static SpanContext shouldAddTracingDataToLogEvent(OpenCensusTraceContextDataInjector.SpanSelection spanSelection) {
        switch (spanSelection) {
            case NO_SPANS: {
                return null;
            }
            case SAMPLED_SPANS: {
                SpanContext spanContext = ContextDataUtils.getCurrentSpanContext();
                if (spanContext.getTraceOptions().isSampled()) {
                    return spanContext;
                }
                return null;
            }
            case ALL_SPANS: {
                return ContextDataUtils.getCurrentSpanContext();
            }
        }
        throw new AssertionError((Object)("Unknown spanSelection: " + (Object)((Object)spanSelection)));
    }

    private static StringMap getShareableContextData() {
        ReadOnlyThreadContextMap context = ThreadContext.getThreadContextMap();
        return context == null ? new SortedArrayStringMap(ThreadContext.getImmutableContext()) : new SortedArrayStringMap((ReadOnlyStringMap)context.getReadOnlyContextData());
    }

    private static ReadOnlyStringMap getNonShareableContextData() {
        ReadOnlyThreadContextMap context = ThreadContext.getThreadContextMap();
        if (context != null) {
            return context.getReadOnlyContextData();
        }
        Map contextMap = ThreadContext.getImmutableContext();
        return contextMap.isEmpty() ? UnmodifiableReadOnlyStringMap.EMPTY : new UnmodifiableReadOnlyStringMap(contextMap);
    }

    private static StringMap getShareableContextAndTracingData(SpanContext spanContext) {
        SortedArrayStringMap stringMap;
        ReadOnlyThreadContextMap context = ThreadContext.getThreadContextMap();
        if (context == null) {
            stringMap = new SortedArrayStringMap(ThreadContext.getImmutableContext());
        } else {
            StringMap contextData = context.getReadOnlyContextData();
            stringMap = new SortedArrayStringMap(contextData.size() + 3);
            stringMap.putAll((ReadOnlyStringMap)contextData);
        }
        stringMap.putValue("opencensusTraceId", (Object)spanContext.getTraceId().toLowerBase16());
        stringMap.putValue("opencensusSpanId", (Object)spanContext.getSpanId().toLowerBase16());
        stringMap.putValue("opencensusTraceSampled", (Object)(spanContext.getTraceOptions().isSampled() ? "true" : "false"));
        return stringMap;
    }

    private static SpanContext getCurrentSpanContext() {
        Span span = (Span)ContextUtils.CONTEXT_SPAN_KEY.get();
        return span == null ? SpanContext.INVALID : span.getContext();
    }

    @Immutable
    private static final class UnmodifiableReadOnlyStringMap
    implements ReadOnlyStringMap {
        private static final long serialVersionUID = 0L;
        static final ReadOnlyStringMap EMPTY = new UnmodifiableReadOnlyStringMap(Collections.<String, String>emptyMap());
        private final Map<String, String> map;

        UnmodifiableReadOnlyStringMap(Map<String, String> map) {
            this.map = map;
        }

        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        public <V> void forEach(BiConsumer<String, ? super V> action) {
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                action.accept((Object)entry.getKey(), (Object)entry.getValue());
            }
        }

        public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                action.accept((Object)entry.getKey(), (Object)entry.getValue(), state);
            }
        }

        @Nullable
        public <V> V getValue(String key) {
            return (V)this.map.get(key);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public int size() {
            return this.map.size();
        }

        public Map<String, String> toMap() {
            return this.map;
        }
    }
}

