/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.logcorrelation.log4j2;

import io.opencensus.contrib.logcorrelation.log4j2.ContextDataUtils;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;

public final class OpenCensusTraceContextDataInjector
implements ContextDataInjector {
    private static final SpanSelection DEFAULT_SPAN_SELECTION = SpanSelection.ALL_SPANS;
    public static final String TRACE_ID_CONTEXT_KEY = "opencensusTraceId";
    public static final String SPAN_ID_CONTEXT_KEY = "opencensusSpanId";
    public static final String TRACE_SAMPLED_CONTEXT_KEY = "opencensusTraceSampled";
    public static final String SPAN_SELECTION_PROPERTY_NAME = "io.opencensus.contrib.logcorrelation.log4j2.OpenCensusTraceContextDataInjector.spanSelection";
    private final SpanSelection spanSelection;

    public SpanSelection getSpanSelection() {
        return this.spanSelection;
    }

    public OpenCensusTraceContextDataInjector() {
        this(OpenCensusTraceContextDataInjector.lookUpSpanSelectionProperty());
    }

    private OpenCensusTraceContextDataInjector(SpanSelection spanSelection) {
        this.spanSelection = spanSelection;
    }

    private static SpanSelection lookUpSpanSelectionProperty() {
        String spanSelectionProperty = System.getProperty(SPAN_SELECTION_PROPERTY_NAME);
        return spanSelectionProperty == null || spanSelectionProperty.isEmpty() ? DEFAULT_SPAN_SELECTION : OpenCensusTraceContextDataInjector.parseSpanSelection(spanSelectionProperty);
    }

    private static SpanSelection parseSpanSelection(String spanSelection) {
        try {
            return SpanSelection.valueOf(spanSelection);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_SPAN_SELECTION;
        }
    }

    public StringMap injectContextData(@Nullable List<Property> properties, StringMap reusable) {
        return ContextDataUtils.injectContextData(this.spanSelection, properties, reusable);
    }

    public ReadOnlyStringMap rawContextData() {
        return ContextDataUtils.nonShareableRawContextData(this.spanSelection);
    }

    public static enum SpanSelection {
        NO_SPANS,
        SAMPLED_SPANS,
        ALL_SPANS;

    }
}

