/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent;

import io.opencensus.contrib.agent.deps.guava.annotations.VisibleForTesting;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.deps.guava.base.Strings;
import io.opencensus.contrib.agent.deps.guava.io.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class Resources {
    Resources() {
    }

    static File getResourceAsTempFile(String resourceName) throws IOException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(resourceName), "resourceName");
        File file = File.createTempFile(resourceName, ".tmp");
        FileOutputStream os = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            Resources.getResourceAsTempFile(resourceName, file, os);
            File file2 = file;
            return file2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (os != null) {
                if (throwable != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    ((OutputStream)os).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void getResourceAsTempFile(String resourceName, File file, OutputStream outputStream) throws IOException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(resourceName), "resourceName");
        Preconditions.checkNotNull(file, "file");
        Preconditions.checkNotNull(outputStream, "outputStream");
        file.deleteOnExit();
        InputStream is = Resources.getResourceAsStream(resourceName);
        try {
            ByteStreams.copy(is, outputStream);
        }
        finally {
            is.close();
        }
    }

    private static InputStream getResourceAsStream(String resourceName) throws FileNotFoundException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(resourceName), "resourceName");
        InputStream is = Resources.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException("Cannot find resource '" + resourceName + "' on the class path.");
        }
        return is;
    }
}

