/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.asm;

import io.opencensus.contrib.agent.deps.bytebuddy.asm.AsmVisitorWrapper;
import io.opencensus.contrib.agent.deps.bytebuddy.description.field.FieldDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.field.FieldList;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodList;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.Implementation;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.ClassVisitor;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.FieldVisitor;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.MethodVisitor;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatcher;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatchers;
import io.opencensus.contrib.agent.deps.bytebuddy.pool.TypePool;
import io.opencensus.contrib.agent.deps.bytebuddy.utility.CompoundList;
import java.util.HashMap;
import java.util.Map;

public class MemberRemoval
extends AsmVisitorWrapper.AbstractBase {
    private final ElementMatcher.Junction<FieldDescription.InDefinedShape> fieldMatcher;
    private final ElementMatcher.Junction<MethodDescription> methodMatcher;

    public MemberRemoval() {
        this(ElementMatchers.none(), ElementMatchers.none());
    }

    protected MemberRemoval(ElementMatcher.Junction<FieldDescription.InDefinedShape> fieldMatcher, ElementMatcher.Junction<MethodDescription> methodMatcher) {
        this.fieldMatcher = fieldMatcher;
        this.methodMatcher = methodMatcher;
    }

    public MemberRemoval stripFields(ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
        return new MemberRemoval(this.fieldMatcher.or(matcher), this.methodMatcher);
    }

    public MemberRemoval stripMethods(ElementMatcher<? super MethodDescription> matcher) {
        return this.stripInvokables(ElementMatchers.isMethod().and(matcher));
    }

    public MemberRemoval stripConstructors(ElementMatcher<? super MethodDescription> matcher) {
        return this.stripInvokables(ElementMatchers.isConstructor().and(matcher));
    }

    public MemberRemoval stripInvokables(ElementMatcher<? super MethodDescription> matcher) {
        return new MemberRemoval(this.fieldMatcher, this.methodMatcher.or(matcher));
    }

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        HashMap<String, FieldDescription.InDefinedShape> mappedFields = new HashMap<String, FieldDescription.InDefinedShape>();
        for (FieldDescription.InDefinedShape fieldDescription : fields) {
            mappedFields.put(fieldDescription.getInternalName() + fieldDescription.getDescriptor(), fieldDescription);
        }
        HashMap<String, MethodDescription> mappedMethods = new HashMap<String, MethodDescription>();
        for (MethodDescription methodDescription : CompoundList.of(methods, new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
            mappedMethods.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
        }
        return new MemberRemovingClassVisitor(classVisitor, this.fieldMatcher, this.methodMatcher, mappedFields, mappedMethods);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemberRemoval)) {
            return false;
        }
        MemberRemoval other = (MemberRemoval)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ElementMatcher.Junction<FieldDescription.InDefinedShape> this$fieldMatcher = this.fieldMatcher;
        ElementMatcher.Junction<FieldDescription.InDefinedShape> other$fieldMatcher = other.fieldMatcher;
        if (this$fieldMatcher == null ? other$fieldMatcher != null : !this$fieldMatcher.equals(other$fieldMatcher)) {
            return false;
        }
        ElementMatcher.Junction<MethodDescription> this$methodMatcher = this.methodMatcher;
        ElementMatcher.Junction<MethodDescription> other$methodMatcher = other.methodMatcher;
        return !(this$methodMatcher == null ? other$methodMatcher != null : !this$methodMatcher.equals(other$methodMatcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MemberRemoval;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ElementMatcher.Junction<FieldDescription.InDefinedShape> $fieldMatcher = this.fieldMatcher;
        result = result * 59 + ($fieldMatcher == null ? 43 : $fieldMatcher.hashCode());
        ElementMatcher.Junction<MethodDescription> $methodMatcher = this.methodMatcher;
        result = result * 59 + ($methodMatcher == null ? 43 : $methodMatcher.hashCode());
        return result;
    }

    protected static class MemberRemovingClassVisitor
    extends ClassVisitor {
        private static final FieldVisitor REMOVE_FIELD = null;
        private static final MethodVisitor REMOVE_METHOD = null;
        private final ElementMatcher.Junction<FieldDescription.InDefinedShape> fieldMatcher;
        private final ElementMatcher.Junction<MethodDescription> methodMatcher;
        private final Map<String, FieldDescription.InDefinedShape> fields;
        private final Map<String, MethodDescription> methods;

        protected MemberRemovingClassVisitor(ClassVisitor classVisitor, ElementMatcher.Junction<FieldDescription.InDefinedShape> fieldMatcher, ElementMatcher.Junction<MethodDescription> methodMatcher, Map<String, FieldDescription.InDefinedShape> fields, Map<String, MethodDescription> methods) {
            super(327680, classVisitor);
            this.fieldMatcher = fieldMatcher;
            this.methodMatcher = methodMatcher;
            this.fields = fields;
            this.methods = methods;
        }

        @Override
        public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String signature, Object value) {
            FieldDescription.InDefinedShape fieldDescription = this.fields.get(internalName + descriptor);
            return fieldDescription != null && this.fieldMatcher.matches(fieldDescription) ? REMOVE_FIELD : super.visitField(modifiers, internalName, descriptor, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
            MethodDescription methodDescription = this.methods.get(internalName + descriptor);
            return methodDescription != null && this.methodMatcher.matches(methodDescription) ? REMOVE_METHOD : super.visitMethod(modifiers, internalName, descriptor, signature, exception);
        }
    }
}

