/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent;

import io.opencensus.contrib.agent.deps.guava.annotations.VisibleForTesting;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.deps.guava.base.Strings;
import io.opencensus.contrib.agent.deps.guava.io.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class Resources {
    private Resources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getResourceAsTempFile(String resourceName) throws IOException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(resourceName), "resourceName");
        File file = File.createTempFile(resourceName, ".tmp");
        try (FileOutputStream os = new FileOutputStream(file);){
            Resources.getResourceAsTempFile(resourceName, file, os);
            File file2 = file;
            return file2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void getResourceAsTempFile(String resourceName, File file, OutputStream outputStream) throws IOException {
        file.deleteOnExit();
        try (InputStream is = Resources.getResourceAsStream(resourceName);){
            ByteStreams.copy(is, outputStream);
        }
    }

    private static InputStream getResourceAsStream(String resourceName) throws FileNotFoundException {
        InputStream is = Resources.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException("Cannot find resource '" + resourceName + "' on the class path.");
        }
        return is;
    }
}

