/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.matcher;

import io.opencensus.contrib.agent.deps.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDefinition;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatcher;
import java.util.HashSet;
import java.util.Set;

@HashCodeAndEqualsPlugin.Enhance
public class HasSuperTypeMatcher<T extends TypeDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super TypeDescription.Generic> matcher;

    public HasSuperTypeMatcher(ElementMatcher<? super TypeDescription.Generic> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(T target) {
        HashSet<TypeDescription> checkedInterfaces = new HashSet<TypeDescription>();
        for (TypeDefinition typeDefinition : target) {
            if (!this.matcher.matches(typeDefinition.asGenericType()) && !this.hasInterface(typeDefinition, checkedInterfaces)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterface(TypeDefinition typeDefinition, Set<TypeDescription> checkedInterfaces) {
        for (TypeDefinition interfaceType : typeDefinition.getInterfaces()) {
            if (!checkedInterfaces.add(interfaceType.asErasure()) || !this.matcher.matches(interfaceType.asGenericType()) && !this.hasInterface(interfaceType, checkedInterfaces)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "hasSuperType(" + this.matcher + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.matcher.equals(((HasSuperTypeMatcher)object).matcher);
    }

    public int hashCode() {
        return 17 * 31 + this.matcher.hashCode();
    }
}

