/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.ClassFileLocator;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.loading.ClassInjector;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassReloadingStrategy
implements ClassLoadingStrategy<ClassLoader> {
    private static final String INSTALLER_TYPE = "io.opencensus.contrib.agent.deps.bytebuddy.agent.Installer";
    private static final String INSTRUMENTATION_GETTER = "getInstrumentation";
    private static final Object STATIC_MEMBER = null;
    private final Instrumentation instrumentation;
    private final Strategy strategy;
    private final BootstrapInjection bootstrapInjection;
    private final Map<String, Class<?>> preregisteredTypes;

    public ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy) {
        this(instrumentation, strategy, BootstrapInjection.Disabled.INSTANCE, Collections.emptyMap());
    }

    protected ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy, BootstrapInjection bootstrapInjection, Map<String, Class<?>> preregisteredTypes) {
        this.instrumentation = instrumentation;
        this.strategy = strategy.validate(instrumentation);
        this.bootstrapInjection = bootstrapInjection;
        this.preregisteredTypes = preregisteredTypes;
    }

    public static ClassReloadingStrategy of(Instrumentation instrumentation) {
        if (instrumentation.isRetransformClassesSupported()) {
            return new ClassReloadingStrategy(instrumentation, Strategy.RETRANSFORMATION);
        }
        if (instrumentation.isRedefineClassesSupported()) {
            return new ClassReloadingStrategy(instrumentation, Strategy.REDEFINITION);
        }
        throw new IllegalArgumentException("Instrumentation does not support reloading of classes: " + instrumentation);
    }

    public static ClassReloadingStrategy fromInstalledAgent() {
        try {
            return ClassReloadingStrategy.of((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getMethod(INSTRUMENTATION_GETTER, new Class[0]).invoke(STATIC_MEMBER, new Object[0]));
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
        }
    }

    public static ClassReloadingStrategy fromInstalledAgent(Strategy strategy) {
        try {
            return new ClassReloadingStrategy((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getMethod(INSTRUMENTATION_GETTER, new Class[0]).invoke(STATIC_MEMBER, new Object[0]), strategy);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
        }
    }

    @Override
    public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        HashMap availableTypes = new HashMap(this.preregisteredTypes);
        for (Class type : this.instrumentation.getInitiatedClasses(classLoader)) {
            availableTypes.put(TypeDescription.ForLoadedType.getName(type), type);
        }
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap();
        HashMap loadedClasses = new HashMap();
        LinkedHashMap unloadedClasses = new LinkedHashMap();
        for (Map.Entry entry : types.entrySet()) {
            Class type = (Class)availableTypes.get(((TypeDescription)entry.getKey()).getName());
            if (type != null) {
                classDefinitions.put(type, new ClassDefinition(type, (byte[])entry.getValue()));
                loadedClasses.put((TypeDescription)entry.getKey(), type);
                continue;
            }
            unloadedClasses.put(entry.getKey(), entry.getValue());
        }
        try {
            this.strategy.apply(this.instrumentation, classDefinitions);
            if (!unloadedClasses.isEmpty()) {
                loadedClasses.putAll((classLoader == null ? this.bootstrapInjection.make(this.instrumentation) : new ClassInjector.UsingReflection(classLoader)).inject(unloadedClasses));
            }
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Could not locate classes for redefinition", exception);
        }
        catch (UnmodifiableClassException exception) {
            throw new IllegalStateException("Cannot redefine specified class", exception);
        }
        return loadedClasses;
    }

    public ClassReloadingStrategy reset(Class<?> ... type) throws IOException {
        return type.length == 0 ? this : this.reset(ClassFileLocator.ForClassLoader.of(type[0].getClassLoader()), type);
    }

    public ClassReloadingStrategy reset(ClassFileLocator classFileLocator, Class<?> ... type) throws IOException {
        if (type.length > 0) {
            try {
                this.strategy.reset(this.instrumentation, classFileLocator, Arrays.asList(type));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalArgumentException("Cannot locate types " + Arrays.toString(type), exception);
            }
            catch (UnmodifiableClassException exception) {
                throw new IllegalStateException("Cannot reset types " + Arrays.toString(type), exception);
            }
        }
        return this;
    }

    public ClassReloadingStrategy enableBootstrapInjection(File folder) {
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, new BootstrapInjection.Enabled(folder), this.preregisteredTypes);
    }

    public ClassReloadingStrategy preregistered(Class<?> ... type) {
        HashMap preregisteredTypes = new HashMap(this.preregisteredTypes);
        for (Class<?> aType : type) {
            preregisteredTypes.put(TypeDescription.ForLoadedType.getName(aType), aType);
        }
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, this.bootstrapInjection, preregisteredTypes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassReloadingStrategy)) {
            return false;
        }
        ClassReloadingStrategy other = (ClassReloadingStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Instrumentation this$instrumentation = this.instrumentation;
        Instrumentation other$instrumentation = other.instrumentation;
        if (this$instrumentation == null ? other$instrumentation != null : !this$instrumentation.equals(other$instrumentation)) {
            return false;
        }
        Strategy this$strategy = this.strategy;
        Strategy other$strategy = other.strategy;
        if (this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy)) {
            return false;
        }
        BootstrapInjection this$bootstrapInjection = this.bootstrapInjection;
        BootstrapInjection other$bootstrapInjection = other.bootstrapInjection;
        if (this$bootstrapInjection == null ? other$bootstrapInjection != null : !this$bootstrapInjection.equals(other$bootstrapInjection)) {
            return false;
        }
        Map<String, Class<?>> this$preregisteredTypes = this.preregisteredTypes;
        Map<String, Class<?>> other$preregisteredTypes = other.preregisteredTypes;
        return !(this$preregisteredTypes == null ? other$preregisteredTypes != null : !((Object)this$preregisteredTypes).equals(other$preregisteredTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassReloadingStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instrumentation $instrumentation = this.instrumentation;
        result = result * 59 + ($instrumentation == null ? 43 : $instrumentation.hashCode());
        Strategy $strategy = this.strategy;
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        BootstrapInjection $bootstrapInjection = this.bootstrapInjection;
        result = result * 59 + ($bootstrapInjection == null ? 43 : $bootstrapInjection.hashCode());
        Map<String, Class<?>> $preregisteredTypes = this.preregisteredTypes;
        result = result * 59 + ($preregisteredTypes == null ? 43 : ((Object)$preregisteredTypes).hashCode());
        return result;
    }

    protected static interface BootstrapInjection {
        public ClassInjector make(Instrumentation var1);

        public static class Enabled
        implements BootstrapInjection {
            private final File folder;

            protected Enabled(File folder) {
                this.folder = folder;
            }

            @Override
            public ClassInjector make(Instrumentation instrumentation) {
                return ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, instrumentation);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Enabled)) {
                    return false;
                }
                Enabled other = (Enabled)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                File this$folder = this.folder;
                File other$folder = other.folder;
                return !(this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Enabled;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                File $folder = this.folder;
                result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
                return result;
            }
        }

        public static enum Disabled implements BootstrapInjection
        {
            INSTANCE;


            @Override
            public ClassInjector make(Instrumentation instrumentation) {
                throw new IllegalStateException("Bootstrap injection is not enabled");
            }
        }
    }

    public static enum Strategy {
        REDEFINITION(true){

            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException, ClassNotFoundException {
                instrumentation.redefineClasses(classDefinitions.values().toArray(new ClassDefinition[classDefinitions.size()]));
            }

            @Override
            protected Strategy validate(Instrumentation instrumentation) {
                if (!instrumentation.isRedefineClassesSupported()) {
                    throw new IllegalArgumentException("Does not support redefinition: " + instrumentation);
                }
                return this;
            }

            @Override
            public void reset(Instrumentation instrumentation, ClassFileLocator classFileLocator, List<Class<?>> types) throws IOException, UnmodifiableClassException, ClassNotFoundException {
                HashMap classDefinitions = new HashMap(types.size());
                for (Class<?> type : types) {
                    classDefinitions.put(type, new ClassDefinition(type, classFileLocator.locate(TypeDescription.ForLoadedType.getName(type)).resolve()));
                }
                this.apply(instrumentation, classDefinitions);
            }
        }
        ,
        RETRANSFORMATION(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException {
                ClassRedefinitionTransformer classRedefinitionTransformer = new ClassRedefinitionTransformer(classDefinitions);
                2 var4_4 = this;
                synchronized (var4_4) {
                    instrumentation.addTransformer(classRedefinitionTransformer, true);
                    try {
                        instrumentation.retransformClasses(classDefinitions.keySet().toArray(new Class[classDefinitions.size()]));
                    }
                    finally {
                        instrumentation.removeTransformer(classRedefinitionTransformer);
                    }
                }
                classRedefinitionTransformer.assertTransformation();
            }

            @Override
            protected Strategy validate(Instrumentation instrumentation) {
                if (!instrumentation.isRetransformClassesSupported()) {
                    throw new IllegalArgumentException("Does not support retransformation: " + instrumentation);
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reset(Instrumentation instrumentation, ClassFileLocator classFileLocator, List<Class<?>> types) throws IOException, UnmodifiableClassException, ClassNotFoundException {
                for (Class<?> type : types) {
                    if (instrumentation.isModifiableClass(type)) continue;
                    throw new IllegalArgumentException("Cannot modify type: " + type);
                }
                instrumentation.addTransformer(ClassResettingTransformer.INSTANCE, true);
                try {
                    instrumentation.retransformClasses(types.toArray(new Class[types.size()]));
                }
                finally {
                    instrumentation.removeTransformer(ClassResettingTransformer.INSTANCE);
                }
            }
        };

        private static final byte[] NO_REDEFINITION;
        private static final boolean REDEFINE_CLASSES = true;
        private final boolean redefinition;

        private Strategy(boolean redefinition) {
            this.redefinition = redefinition;
        }

        protected abstract void apply(Instrumentation var1, Map<Class<?>, ClassDefinition> var2) throws UnmodifiableClassException, ClassNotFoundException;

        protected abstract Strategy validate(Instrumentation var1);

        public boolean isRedefinition() {
            return this.redefinition;
        }

        public abstract void reset(Instrumentation var1, ClassFileLocator var2, List<Class<?>> var3) throws IOException, UnmodifiableClassException, ClassNotFoundException;

        static {
            NO_REDEFINITION = null;
        }

        protected static enum ClassResettingTransformer implements ClassFileTransformer
        {
            INSTANCE;


            @Override
            public byte[] transform(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                return NO_REDEFINITION;
            }
        }

        protected static class ClassRedefinitionTransformer
        implements ClassFileTransformer {
            private final Map<Class<?>, ClassDefinition> redefinedClasses;

            protected ClassRedefinitionTransformer(Map<Class<?>, ClassDefinition> redefinedClasses) {
                this.redefinedClasses = redefinedClasses;
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Value is always null")
            public byte[] transform(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                if (internalTypeName == null) {
                    return NO_REDEFINITION;
                }
                ClassDefinition redefinedClass = this.redefinedClasses.remove(classBeingRedefined);
                return redefinedClass == null ? NO_REDEFINITION : redefinedClass.getDefinitionClassFile();
            }

            public void assertTransformation() {
                if (!this.redefinedClasses.isEmpty()) {
                    throw new IllegalStateException("Could not transform: " + this.redefinedClasses.keySet());
                }
            }
        }
    }
}

