/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.instrumentation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opencensus.contrib.agent.Settings;
import io.opencensus.contrib.agent.bootstrap.ContextTrampoline;
import io.opencensus.contrib.agent.deps.bytebuddy.agent.builder.AgentBuilder;
import io.opencensus.contrib.agent.deps.bytebuddy.asm.Advice;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.DynamicType;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatchers;
import io.opencensus.contrib.agent.deps.bytebuddy.utility.JavaModule;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.instrumentation.Instrumenter;

public final class ThreadInstrumentation
implements Instrumenter {
    @Override
    public AgentBuilder instrument(AgentBuilder agentBuilder, Settings settings) {
        Preconditions.checkNotNull(agentBuilder, "agentBuilder");
        Preconditions.checkNotNull(settings, "settings");
        if (!settings.isEnabled("context-propagation.thread")) {
            return agentBuilder;
        }
        return agentBuilder.type(ElementMatchers.isSubTypeOf(Thread.class)).transform(new Transformer());
    }

    private static class Run {
        private Run() {
        }

        @Advice.OnMethodEnter
        @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
        private static void enter(@Advice.This Thread thread) {
            ContextTrampoline.attachContextForThread((Thread)thread);
        }
    }

    private static class Start {
        private Start() {
        }

        @Advice.OnMethodEnter
        @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
        private static void enter(@Advice.This Thread thread) {
            ContextTrampoline.saveContextForThread((Thread)thread);
        }
    }

    private static class Transformer
    implements AgentBuilder.Transformer {
        private Transformer() {
        }

        @Override
        public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            return builder.visit(Advice.to(Start.class).on(ElementMatchers.named("start"))).visit(Advice.to(Run.class).on(ElementMatchers.named("run")));
        }
    }
}

