/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.implementation.attribute;

import io.opencensus.contrib.agent.deps.bytebuddy.description.annotation.AnnotationDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.enumeration.EnumerationDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeList;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.attribute.AnnotationValueFilter;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.AnnotationVisitor;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.ClassVisitor;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.FieldVisitor;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.MethodVisitor;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.TypePath;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.TypeReference;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;

public interface AnnotationAppender {
    public static final String NO_NAME = null;

    public AnnotationAppender append(AnnotationDescription var1, AnnotationValueFilter var2);

    public AnnotationAppender append(AnnotationDescription var1, AnnotationValueFilter var2, int var3, String var4);

    public static class ForTypeAnnotations
    implements TypeDescription.Generic.Visitor<AnnotationAppender> {
        public static final boolean VARIABLE_ON_TYPE = true;
        public static final boolean VARIABLE_ON_INVOKEABLE = false;
        private static final String EMPTY_TYPE_PATH = "";
        private static final char COMPONENT_TYPE_PATH = '[';
        private static final char WILDCARD_TYPE_PATH = '*';
        private static final char INNER_CLASS_PATH = '.';
        private static final char INDEXED_TYPE_DELIMITER = ';';
        private static final int SUPER_CLASS_INDEX = -1;
        private final AnnotationAppender annotationAppender;
        private final AnnotationValueFilter annotationValueFilter;
        private final int typeReference;
        private final String typePath;

        protected ForTypeAnnotations(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, TypeReference typeReference) {
            this(annotationAppender, annotationValueFilter, typeReference.getValue(), EMPTY_TYPE_PATH);
        }

        protected ForTypeAnnotations(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, int typeReference, String typePath) {
            this.annotationAppender = annotationAppender;
            this.annotationValueFilter = annotationValueFilter;
            this.typeReference = typeReference;
            this.typePath = typePath;
        }

        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofSuperClass(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter) {
            return new ForTypeAnnotations(annotationAppender, annotationValueFilter, TypeReference.newSuperTypeReference(-1));
        }

        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofInterfaceType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, int index) {
            return new ForTypeAnnotations(annotationAppender, annotationValueFilter, TypeReference.newSuperTypeReference(index));
        }

        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofFieldType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter) {
            return new ForTypeAnnotations(annotationAppender, annotationValueFilter, TypeReference.newTypeReference(19));
        }

        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofMethodReturnType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter) {
            return new ForTypeAnnotations(annotationAppender, annotationValueFilter, TypeReference.newTypeReference(20));
        }

        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofMethodParameterType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, int index) {
            return new ForTypeAnnotations(annotationAppender, annotationValueFilter, TypeReference.newFormalParameterReference(index));
        }

        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofExceptionType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, int index) {
            return new ForTypeAnnotations(annotationAppender, annotationValueFilter, TypeReference.newExceptionReference(index));
        }

        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofReceiverType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter) {
            return new ForTypeAnnotations(annotationAppender, annotationValueFilter, TypeReference.newTypeReference(21));
        }

        public static AnnotationAppender ofTypeVariable(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, boolean variableOnType, List<? extends TypeDescription.Generic> typeVariables) {
            return ForTypeAnnotations.ofTypeVariable(annotationAppender, annotationValueFilter, variableOnType, 0, typeVariables);
        }

        public static AnnotationAppender ofTypeVariable(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, boolean variableOnType, int subListIndex, List<? extends TypeDescription.Generic> typeVariables) {
            int variableBoundBaseBase;
            int variableBaseReference;
            int typeVariableIndex = subListIndex;
            if (variableOnType) {
                variableBaseReference = 0;
                variableBoundBaseBase = 17;
            } else {
                variableBaseReference = 1;
                variableBoundBaseBase = 18;
            }
            for (TypeDescription.Generic generic : typeVariables.subList(subListIndex, typeVariables.size())) {
                int typeReference = TypeReference.newTypeParameterReference(variableBaseReference, typeVariableIndex).getValue();
                for (AnnotationDescription annotationDescription : generic.getDeclaredAnnotations()) {
                    annotationAppender = annotationAppender.append(annotationDescription, annotationValueFilter, typeReference, EMPTY_TYPE_PATH);
                }
                int boundIndex = !((TypeDescription.Generic)generic.getUpperBounds().get(0)).getSort().isTypeVariable() && ((TypeDescription.Generic)generic.getUpperBounds().get(0)).isInterface() ? 1 : 0;
                for (TypeDescription.Generic typeBound : generic.getUpperBounds()) {
                    annotationAppender = typeBound.accept(new ForTypeAnnotations(annotationAppender, annotationValueFilter, TypeReference.newTypeParameterBoundReference(variableBoundBaseBase, typeVariableIndex, boundIndex++)));
                }
                ++typeVariableIndex;
            }
            return annotationAppender;
        }

        @Override
        public AnnotationAppender onGenericArray(TypeDescription.Generic genericArray) {
            return genericArray.getComponentType().accept(new ForTypeAnnotations(this.apply(genericArray, this.typePath), this.annotationValueFilter, this.typeReference, this.typePath + '['));
        }

        @Override
        public AnnotationAppender onWildcard(TypeDescription.Generic wildcard) {
            TypeList.Generic lowerBounds = wildcard.getLowerBounds();
            return (lowerBounds.isEmpty() ? (TypeDescription.Generic)wildcard.getUpperBounds().getOnly() : (TypeDescription.Generic)lowerBounds.getOnly()).accept(new ForTypeAnnotations(this.apply(wildcard, this.typePath), this.annotationValueFilter, this.typeReference, this.typePath + '*'));
        }

        @Override
        public AnnotationAppender onParameterizedType(TypeDescription.Generic parameterizedType) {
            StringBuilder typePath = new StringBuilder(this.typePath);
            for (int index = 0; index < parameterizedType.asErasure().getSegmentCount(); ++index) {
                typePath = typePath.append('.');
            }
            AnnotationAppender annotationAppender = this.apply(parameterizedType, typePath.toString());
            TypeDescription.Generic ownerType = parameterizedType.getOwnerType();
            if (ownerType != null) {
                annotationAppender = ownerType.accept(new ForTypeAnnotations(annotationAppender, this.annotationValueFilter, this.typeReference, this.typePath));
            }
            int index = 0;
            for (TypeDescription.Generic typeArgument : parameterizedType.getTypeArguments()) {
                annotationAppender = typeArgument.accept(new ForTypeAnnotations(annotationAppender, this.annotationValueFilter, this.typeReference, typePath.toString() + index++ + ';'));
            }
            return annotationAppender;
        }

        @Override
        public AnnotationAppender onTypeVariable(TypeDescription.Generic typeVariable) {
            return this.apply(typeVariable, this.typePath);
        }

        @Override
        public AnnotationAppender onNonGenericType(TypeDescription.Generic typeDescription) {
            StringBuilder typePath = new StringBuilder(this.typePath);
            for (int index = 0; index < typeDescription.asErasure().getSegmentCount(); ++index) {
                typePath = typePath.append('.');
            }
            AnnotationAppender annotationAppender = this.apply(typeDescription, typePath.toString());
            if (typeDescription.isArray()) {
                annotationAppender = typeDescription.getComponentType().accept(new ForTypeAnnotations(annotationAppender, this.annotationValueFilter, this.typeReference, this.typePath + '['));
            }
            return annotationAppender;
        }

        private AnnotationAppender apply(TypeDescription.Generic typeDescription, String typePath) {
            AnnotationAppender annotationAppender = this.annotationAppender;
            for (AnnotationDescription annotationDescription : typeDescription.getDeclaredAnnotations()) {
                annotationAppender = annotationAppender.append(annotationDescription, this.annotationValueFilter, this.typeReference, typePath);
            }
            return annotationAppender;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForTypeAnnotations)) {
                return false;
            }
            ForTypeAnnotations other = (ForTypeAnnotations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AnnotationAppender this$annotationAppender = this.annotationAppender;
            AnnotationAppender other$annotationAppender = other.annotationAppender;
            if (this$annotationAppender == null ? other$annotationAppender != null : !this$annotationAppender.equals(other$annotationAppender)) {
                return false;
            }
            AnnotationValueFilter this$annotationValueFilter = this.annotationValueFilter;
            AnnotationValueFilter other$annotationValueFilter = other.annotationValueFilter;
            if (this$annotationValueFilter == null ? other$annotationValueFilter != null : !this$annotationValueFilter.equals(other$annotationValueFilter)) {
                return false;
            }
            if (this.typeReference != other.typeReference) {
                return false;
            }
            String this$typePath = this.typePath;
            String other$typePath = other.typePath;
            return !(this$typePath == null ? other$typePath != null : !this$typePath.equals(other$typePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForTypeAnnotations;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AnnotationAppender $annotationAppender = this.annotationAppender;
            result = result * 59 + ($annotationAppender == null ? 43 : $annotationAppender.hashCode());
            AnnotationValueFilter $annotationValueFilter = this.annotationValueFilter;
            result = result * 59 + ($annotationValueFilter == null ? 43 : $annotationValueFilter.hashCode());
            result = result * 59 + this.typeReference;
            String $typePath = this.typePath;
            result = result * 59 + ($typePath == null ? 43 : $typePath.hashCode());
            return result;
        }
    }

    public static class Default
    implements AnnotationAppender {
        private final Target target;

        public Default(Target target) {
            this.target = target;
        }

        private static void handle(AnnotationVisitor annotationVisitor, AnnotationDescription annotation, AnnotationValueFilter annotationValueFilter) {
            for (MethodDescription.InDefinedShape methodDescription : annotation.getAnnotationType().getDeclaredMethods()) {
                if (!annotationValueFilter.isRelevant(annotation, methodDescription)) continue;
                Default.apply(annotationVisitor, methodDescription.getReturnType().asErasure(), methodDescription.getName(), annotation.getValue(methodDescription).resolve());
            }
            annotationVisitor.visitEnd();
        }

        public static void apply(AnnotationVisitor annotationVisitor, TypeDescription valueType, String name, Object value) {
            if (valueType.isArray()) {
                AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                int length = Array.getLength(value);
                TypeDescription componentType = valueType.getComponentType();
                for (int index = 0; index < length; ++index) {
                    Default.apply(arrayVisitor, componentType, NO_NAME, Array.get(value, index));
                }
                arrayVisitor.visitEnd();
            } else if (valueType.isAnnotation()) {
                Default.handle(annotationVisitor.visitAnnotation(name, valueType.getDescriptor()), (AnnotationDescription)value, AnnotationValueFilter.Default.APPEND_DEFAULTS);
            } else if (valueType.isEnum()) {
                annotationVisitor.visitEnum(name, valueType.getDescriptor(), ((EnumerationDescription)value).getValue());
            } else if (valueType.represents((Type)((Object)Class.class))) {
                annotationVisitor.visit(name, io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.Type.getType(((TypeDescription)value).getDescriptor()));
            } else {
                annotationVisitor.visit(name, value);
            }
        }

        @Override
        public AnnotationAppender append(AnnotationDescription annotationDescription, AnnotationValueFilter annotationValueFilter) {
            switch (annotationDescription.getRetention()) {
                case RUNTIME: {
                    this.doAppend(annotationDescription, true, annotationValueFilter);
                    break;
                }
                case CLASS: {
                    this.doAppend(annotationDescription, false, annotationValueFilter);
                    break;
                }
                case SOURCE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected retention policy: " + (Object)((Object)annotationDescription.getRetention()));
                }
            }
            return this;
        }

        private void doAppend(AnnotationDescription annotation, boolean visible, AnnotationValueFilter annotationValueFilter) {
            Default.handle(this.target.visit(annotation.getAnnotationType().getDescriptor(), visible), annotation, annotationValueFilter);
        }

        @Override
        public AnnotationAppender append(AnnotationDescription annotationDescription, AnnotationValueFilter annotationValueFilter, int typeReference, String typePath) {
            switch (annotationDescription.getRetention()) {
                case RUNTIME: {
                    this.doAppend(annotationDescription, true, annotationValueFilter, typeReference, typePath);
                    break;
                }
                case CLASS: {
                    this.doAppend(annotationDescription, false, annotationValueFilter, typeReference, typePath);
                    break;
                }
                case SOURCE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected retention policy: " + (Object)((Object)annotationDescription.getRetention()));
                }
            }
            return this;
        }

        private void doAppend(AnnotationDescription annotation, boolean visible, AnnotationValueFilter annotationValueFilter, int typeReference, String typePath) {
            Default.handle(this.target.visit(annotation.getAnnotationType().getDescriptor(), visible, typeReference, typePath), annotation, annotationValueFilter);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Default)) {
                return false;
            }
            Default other = (Default)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Target this$target = this.target;
            Target other$target = other.target;
            return !(this$target == null ? other$target != null : !this$target.equals(other$target));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Default;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Target $target = this.target;
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            return result;
        }
    }

    public static interface Target {
        public AnnotationVisitor visit(String var1, boolean var2);

        public AnnotationVisitor visit(String var1, boolean var2, int var3, String var4);

        public static class OnField
        implements Target {
            private final FieldVisitor fieldVisitor;

            public OnField(FieldVisitor fieldVisitor) {
                this.fieldVisitor = fieldVisitor;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.fieldVisitor.visitAnnotation(annotationTypeDescriptor, visible);
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible, int typeReference, String typePath) {
                return this.fieldVisitor.visitTypeAnnotation(typeReference, TypePath.fromString(typePath), annotationTypeDescriptor, visible);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OnField)) {
                    return false;
                }
                OnField other = (OnField)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FieldVisitor this$fieldVisitor = this.fieldVisitor;
                FieldVisitor other$fieldVisitor = other.fieldVisitor;
                return !(this$fieldVisitor == null ? other$fieldVisitor != null : !this$fieldVisitor.equals(other$fieldVisitor));
            }

            protected boolean canEqual(Object other) {
                return other instanceof OnField;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FieldVisitor $fieldVisitor = this.fieldVisitor;
                result = result * 59 + ($fieldVisitor == null ? 43 : $fieldVisitor.hashCode());
                return result;
            }
        }

        public static class OnMethodParameter
        implements Target {
            private final MethodVisitor methodVisitor;
            private final int parameterIndex;

            public OnMethodParameter(MethodVisitor methodVisitor, int parameterIndex) {
                this.methodVisitor = methodVisitor;
                this.parameterIndex = parameterIndex;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.methodVisitor.visitParameterAnnotation(this.parameterIndex, annotationTypeDescriptor, visible);
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible, int typeReference, String typePath) {
                return this.methodVisitor.visitTypeAnnotation(typeReference, TypePath.fromString(typePath), annotationTypeDescriptor, visible);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OnMethodParameter)) {
                    return false;
                }
                OnMethodParameter other = (OnMethodParameter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodVisitor this$methodVisitor = this.methodVisitor;
                MethodVisitor other$methodVisitor = other.methodVisitor;
                if (this$methodVisitor == null ? other$methodVisitor != null : !this$methodVisitor.equals(other$methodVisitor)) {
                    return false;
                }
                return this.parameterIndex == other.parameterIndex;
            }

            protected boolean canEqual(Object other) {
                return other instanceof OnMethodParameter;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodVisitor $methodVisitor = this.methodVisitor;
                result = result * 59 + ($methodVisitor == null ? 43 : $methodVisitor.hashCode());
                result = result * 59 + this.parameterIndex;
                return result;
            }
        }

        public static class OnMethod
        implements Target {
            private final MethodVisitor methodVisitor;

            public OnMethod(MethodVisitor methodVisitor) {
                this.methodVisitor = methodVisitor;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.methodVisitor.visitAnnotation(annotationTypeDescriptor, visible);
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible, int typeReference, String typePath) {
                return this.methodVisitor.visitTypeAnnotation(typeReference, TypePath.fromString(typePath), annotationTypeDescriptor, visible);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OnMethod)) {
                    return false;
                }
                OnMethod other = (OnMethod)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodVisitor this$methodVisitor = this.methodVisitor;
                MethodVisitor other$methodVisitor = other.methodVisitor;
                return !(this$methodVisitor == null ? other$methodVisitor != null : !this$methodVisitor.equals(other$methodVisitor));
            }

            protected boolean canEqual(Object other) {
                return other instanceof OnMethod;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodVisitor $methodVisitor = this.methodVisitor;
                result = result * 59 + ($methodVisitor == null ? 43 : $methodVisitor.hashCode());
                return result;
            }
        }

        public static class OnType
        implements Target {
            private final ClassVisitor classVisitor;

            public OnType(ClassVisitor classVisitor) {
                this.classVisitor = classVisitor;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.classVisitor.visitAnnotation(annotationTypeDescriptor, visible);
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible, int typeReference, String typePath) {
                return this.classVisitor.visitTypeAnnotation(typeReference, TypePath.fromString(typePath), annotationTypeDescriptor, visible);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OnType)) {
                    return false;
                }
                OnType other = (OnType)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ClassVisitor this$classVisitor = this.classVisitor;
                ClassVisitor other$classVisitor = other.classVisitor;
                return !(this$classVisitor == null ? other$classVisitor != null : !this$classVisitor.equals(other$classVisitor));
            }

            protected boolean canEqual(Object other) {
                return other instanceof OnType;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ClassVisitor $classVisitor = this.classVisitor;
                result = result * 59 + ($classVisitor == null ? 43 : $classVisitor.hashCode());
                return result;
            }
        }
    }
}

