/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold;

import io.opencensus.contrib.agent.deps.bytebuddy.ClassFileVersion;
import io.opencensus.contrib.agent.deps.bytebuddy.description.annotation.AnnotationValue;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodList;
import io.opencensus.contrib.agent.deps.bytebuddy.description.modifier.Visibility;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.Transformer;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.InstrumentedType;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.MethodGraph;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.TypeInitializer;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.TypeValidation;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.TypeWriter;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.Implementation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.LoadedTypeInitializer;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.attribute.MethodAttributeAppender;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.ByteCodeAppender;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatcher;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatchers;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.LatentMatcher;
import io.opencensus.contrib.agent.deps.bytebuddy.utility.CompoundList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface MethodRegistry {
    public MethodRegistry prepend(LatentMatcher<? super MethodDescription> var1, Handler var2, MethodAttributeAppender.Factory var3, Transformer<MethodDescription> var4);

    public MethodRegistry append(LatentMatcher<? super MethodDescription> var1, Handler var2, MethodAttributeAppender.Factory var3, Transformer<MethodDescription> var4);

    public Prepared prepare(InstrumentedType var1, MethodGraph.Compiler var2, TypeValidation var3, LatentMatcher<? super MethodDescription> var4);

    public static class Default
    implements MethodRegistry {
        private final List<Entry> entries;

        public Default() {
            this.entries = Collections.emptyList();
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public MethodRegistry prepend(LatentMatcher<? super MethodDescription> matcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, Transformer<MethodDescription> transformer) {
            return new Default(CompoundList.of(new Entry(matcher, handler, attributeAppenderFactory, transformer), this.entries));
        }

        @Override
        public MethodRegistry append(LatentMatcher<? super MethodDescription> matcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, Transformer<MethodDescription> transformer) {
            return new Default(CompoundList.of(this.entries, new Entry(matcher, handler, attributeAppenderFactory, transformer)));
        }

        @Override
        public io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared prepare(InstrumentedType instrumentedType, MethodGraph.Compiler methodGraphCompiler, TypeValidation typeValidation, LatentMatcher<? super MethodDescription> ignoredMethods) {
            LinkedHashMap<MethodDescription, Prepared.Entry> implementations = new LinkedHashMap<MethodDescription, Prepared.Entry>();
            HashSet<Handler> handlers = new HashSet<Handler>();
            MethodList<MethodDescription.InDefinedShape> helperMethods = instrumentedType.getDeclaredMethods();
            for (Entry entry : this.entries) {
                if (!handlers.add(entry.getHandler())) continue;
                instrumentedType = entry.getHandler().prepare(instrumentedType);
                ElementMatcher.Junction handledMethods = ElementMatchers.noneOf(helperMethods);
                helperMethods = instrumentedType.getDeclaredMethods();
                for (MethodDescription methodDescription : (MethodList)helperMethods.filter(handledMethods)) {
                    implementations.put(methodDescription, entry.asSupplementaryEntry(methodDescription));
                }
            }
            MethodGraph.Linked methodGraph = methodGraphCompiler.compile(instrumentedType);
            ElementMatcher.Junction<? super MethodDescription> relevanceMatcher = ElementMatchers.not(ElementMatchers.anyOf(implementations.keySet())).and(ElementMatchers.returns(ElementMatchers.isVisibleTo(instrumentedType))).and(ElementMatchers.hasParameters(ElementMatchers.whereNone(ElementMatchers.hasType(ElementMatchers.not(ElementMatchers.isVisibleTo(instrumentedType)))))).and(ignoredMethods.resolve(instrumentedType));
            ArrayList<MethodDescription> methods = new ArrayList<MethodDescription>();
            for (MethodGraph.Node node : methodGraph.listNodes()) {
                boolean visibilityBridge;
                MethodDescription methodDescription = node.getRepresentative();
                boolean bl = visibilityBridge = instrumentedType.isPublic() && !instrumentedType.isInterface();
                if (relevanceMatcher.matches(methodDescription)) {
                    for (Entry entry : this.entries) {
                        if (!entry.resolve(instrumentedType).matches(methodDescription)) continue;
                        implementations.put(methodDescription, entry.asPreparedEntry(instrumentedType, methodDescription, node.getMethodTypes(), node.getVisibility()));
                        visibilityBridge = false;
                        break;
                    }
                }
                if (visibilityBridge && !node.getSort().isMadeVisible() && methodDescription.isPublic() && !methodDescription.isAbstract() && !methodDescription.isFinal() && methodDescription.getDeclaringType().isPackagePrivate()) {
                    implementations.put(methodDescription, Prepared.Entry.forVisibilityBridge(methodDescription, node.getVisibility()));
                }
                methods.add(methodDescription);
            }
            for (MethodDescription methodDescription : CompoundList.of(instrumentedType.getDeclaredMethods().filter(ElementMatchers.not(ElementMatchers.isVirtual()).and(relevanceMatcher)), new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
                for (Entry entry : this.entries) {
                    if (!entry.resolve(instrumentedType).matches(methodDescription)) continue;
                    implementations.put(methodDescription, entry.asPreparedEntry(instrumentedType, methodDescription, methodDescription.getVisibility()));
                    break;
                }
                methods.add(methodDescription);
            }
            return new Prepared(implementations, instrumentedType.getLoadedTypeInitializer(), instrumentedType.getTypeInitializer(), typeValidation.isEnabled() ? instrumentedType.validated() : instrumentedType, methodGraph, new MethodList.Explicit(methods));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Default)) {
                return false;
            }
            Default other = (Default)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Entry> this$entries = this.entries;
            List<Entry> other$entries = other.entries;
            return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Default;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Entry> $entries = this.entries;
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            return result;
        }

        protected static class Compiled
        implements io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled {
            private final TypeDescription instrumentedType;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final TypeInitializer typeInitializer;
            private final MethodList<?> methods;
            private final LinkedHashMap<MethodDescription, Entry> implementations;
            private final boolean supportsBridges;

            protected Compiled(TypeDescription instrumentedType, LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, MethodList<?> methods, LinkedHashMap<MethodDescription, Entry> implementations, boolean supportsBridges) {
                this.instrumentedType = instrumentedType;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.methods = methods;
                this.implementations = implementations;
                this.supportsBridges = supportsBridges;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            @Override
            public MethodList<?> getMethods() {
                return this.methods;
            }

            @Override
            public MethodList<?> getInstrumentedMethods() {
                return (MethodList)new MethodList.Explicit<MethodDescription>((List<MethodDescription>)new ArrayList<MethodDescription>(this.implementations.keySet())).filter(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
            }

            @Override
            public TypeWriter.MethodPool.Record target(MethodDescription methodDescription) {
                Entry entry = this.implementations.get(methodDescription);
                return entry == null ? new TypeWriter.MethodPool.Record.ForNonImplementedMethod(methodDescription) : entry.bind(this.instrumentedType, this.supportsBridges);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Compiled)) {
                    return false;
                }
                Compiled other = (Compiled)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$instrumentedType = this.getInstrumentedType();
                TypeDescription other$instrumentedType = other.getInstrumentedType();
                if (this$instrumentedType == null ? other$instrumentedType != null : !this$instrumentedType.equals(other$instrumentedType)) {
                    return false;
                }
                LoadedTypeInitializer this$loadedTypeInitializer = this.getLoadedTypeInitializer();
                LoadedTypeInitializer other$loadedTypeInitializer = other.getLoadedTypeInitializer();
                if (this$loadedTypeInitializer == null ? other$loadedTypeInitializer != null : !this$loadedTypeInitializer.equals(other$loadedTypeInitializer)) {
                    return false;
                }
                TypeInitializer this$typeInitializer = this.getTypeInitializer();
                TypeInitializer other$typeInitializer = other.getTypeInitializer();
                if (this$typeInitializer == null ? other$typeInitializer != null : !this$typeInitializer.equals(other$typeInitializer)) {
                    return false;
                }
                MethodList<?> this$methods = this.getMethods();
                MethodList<?> other$methods = other.getMethods();
                if (this$methods == null ? other$methods != null : !this$methods.equals(other$methods)) {
                    return false;
                }
                LinkedHashMap<MethodDescription, Entry> this$implementations = this.implementations;
                LinkedHashMap<MethodDescription, Entry> other$implementations = other.implementations;
                if (this$implementations == null ? other$implementations != null : !((Object)this$implementations).equals(other$implementations)) {
                    return false;
                }
                return this.supportsBridges == other.supportsBridges;
            }

            protected boolean canEqual(Object other) {
                return other instanceof Compiled;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $instrumentedType = this.getInstrumentedType();
                result = result * 59 + ($instrumentedType == null ? 43 : $instrumentedType.hashCode());
                LoadedTypeInitializer $loadedTypeInitializer = this.getLoadedTypeInitializer();
                result = result * 59 + ($loadedTypeInitializer == null ? 43 : $loadedTypeInitializer.hashCode());
                TypeInitializer $typeInitializer = this.getTypeInitializer();
                result = result * 59 + ($typeInitializer == null ? 43 : $typeInitializer.hashCode());
                MethodList<?> $methods = this.getMethods();
                result = result * 59 + ($methods == null ? 43 : $methods.hashCode());
                LinkedHashMap<MethodDescription, Entry> $implementations = this.implementations;
                result = result * 59 + ($implementations == null ? 43 : ((Object)$implementations).hashCode());
                result = result * 59 + (this.supportsBridges ? 79 : 97);
                return result;
            }

            protected static class Entry {
                private final Handler.Compiled handler;
                private final MethodAttributeAppender attributeAppender;
                private final MethodDescription methodDescription;
                private final Set<MethodDescription.TypeToken> bridgeTypes;
                private final Visibility visibility;
                private final boolean bridgeMethod;

                protected Entry(Handler.Compiled handler, MethodAttributeAppender attributeAppender, MethodDescription methodDescription, Set<MethodDescription.TypeToken> bridgeTypes, Visibility visibility, boolean bridgeMethod) {
                    this.handler = handler;
                    this.attributeAppender = attributeAppender;
                    this.methodDescription = methodDescription;
                    this.bridgeTypes = bridgeTypes;
                    this.visibility = visibility;
                    this.bridgeMethod = bridgeMethod;
                }

                protected TypeWriter.MethodPool.Record bind(TypeDescription instrumentedType, boolean supportsBridges) {
                    if (this.bridgeMethod && !supportsBridges) {
                        return new TypeWriter.MethodPool.Record.ForNonImplementedMethod(this.methodDescription);
                    }
                    TypeWriter.MethodPool.Record record = this.handler.assemble(this.methodDescription, this.attributeAppender, this.visibility);
                    return supportsBridges ? TypeWriter.MethodPool.Record.AccessBridgeWrapper.of(record, instrumentedType, this.methodDescription, this.bridgeTypes, this.attributeAppender) : record;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry other = (Entry)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Handler.Compiled this$handler = this.handler;
                    Handler.Compiled other$handler = other.handler;
                    if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
                        return false;
                    }
                    MethodAttributeAppender this$attributeAppender = this.attributeAppender;
                    MethodAttributeAppender other$attributeAppender = other.attributeAppender;
                    if (this$attributeAppender == null ? other$attributeAppender != null : !this$attributeAppender.equals(other$attributeAppender)) {
                        return false;
                    }
                    MethodDescription this$methodDescription = this.methodDescription;
                    MethodDescription other$methodDescription = other.methodDescription;
                    if (this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription)) {
                        return false;
                    }
                    Set<MethodDescription.TypeToken> this$bridgeTypes = this.bridgeTypes;
                    Set<MethodDescription.TypeToken> other$bridgeTypes = other.bridgeTypes;
                    if (this$bridgeTypes == null ? other$bridgeTypes != null : !((Object)this$bridgeTypes).equals(other$bridgeTypes)) {
                        return false;
                    }
                    Visibility this$visibility = this.visibility;
                    Visibility other$visibility = other.visibility;
                    if (this$visibility == null ? other$visibility != null : !this$visibility.equals(other$visibility)) {
                        return false;
                    }
                    return this.bridgeMethod == other.bridgeMethod;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Entry;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Handler.Compiled $handler = this.handler;
                    result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
                    MethodAttributeAppender $attributeAppender = this.attributeAppender;
                    result = result * 59 + ($attributeAppender == null ? 43 : $attributeAppender.hashCode());
                    MethodDescription $methodDescription = this.methodDescription;
                    result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
                    Set<MethodDescription.TypeToken> $bridgeTypes = this.bridgeTypes;
                    result = result * 59 + ($bridgeTypes == null ? 43 : ((Object)$bridgeTypes).hashCode());
                    Visibility $visibility = this.visibility;
                    result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
                    result = result * 59 + (this.bridgeMethod ? 79 : 97);
                    return result;
                }
            }
        }

        protected static class Prepared
        implements io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared {
            private final LinkedHashMap<MethodDescription, Entry> implementations;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final TypeInitializer typeInitializer;
            private final TypeDescription instrumentedType;
            private final MethodGraph.Linked methodGraph;
            private final MethodList<?> methods;

            protected Prepared(LinkedHashMap<MethodDescription, Entry> implementations, LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, TypeDescription instrumentedType, MethodGraph.Linked methodGraph, MethodList<?> methods) {
                this.implementations = implementations;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.instrumentedType = instrumentedType;
                this.methodGraph = methodGraph;
                this.methods = methods;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            @Override
            public MethodList<?> getMethods() {
                return this.methods;
            }

            @Override
            public MethodList<?> getInstrumentedMethods() {
                return (MethodList)new MethodList.Explicit<MethodDescription>((List<MethodDescription>)new ArrayList<MethodDescription>(this.implementations.keySet())).filter(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
            }

            @Override
            public io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled compile(Implementation.Target.Factory implementationTargetFactory, ClassFileVersion classFileVersion) {
                HashMap<Handler, Handler.Compiled> compilationCache = new HashMap<Handler, Handler.Compiled>();
                HashMap<MethodAttributeAppender.Factory, MethodAttributeAppender> attributeAppenderCache = new HashMap<MethodAttributeAppender.Factory, MethodAttributeAppender>();
                LinkedHashMap<MethodDescription, Compiled.Entry> entries = new LinkedHashMap<MethodDescription, Compiled.Entry>();
                Implementation.Target implementationTarget = implementationTargetFactory.make(this.instrumentedType, this.methodGraph, classFileVersion);
                for (Map.Entry<MethodDescription, Entry> entry : this.implementations.entrySet()) {
                    MethodAttributeAppender cachedAttributeAppender;
                    Handler.Compiled cachedHandler = (Handler.Compiled)compilationCache.get(entry.getValue().getHandler());
                    if (cachedHandler == null) {
                        cachedHandler = entry.getValue().getHandler().compile(implementationTarget);
                        compilationCache.put(entry.getValue().getHandler(), cachedHandler);
                    }
                    if ((cachedAttributeAppender = (MethodAttributeAppender)attributeAppenderCache.get(entry.getValue().getAppenderFactory())) == null) {
                        cachedAttributeAppender = entry.getValue().getAppenderFactory().make(this.instrumentedType);
                        attributeAppenderCache.put(entry.getValue().getAppenderFactory(), cachedAttributeAppender);
                    }
                    entries.put(entry.getKey(), new Compiled.Entry(cachedHandler, cachedAttributeAppender, entry.getValue().getMethodDescription(), entry.getValue().resolveBridgeTypes(), entry.getValue().getVisibility(), entry.getValue().isBridgeMethod()));
                }
                return new Compiled(this.instrumentedType, this.loadedTypeInitializer, this.typeInitializer, this.methods, entries, classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Prepared)) {
                    return false;
                }
                Prepared other = (Prepared)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                LinkedHashMap<MethodDescription, Entry> this$implementations = this.implementations;
                LinkedHashMap<MethodDescription, Entry> other$implementations = other.implementations;
                if (this$implementations == null ? other$implementations != null : !((Object)this$implementations).equals(other$implementations)) {
                    return false;
                }
                LoadedTypeInitializer this$loadedTypeInitializer = this.getLoadedTypeInitializer();
                LoadedTypeInitializer other$loadedTypeInitializer = other.getLoadedTypeInitializer();
                if (this$loadedTypeInitializer == null ? other$loadedTypeInitializer != null : !this$loadedTypeInitializer.equals(other$loadedTypeInitializer)) {
                    return false;
                }
                TypeInitializer this$typeInitializer = this.getTypeInitializer();
                TypeInitializer other$typeInitializer = other.getTypeInitializer();
                if (this$typeInitializer == null ? other$typeInitializer != null : !this$typeInitializer.equals(other$typeInitializer)) {
                    return false;
                }
                TypeDescription this$instrumentedType = this.getInstrumentedType();
                TypeDescription other$instrumentedType = other.getInstrumentedType();
                if (this$instrumentedType == null ? other$instrumentedType != null : !this$instrumentedType.equals(other$instrumentedType)) {
                    return false;
                }
                MethodGraph.Linked this$methodGraph = this.methodGraph;
                MethodGraph.Linked other$methodGraph = other.methodGraph;
                if (this$methodGraph == null ? other$methodGraph != null : !this$methodGraph.equals(other$methodGraph)) {
                    return false;
                }
                MethodList<?> this$methods = this.getMethods();
                MethodList<?> other$methods = other.getMethods();
                return !(this$methods == null ? other$methods != null : !this$methods.equals(other$methods));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Prepared;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                LinkedHashMap<MethodDescription, Entry> $implementations = this.implementations;
                result = result * 59 + ($implementations == null ? 43 : ((Object)$implementations).hashCode());
                LoadedTypeInitializer $loadedTypeInitializer = this.getLoadedTypeInitializer();
                result = result * 59 + ($loadedTypeInitializer == null ? 43 : $loadedTypeInitializer.hashCode());
                TypeInitializer $typeInitializer = this.getTypeInitializer();
                result = result * 59 + ($typeInitializer == null ? 43 : $typeInitializer.hashCode());
                TypeDescription $instrumentedType = this.getInstrumentedType();
                result = result * 59 + ($instrumentedType == null ? 43 : $instrumentedType.hashCode());
                MethodGraph.Linked $methodGraph = this.methodGraph;
                result = result * 59 + ($methodGraph == null ? 43 : $methodGraph.hashCode());
                MethodList<?> $methods = this.getMethods();
                result = result * 59 + ($methods == null ? 43 : $methods.hashCode());
                return result;
            }

            protected static class Entry {
                private final Handler handler;
                private final MethodAttributeAppender.Factory attributeAppenderFactory;
                private final MethodDescription methodDescription;
                private final Set<MethodDescription.TypeToken> typeTokens;
                private Visibility visibility;
                private final boolean bridgeMethod;

                protected Entry(Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, MethodDescription methodDescription, Set<MethodDescription.TypeToken> typeTokens, Visibility visibility, boolean bridgeMethod) {
                    this.handler = handler;
                    this.attributeAppenderFactory = attributeAppenderFactory;
                    this.methodDescription = methodDescription;
                    this.typeTokens = typeTokens;
                    this.visibility = visibility;
                    this.bridgeMethod = bridgeMethod;
                }

                protected static Entry forVisibilityBridge(MethodDescription bridgeTarget, Visibility visibility) {
                    return new Entry(Handler.ForVisibilityBridge.INSTANCE, MethodAttributeAppender.Explicit.of(bridgeTarget), bridgeTarget, Collections.<MethodDescription.TypeToken>emptySet(), visibility, true);
                }

                protected Handler getHandler() {
                    return this.handler;
                }

                protected MethodAttributeAppender.Factory getAppenderFactory() {
                    return this.attributeAppenderFactory;
                }

                protected MethodDescription getMethodDescription() {
                    return this.methodDescription;
                }

                protected Set<MethodDescription.TypeToken> resolveBridgeTypes() {
                    HashSet<MethodDescription.TypeToken> typeTokens = new HashSet<MethodDescription.TypeToken>(this.typeTokens);
                    typeTokens.remove(this.methodDescription.asTypeToken());
                    return typeTokens;
                }

                protected Visibility getVisibility() {
                    return this.visibility;
                }

                protected boolean isBridgeMethod() {
                    return this.bridgeMethod;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry other = (Entry)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Handler this$handler = this.getHandler();
                    Handler other$handler = other.getHandler();
                    if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
                        return false;
                    }
                    MethodAttributeAppender.Factory this$attributeAppenderFactory = this.attributeAppenderFactory;
                    MethodAttributeAppender.Factory other$attributeAppenderFactory = other.attributeAppenderFactory;
                    if (this$attributeAppenderFactory == null ? other$attributeAppenderFactory != null : !this$attributeAppenderFactory.equals(other$attributeAppenderFactory)) {
                        return false;
                    }
                    MethodDescription this$methodDescription = this.getMethodDescription();
                    MethodDescription other$methodDescription = other.getMethodDescription();
                    if (this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription)) {
                        return false;
                    }
                    Set<MethodDescription.TypeToken> this$typeTokens = this.typeTokens;
                    Set<MethodDescription.TypeToken> other$typeTokens = other.typeTokens;
                    if (this$typeTokens == null ? other$typeTokens != null : !((Object)this$typeTokens).equals(other$typeTokens)) {
                        return false;
                    }
                    Visibility this$visibility = this.getVisibility();
                    Visibility other$visibility = other.getVisibility();
                    if (this$visibility == null ? other$visibility != null : !this$visibility.equals(other$visibility)) {
                        return false;
                    }
                    return this.isBridgeMethod() == other.isBridgeMethod();
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Entry;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Handler $handler = this.getHandler();
                    result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
                    MethodAttributeAppender.Factory $attributeAppenderFactory = this.attributeAppenderFactory;
                    result = result * 59 + ($attributeAppenderFactory == null ? 43 : $attributeAppenderFactory.hashCode());
                    MethodDescription $methodDescription = this.getMethodDescription();
                    result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
                    Set<MethodDescription.TypeToken> $typeTokens = this.typeTokens;
                    result = result * 59 + ($typeTokens == null ? 43 : ((Object)$typeTokens).hashCode());
                    Visibility $visibility = this.getVisibility();
                    result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
                    result = result * 59 + (this.isBridgeMethod() ? 79 : 97);
                    return result;
                }
            }
        }

        protected static class Entry
        implements LatentMatcher<MethodDescription> {
            private final LatentMatcher<? super MethodDescription> matcher;
            private final Handler handler;
            private final MethodAttributeAppender.Factory attributeAppenderFactory;
            private final Transformer<MethodDescription> transformer;

            protected Entry(LatentMatcher<? super MethodDescription> matcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, Transformer<MethodDescription> transformer) {
                this.matcher = matcher;
                this.handler = handler;
                this.attributeAppenderFactory = attributeAppenderFactory;
                this.transformer = transformer;
            }

            protected Prepared.Entry asPreparedEntry(TypeDescription instrumentedType, MethodDescription methodDescription, Visibility visibility) {
                return this.asPreparedEntry(instrumentedType, methodDescription, Collections.<MethodDescription.TypeToken>emptySet(), visibility);
            }

            protected Prepared.Entry asPreparedEntry(TypeDescription instrumentedType, MethodDescription methodDescription, Set<MethodDescription.TypeToken> methodTypes, Visibility visibility) {
                return new Prepared.Entry(this.handler, this.attributeAppenderFactory, this.transformer.transform(instrumentedType, methodDescription), methodTypes, visibility, false);
            }

            protected Prepared.Entry asSupplementaryEntry(MethodDescription methodDescription) {
                return new Prepared.Entry(this.handler, MethodAttributeAppender.Explicit.of(methodDescription), methodDescription, Collections.<MethodDescription.TypeToken>emptySet(), methodDescription.getVisibility(), false);
            }

            protected Handler getHandler() {
                return this.handler;
            }

            @Override
            public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
                return this.matcher.resolve(typeDescription);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                LatentMatcher<? super MethodDescription> this$matcher = this.matcher;
                LatentMatcher<? super MethodDescription> other$matcher = other.matcher;
                if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
                    return false;
                }
                Handler this$handler = this.getHandler();
                Handler other$handler = other.getHandler();
                if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
                    return false;
                }
                MethodAttributeAppender.Factory this$attributeAppenderFactory = this.attributeAppenderFactory;
                MethodAttributeAppender.Factory other$attributeAppenderFactory = other.attributeAppenderFactory;
                if (this$attributeAppenderFactory == null ? other$attributeAppenderFactory != null : !this$attributeAppenderFactory.equals(other$attributeAppenderFactory)) {
                    return false;
                }
                Transformer<MethodDescription> this$transformer = this.transformer;
                Transformer<MethodDescription> other$transformer = other.transformer;
                return !(this$transformer == null ? other$transformer != null : !this$transformer.equals(other$transformer));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                LatentMatcher<? super MethodDescription> $matcher = this.matcher;
                result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
                Handler $handler = this.getHandler();
                result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
                MethodAttributeAppender.Factory $attributeAppenderFactory = this.attributeAppenderFactory;
                result = result * 59 + ($attributeAppenderFactory == null ? 43 : $attributeAppenderFactory.hashCode());
                Transformer<MethodDescription> $transformer = this.transformer;
                result = result * 59 + ($transformer == null ? 43 : $transformer.hashCode());
                return result;
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.MethodPool {
        public TypeDescription getInstrumentedType();

        public MethodList<?> getMethods();

        public MethodList<?> getInstrumentedMethods();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public TypeInitializer getTypeInitializer();
    }

    public static interface Prepared {
        public TypeDescription getInstrumentedType();

        public MethodList<?> getMethods();

        public MethodList<?> getInstrumentedMethods();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public TypeInitializer getTypeInitializer();

        public Compiled compile(Implementation.Target.Factory var1, ClassFileVersion var2);
    }

    public static interface Handler
    extends InstrumentedType.Prepareable {
        public Compiled compile(Implementation.Target var1);

        public static class ForAnnotationValue
        implements Handler,
        Compiled {
            private final AnnotationValue<?, ?> annotationValue;

            public ForAnnotationValue(AnnotationValue<?, ?> annotationValue) {
                this.annotationValue = annotationValue;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender, Visibility visibility) {
                return new TypeWriter.MethodPool.Record.ForDefinedMethod.WithAnnotationDefaultValue(methodDescription, this.annotationValue, attributeAppender);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForAnnotationValue)) {
                    return false;
                }
                ForAnnotationValue other = (ForAnnotationValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                AnnotationValue<?, ?> this$annotationValue = this.annotationValue;
                AnnotationValue<?, ?> other$annotationValue = other.annotationValue;
                return !(this$annotationValue == null ? other$annotationValue != null : !this$annotationValue.equals(other$annotationValue));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForAnnotationValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                AnnotationValue<?, ?> $annotationValue = this.annotationValue;
                result = result * 59 + ($annotationValue == null ? 43 : $annotationValue.hashCode());
                return result;
            }
        }

        public static class ForImplementation
        implements Handler {
            private final Implementation implementation;

            public ForImplementation(Implementation implementation) {
                this.implementation = implementation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return this.implementation.prepare(instrumentedType);
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return new Compiled(this.implementation.appender(implementationTarget));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForImplementation)) {
                    return false;
                }
                ForImplementation other = (ForImplementation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Implementation this$implementation = this.implementation;
                Implementation other$implementation = other.implementation;
                return !(this$implementation == null ? other$implementation != null : !this$implementation.equals(other$implementation));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForImplementation;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Implementation $implementation = this.implementation;
                result = result * 59 + ($implementation == null ? 43 : $implementation.hashCode());
                return result;
            }

            protected static class Compiled
            implements io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.MethodRegistry$Handler$Compiled {
                private final ByteCodeAppender byteCodeAppender;

                protected Compiled(ByteCodeAppender byteCodeAppender) {
                    this.byteCodeAppender = byteCodeAppender;
                }

                @Override
                public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender, Visibility visibility) {
                    return new TypeWriter.MethodPool.Record.ForDefinedMethod.WithBody(methodDescription, this.byteCodeAppender, attributeAppender, visibility);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Compiled)) {
                        return false;
                    }
                    Compiled other = (Compiled)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    ByteCodeAppender this$byteCodeAppender = this.byteCodeAppender;
                    ByteCodeAppender other$byteCodeAppender = other.byteCodeAppender;
                    return !(this$byteCodeAppender == null ? other$byteCodeAppender != null : !this$byteCodeAppender.equals(other$byteCodeAppender));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Compiled;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    ByteCodeAppender $byteCodeAppender = this.byteCodeAppender;
                    result = result * 59 + ($byteCodeAppender == null ? 43 : $byteCodeAppender.hashCode());
                    return result;
                }
            }
        }

        public static interface Compiled {
            public TypeWriter.MethodPool.Record assemble(MethodDescription var1, MethodAttributeAppender var2, Visibility var3);
        }

        public static enum ForVisibilityBridge implements Handler
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                throw new IllegalStateException("A visibility bridge handler must not apply any preparations");
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return new Compiled(implementationTarget.getInstrumentedType());
            }

            protected static class Compiled
            implements io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.MethodRegistry$Handler$Compiled {
                private final TypeDescription instrumentedType;

                protected Compiled(TypeDescription instrumentedType) {
                    this.instrumentedType = instrumentedType;
                }

                @Override
                public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender, Visibility visibility) {
                    return TypeWriter.MethodPool.Record.ForDefinedMethod.OfVisibilityBridge.of(this.instrumentedType, methodDescription, attributeAppender);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Compiled)) {
                        return false;
                    }
                    Compiled other = (Compiled)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$instrumentedType = this.instrumentedType;
                    TypeDescription other$instrumentedType = other.instrumentedType;
                    return !(this$instrumentedType == null ? other$instrumentedType != null : !this$instrumentedType.equals(other$instrumentedType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Compiled;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $instrumentedType = this.instrumentedType;
                    result = result * 59 + ($instrumentedType == null ? 43 : $instrumentedType.hashCode());
                    return result;
                }
            }
        }

        public static enum ForAbstractMethod implements Handler,
        Compiled
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender, Visibility visibility) {
                return new TypeWriter.MethodPool.Record.ForDefinedMethod.WithoutBody(methodDescription, attributeAppender, visibility);
            }
        }
    }
}

