/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.swagger.config;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import java.util.Collections;
import java.util.Map;

public class SwaggerFlows {
    @Parameter
    private Entry implicit;
    @Parameter
    private Entry password;
    @Parameter
    private Entry clientCredentials;
    @Parameter
    private Entry authorizationCode;
    @Parameter
    private Map<String, Object> extensions = Collections.emptyMap();

    public OAuthFlows createOAuthFlowsModel() {
        OAuthFlows flows = new OAuthFlows();
        if (this.implicit != null) {
            flows.setImplicit(this.implicit.toOAuthFlowModel());
        }
        if (this.password != null) {
            flows.setPassword(this.password.toOAuthFlowModel());
        }
        if (this.clientCredentials != null) {
            flows.setClientCredentials(this.clientCredentials.toOAuthFlowModel());
        }
        if (this.authorizationCode != null) {
            flows.setAuthorizationCode(this.authorizationCode.toOAuthFlowModel());
        }
        flows.setExtensions(this.extensions);
        return flows;
    }

    public static class Entry {
        @Parameter
        private String authorizationUrl;
        @Parameter
        private String tokenUrl;
        @Parameter
        private String refreshUrl;
        @Parameter(required=true)
        private Map<String, String> scopes = Collections.emptyMap();
        @Parameter
        private Map<String, Object> extensions = Collections.emptyMap();

        public OAuthFlow toOAuthFlowModel() {
            OAuthFlow flow = new OAuthFlow();
            flow.setAuthorizationUrl(this.authorizationUrl);
            flow.setTokenUrl(this.tokenUrl);
            flow.setRefreshUrl(this.refreshUrl);
            if (this.scopes != null && !this.scopes.isEmpty()) {
                Scopes ss = new Scopes();
                this.scopes.entrySet().forEach(s -> ss.addString((String)s.getKey(), (String)s.getValue()));
                flow.setScopes(ss);
            }
            if (this.extensions != null && !this.extensions.isEmpty()) {
                flow.setExtensions(this.extensions);
            }
            return flow;
        }
    }
}

