/*
 * Copyright 2025 ObjectBox Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.model;

import io.objectbox.flatbuffers.BaseVector;
import io.objectbox.flatbuffers.BooleanVector;
import io.objectbox.flatbuffers.ByteVector;
import io.objectbox.flatbuffers.Constants;
import io.objectbox.flatbuffers.DoubleVector;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.flatbuffers.FloatVector;
import io.objectbox.flatbuffers.IntVector;
import io.objectbox.flatbuffers.LongVector;
import io.objectbox.flatbuffers.ShortVector;
import io.objectbox.flatbuffers.StringVector;
import io.objectbox.flatbuffers.Struct;
import io.objectbox.flatbuffers.Table;
import io.objectbox.flatbuffers.UnionVector;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 * Parameters to configure HNSW-based approximate nearest neighbor (ANN) search.
 * Some of the parameters can influence index construction and searching.
 * Changing these values causes re-indexing, which can take a while due to the complex nature of HNSW.
 */
@SuppressWarnings("unused")
public final class HnswParams extends Table {
  public static void ValidateVersion() { Constants.FLATBUFFERS_23_5_26(); }
  public static HnswParams getRootAsHnswParams(ByteBuffer _bb) { return getRootAsHnswParams(_bb, new HnswParams()); }
  public static HnswParams getRootAsHnswParams(ByteBuffer _bb, HnswParams obj) { _bb.order(ByteOrder.LITTLE_ENDIAN); return (obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb)); }
  public void __init(int _i, ByteBuffer _bb) { __reset(_i, _bb); }
  public HnswParams __assign(int _i, ByteBuffer _bb) { __init(_i, _bb); return this; }

  /**
   * Dimensions of vectors; vector data with less dimensions are ignored.
   * Vectors with more dimensions than specified here are only evaluated up to the given dimension value.
   * Changing this value causes re-indexing.
   */
  public long dimensions() { int o = __offset(4); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * Aka "M": the max number of connections per node (default: 30).
   * Higher numbers increase the graph connectivity, which can lead to more accurate search results.
   * However, higher numbers also increase the indexing time and resource usage.
   * Try e.g. 16 for faster but less accurate results, or 64 for more accurate results.
   * Changing this value causes re-indexing.
   */
  public long neighborsPerNode() { int o = __offset(6); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * Aka "efConstruction": the number of neighbor searched for while indexing (default: 100).
   * The higher the value, the more accurate the search, but the longer the indexing.
   * If indexing time is not a major concern, a value of at least 200 is recommended to improve search quality.
   * Changing this value causes re-indexing.
   */
  public long indexingSearchCount() { int o = __offset(8); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  public long flags() { int o = __offset(10); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * The distance type used for the HNSW index; if none is given, the default Euclidean is used.
   * Changing this value causes re-indexing.
   */
  public int distanceType() { int o = __offset(12); return o != 0 ? bb.getShort(o + bb_pos) & 0xFFFF : 0; }
  /**
   * When repairing the graph after a node was removed, this gives the probability of adding backlinks to the
   * repaired neighbors.
   * The default is 1.0 (aka "always") as this should be worth a bit of extra costs as it improves the graph's
   * quality.
   */
  public float reparationBacklinkProbability() { int o = __offset(14); return o != 0 ? bb.getFloat(o + bb_pos) : 0.0f; }
  /**
   * A non-binding hint at the maximum size of the vector cache in KB (default: 2097152 or 2 GB/GiB).
   * The actual size max cache size may be altered according to device and/or runtime settings.
   * The vector cache is used to store vectors in memory to speed up search and indexing.
   * Note 1: cache chunks are allocated only on demand, when they are actually used.
   *         Thus, smaller datasets will use less memory.
   * Note 2: the cache is for one specific HNSW index; e.g. each index has its own cache.
   * Note 3: the memory consumption can temporarily exceed the cache size,
   *         e.g. for large changes, it can double due to multi-version transactions.
   */
  public long vectorCacheHintSizeKb() { int o = __offset(16); return o != 0 ? bb.getLong(o + bb_pos) : 0L; }

  public static int createHnswParams(FlatBufferBuilder builder,
      long dimensions,
      long neighborsPerNode,
      long indexingSearchCount,
      long flags,
      int distanceType,
      float reparationBacklinkProbability,
      long vectorCacheHintSizeKb) {
    builder.startTable(7);
    HnswParams.addVectorCacheHintSizeKb(builder, vectorCacheHintSizeKb);
    HnswParams.addReparationBacklinkProbability(builder, reparationBacklinkProbability);
    HnswParams.addFlags(builder, flags);
    HnswParams.addIndexingSearchCount(builder, indexingSearchCount);
    HnswParams.addNeighborsPerNode(builder, neighborsPerNode);
    HnswParams.addDimensions(builder, dimensions);
    HnswParams.addDistanceType(builder, distanceType);
    return HnswParams.endHnswParams(builder);
  }

  public static void startHnswParams(FlatBufferBuilder builder) { builder.startTable(7); }
  public static void addDimensions(FlatBufferBuilder builder, long dimensions) { builder.addInt(0, (int) dimensions, (int) 0L); }
  public static void addNeighborsPerNode(FlatBufferBuilder builder, long neighborsPerNode) { builder.addInt(1, (int) neighborsPerNode, (int) 0L); }
  public static void addIndexingSearchCount(FlatBufferBuilder builder, long indexingSearchCount) { builder.addInt(2, (int) indexingSearchCount, (int) 0L); }
  public static void addFlags(FlatBufferBuilder builder, long flags) { builder.addInt(3, (int) flags, (int) 0L); }
  public static void addDistanceType(FlatBufferBuilder builder, int distanceType) { builder.addShort(4, (short) distanceType, (short) 0); }
  public static void addReparationBacklinkProbability(FlatBufferBuilder builder, float reparationBacklinkProbability) { builder.addFloat(5, reparationBacklinkProbability, 0.0f); }
  public static void addVectorCacheHintSizeKb(FlatBufferBuilder builder, long vectorCacheHintSizeKb) { builder.addLong(6, vectorCacheHintSizeKb, 0L); }
  public static int endHnswParams(FlatBufferBuilder builder) {
    int o = builder.endTable();
    return o;
  }

  public static final class Vector extends BaseVector {
    public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) { __reset(_vector, _element_size, _bb); return this; }

    public HnswParams get(int j) { return get(new HnswParams(), j); }
    public HnswParams get(HnswParams obj, int j) {  return obj.__assign(__indirect(__element(j), bb), bb); }
  }
}

