/*
 * Copyright 2024 ObjectBox Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.sync.server;

import io.objectbox.flatbuffers.BaseVector;
import io.objectbox.flatbuffers.BooleanVector;
import io.objectbox.flatbuffers.ByteVector;
import io.objectbox.flatbuffers.Constants;
import io.objectbox.flatbuffers.DoubleVector;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.flatbuffers.FloatVector;
import io.objectbox.flatbuffers.IntVector;
import io.objectbox.flatbuffers.LongVector;
import io.objectbox.flatbuffers.ShortVector;
import io.objectbox.flatbuffers.StringVector;
import io.objectbox.flatbuffers.Struct;
import io.objectbox.flatbuffers.Table;
import io.objectbox.flatbuffers.UnionVector;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 * The Sync server configuration used to configure a starting Sync Server.
 */
@SuppressWarnings("unused")
public final class SyncServerOptions extends Table {
  public static void ValidateVersion() { Constants.FLATBUFFERS_23_5_26(); }
  public static SyncServerOptions getRootAsSyncServerOptions(ByteBuffer _bb) { return getRootAsSyncServerOptions(_bb, new SyncServerOptions()); }
  public static SyncServerOptions getRootAsSyncServerOptions(ByteBuffer _bb, SyncServerOptions obj) { _bb.order(ByteOrder.LITTLE_ENDIAN); return (obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb)); }
  public void __init(int _i, ByteBuffer _bb) { __reset(_i, _bb); }
  public SyncServerOptions __assign(int _i, ByteBuffer _bb) { __init(_i, _bb); return this; }

  /**
   * URL of this Sync Server on which the Sync protocol is exposed (where the server "binds" to).
   * This is typically a WebSockets URL, i.e. starting with "ws://" or "wss://" (with SSL enabled).
   * Once running, Sync Clients can connect here.
   */
  public String url() { int o = __offset(4); return o != 0 ? __string(o + bb_pos) : null; }
  public ByteBuffer urlAsByteBuffer() { return __vector_as_bytebuffer(4, 1); }
  public ByteBuffer urlInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 4, 1); }
  /**
   * A list of enabled authentication methods available to Sync Clients to login.
   */
  public io.objectbox.sync.Credentials authenticationMethods(int j) { return authenticationMethods(new io.objectbox.sync.Credentials(), j); }
  public io.objectbox.sync.Credentials authenticationMethods(io.objectbox.sync.Credentials obj, int j) { int o = __offset(6); return o != 0 ? obj.__assign(__indirect(__vector(o) + j * 4), bb) : null; }
  public int authenticationMethodsLength() { int o = __offset(6); return o != 0 ? __vector_len(o) : 0; }
  public io.objectbox.sync.Credentials.Vector authenticationMethodsVector() { return authenticationMethodsVector(new io.objectbox.sync.Credentials.Vector()); }
  public io.objectbox.sync.Credentials.Vector authenticationMethodsVector(io.objectbox.sync.Credentials.Vector obj) { int o = __offset(6); return o != 0 ? obj.__assign(__vector(o), 4, bb) : null; }
  /**
   * Bit flags to configure the Sync Server that are also shared with Sync clients.
   */
  public long syncFlags() { int o = __offset(8); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * Bit flags to configure the Sync Server.
   */
  public long syncServerFlags() { int o = __offset(10); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * The SSL certificate directory; SSL will be enabled if not empty.
   * Expects the files cert.pem and key.pem present in this directory.
   */
  public String certificatePath() { int o = __offset(12); return o != 0 ? __string(o + bb_pos) : null; }
  public ByteBuffer certificatePathAsByteBuffer() { return __vector_as_bytebuffer(12, 1); }
  public ByteBuffer certificatePathInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 12, 1); }
  /**
   * By default (absent or zero given), this uses a hardware dependent default, e.g. 3 * CPU "cores"
   */
  public long workerThreads() { int o = __offset(14); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * Once the maximum size is reached, old TX logs are deleted to stay below this limit.
   * This is sometimes also called "history pruning" in the context of Sync.
   * Absent or zero: no limit
   */
  public long historySizeMaxKb() { int o = __offset(16); return o != 0 ? bb.getLong(o + bb_pos) : 0L; }
  /**
   * Once the maximum size (historySizeMaxKb) is reached,
   * old TX logs are deleted until this size target is reached (lower than the maximum size).
   * Using this target size typically lowers the frequency of history pruning and thus may improve efficiency.
   * If absent or zero, it defaults to historySizeMaxKb.
   */
  public long historySizeTargetKb() { int o = __offset(18); return o != 0 ? bb.getLong(o + bb_pos) : 0L; }
  /**
   * URL of the Admin (web server) to bind to.
   * Once running, the user can open a browser to open the Admin web app.
   */
  public String adminUrl() { int o = __offset(20); return o != 0 ? __string(o + bb_pos) : null; }
  public ByteBuffer adminUrlAsByteBuffer() { return __vector_as_bytebuffer(20, 1); }
  public ByteBuffer adminUrlInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 20, 1); }
  /**
   * Number of worker threads used by the Admin web server.
   */
  public long adminThreads() { int o = __offset(22); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * Enables cluster mode (requires the Cluster feature) and associates this cluster peer with the given ID.
   * Cluster peers need to share the same ID to be in the same cluster.
   */
  public String clusterId() { int o = __offset(24); return o != 0 ? __string(o + bb_pos) : null; }
  public ByteBuffer clusterIdAsByteBuffer() { return __vector_as_bytebuffer(24, 1); }
  public ByteBuffer clusterIdInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 24, 1); }
  /**
   * List of other (remote) cluster peers to connect to.
   */
  public io.objectbox.sync.server.ClusterPeerConfig clusterPeers(int j) { return clusterPeers(new io.objectbox.sync.server.ClusterPeerConfig(), j); }
  public io.objectbox.sync.server.ClusterPeerConfig clusterPeers(io.objectbox.sync.server.ClusterPeerConfig obj, int j) { int o = __offset(26); return o != 0 ? obj.__assign(__indirect(__vector(o) + j * 4), bb) : null; }
  public int clusterPeersLength() { int o = __offset(26); return o != 0 ? __vector_len(o) : 0; }
  public io.objectbox.sync.server.ClusterPeerConfig.Vector clusterPeersVector() { return clusterPeersVector(new io.objectbox.sync.server.ClusterPeerConfig.Vector()); }
  public io.objectbox.sync.server.ClusterPeerConfig.Vector clusterPeersVector(io.objectbox.sync.server.ClusterPeerConfig.Vector obj) { int o = __offset(26); return o != 0 ? obj.__assign(__vector(o), 4, bb) : null; }
  /**
   * Bit flags to configure the cluster behavior of this sync server (aka cluster peer).
   */
  public long clusterFlags() { int o = __offset(28); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * Optional configuration for JWT (JSON Web Token) authentication.
   */
  public io.objectbox.sync.server.JwtConfig jwtConfig() { return jwtConfig(new io.objectbox.sync.server.JwtConfig()); }
  public io.objectbox.sync.server.JwtConfig jwtConfig(io.objectbox.sync.server.JwtConfig obj) { int o = __offset(30); return o != 0 ? obj.__assign(__indirect(o + bb_pos), bb) : null; }
  /**
   * Credential types that are required for clients logging in.
   */
  public long requiredCredentials(int j) { int o = __offset(32); return o != 0 ? (long)bb.getInt(__vector(o) + j * 4) & 0xFFFFFFFFL : 0; }
  public int requiredCredentialsLength() { int o = __offset(32); return o != 0 ? __vector_len(o) : 0; }
  public IntVector requiredCredentialsVector() { return requiredCredentialsVector(new IntVector()); }
  public IntVector requiredCredentialsVector(IntVector obj) { int o = __offset(32); return o != 0 ? obj.__assign(__vector(o), bb) : null; }
  public ByteBuffer requiredCredentialsAsByteBuffer() { return __vector_as_bytebuffer(32, 4); }
  public ByteBuffer requiredCredentialsInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 32, 4); }

  public static int createSyncServerOptions(FlatBufferBuilder builder,
                                            int urlOffset,
                                            int authenticationMethodsOffset,
                                            long syncFlags,
                                            long syncServerFlags,
                                            int certificatePathOffset,
                                            long workerThreads,
                                            long historySizeMaxKb,
                                            long historySizeTargetKb,
                                            int adminUrlOffset,
                                            long adminThreads,
                                            int clusterIdOffset,
                                            int clusterPeersOffset,
                                            long clusterFlags,
                                            int jwtConfigOffset,
                                            int requiredCredentialsOffset) {
    builder.startTable(15);
    SyncServerOptions.addHistorySizeTargetKb(builder, historySizeTargetKb);
    SyncServerOptions.addHistorySizeMaxKb(builder, historySizeMaxKb);
    SyncServerOptions.addRequiredCredentials(builder, requiredCredentialsOffset);
    SyncServerOptions.addJwtConfig(builder, jwtConfigOffset);
    SyncServerOptions.addClusterFlags(builder, clusterFlags);
    SyncServerOptions.addClusterPeers(builder, clusterPeersOffset);
    SyncServerOptions.addClusterId(builder, clusterIdOffset);
    SyncServerOptions.addAdminThreads(builder, adminThreads);
    SyncServerOptions.addAdminUrl(builder, adminUrlOffset);
    SyncServerOptions.addWorkerThreads(builder, workerThreads);
    SyncServerOptions.addCertificatePath(builder, certificatePathOffset);
    SyncServerOptions.addSyncServerFlags(builder, syncServerFlags);
    SyncServerOptions.addSyncFlags(builder, syncFlags);
    SyncServerOptions.addAuthenticationMethods(builder, authenticationMethodsOffset);
    SyncServerOptions.addUrl(builder, urlOffset);
    return SyncServerOptions.endSyncServerOptions(builder);
  }

  public static void startSyncServerOptions(FlatBufferBuilder builder) { builder.startTable(15); }
  public static void addUrl(FlatBufferBuilder builder, int urlOffset) { builder.addOffset(0, urlOffset, 0); }
  public static void addAuthenticationMethods(FlatBufferBuilder builder, int authenticationMethodsOffset) { builder.addOffset(1, authenticationMethodsOffset, 0); }
  public static int createAuthenticationMethodsVector(FlatBufferBuilder builder, int[] data) { builder.startVector(4, data.length, 4); for (int i = data.length - 1; i >= 0; i--) builder.addOffset(data[i]); return builder.endVector(); }
  public static void startAuthenticationMethodsVector(FlatBufferBuilder builder, int numElems) { builder.startVector(4, numElems, 4); }
  public static void addSyncFlags(FlatBufferBuilder builder, long syncFlags) { builder.addInt(2, (int) syncFlags, (int) 0L); }
  public static void addSyncServerFlags(FlatBufferBuilder builder, long syncServerFlags) { builder.addInt(3, (int) syncServerFlags, (int) 0L); }
  public static void addCertificatePath(FlatBufferBuilder builder, int certificatePathOffset) { builder.addOffset(4, certificatePathOffset, 0); }
  public static void addWorkerThreads(FlatBufferBuilder builder, long workerThreads) { builder.addInt(5, (int) workerThreads, (int) 0L); }
  public static void addHistorySizeMaxKb(FlatBufferBuilder builder, long historySizeMaxKb) { builder.addLong(6, historySizeMaxKb, 0L); }
  public static void addHistorySizeTargetKb(FlatBufferBuilder builder, long historySizeTargetKb) { builder.addLong(7, historySizeTargetKb, 0L); }
  public static void addAdminUrl(FlatBufferBuilder builder, int adminUrlOffset) { builder.addOffset(8, adminUrlOffset, 0); }
  public static void addAdminThreads(FlatBufferBuilder builder, long adminThreads) { builder.addInt(9, (int) adminThreads, (int) 0L); }
  public static void addClusterId(FlatBufferBuilder builder, int clusterIdOffset) { builder.addOffset(10, clusterIdOffset, 0); }
  public static void addClusterPeers(FlatBufferBuilder builder, int clusterPeersOffset) { builder.addOffset(11, clusterPeersOffset, 0); }
  public static int createClusterPeersVector(FlatBufferBuilder builder, int[] data) { builder.startVector(4, data.length, 4); for (int i = data.length - 1; i >= 0; i--) builder.addOffset(data[i]); return builder.endVector(); }
  public static void startClusterPeersVector(FlatBufferBuilder builder, int numElems) { builder.startVector(4, numElems, 4); }
  public static void addClusterFlags(FlatBufferBuilder builder, long clusterFlags) { builder.addInt(12, (int) clusterFlags, (int) 0L); }
  public static void addJwtConfig(FlatBufferBuilder builder, int jwtConfigOffset) { builder.addOffset(13, jwtConfigOffset, 0); }
  public static void addRequiredCredentials(FlatBufferBuilder builder, int requiredCredentialsOffset) { builder.addOffset(14, requiredCredentialsOffset, 0); }
  public static int createRequiredCredentialsVector(FlatBufferBuilder builder, long[] data) { builder.startVector(4, data.length, 4); for (int i = data.length - 1; i >= 0; i--) builder.addInt((int) data[i]); return builder.endVector(); }
  public static void startRequiredCredentialsVector(FlatBufferBuilder builder, int numElems) { builder.startVector(4, numElems, 4); }
  public static int endSyncServerOptions(FlatBufferBuilder builder) {
    int o = builder.endTable();
    return o;
  }
  public static void finishSyncServerOptionsBuffer(FlatBufferBuilder builder, int offset) { builder.finish(offset); }
  public static void finishSizePrefixedSyncServerOptionsBuffer(FlatBufferBuilder builder, int offset) { builder.finishSizePrefixed(offset); }

  public static final class Vector extends BaseVector {
    public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) { __reset(_vector, _element_size, _bb); return this; }

    public SyncServerOptions get(int j) { return get(new SyncServerOptions(), j); }
    public SyncServerOptions get(SyncServerOptions obj, int j) {  return obj.__assign(__indirect(__element(j), bb), bb); }
  }
}

