/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.relation;

import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.Cursor;
import io.objectbox.InternalAccess;
import io.objectbox.annotation.apihint.Beta;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.exception.DbDetachedException;
import io.objectbox.internal.IdGetter;
import io.objectbox.internal.ReflectionCache;
import io.objectbox.internal.ToManyGetter;
import io.objectbox.internal.ToOneGetter;
import io.objectbox.query.QueryFilter;
import io.objectbox.relation.ListFactory;
import io.objectbox.relation.RelationInfo;
import io.objectbox.relation.ToOne;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ToMany<TARGET>
implements List<TARGET>,
Serializable {
    private static final long serialVersionUID = 2367317778240689006L;
    private static final Integer ONE = 1;
    private final Object entity;
    private final RelationInfo<Object, TARGET> relationInfo;
    private volatile ListFactory listFactory;
    private List<TARGET> entities;
    private Map<TARGET, Integer> entityCounts;
    private volatile Map<TARGET, Boolean> entitiesAdded;
    private Map<TARGET, Boolean> entitiesRemoved;
    List<TARGET> entitiesToPut;
    List<TARGET> entitiesToRemoveFromDb;
    private transient BoxStore boxStore;
    private transient Box<Object> entityBox;
    private volatile transient Box<TARGET> targetBox;
    private transient boolean removeFromTargetBox;
    private transient Comparator<TARGET> comparator;

    public ToMany(Object sourceEntity, RelationInfo<?, TARGET> relationInfo) {
        if (sourceEntity == null) {
            throw new IllegalArgumentException("No source entity given (null)");
        }
        if (relationInfo == null) {
            throw new IllegalArgumentException("No relation info given (null)");
        }
        this.entity = sourceEntity;
        this.relationInfo = relationInfo;
    }

    @Experimental
    public void setListFactory(ListFactory listFactory) {
        if (listFactory == null) {
            throw new IllegalArgumentException("ListFactory is null");
        }
        this.listFactory = listFactory;
    }

    @Experimental
    public void setComparator(Comparator<TARGET> comparator) {
        this.comparator = comparator;
    }

    @Experimental
    public synchronized void setRemoveFromTargetBox(boolean removeFromTargetBox) {
        this.removeFromTargetBox = removeFromTargetBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListFactory getListFactory() {
        ListFactory result = this.listFactory;
        if (result == null) {
            ToMany toMany = this;
            synchronized (toMany) {
                result = this.listFactory;
                if (result == null) {
                    this.listFactory = result = new ListFactory.CopyOnWriteArrayListFactory();
                }
            }
        }
        return result;
    }

    private void ensureBoxes() {
        if (this.targetBox == null) {
            Field boxStoreField = ReflectionCache.getInstance().getField(this.entity.getClass(), "__boxStore");
            try {
                this.boxStore = (BoxStore)boxStoreField.get(this.entity);
                if (this.boxStore == null) {
                    throw new DbDetachedException("Cannot resolve relation for detached objects, call box.attach(object) beforehand.");
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            this.entityBox = this.boxStore.boxFor(this.relationInfo.sourceInfo.getEntityClass());
            this.targetBox = this.boxStore.boxFor(this.relationInfo.targetInfo.getEntityClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureEntitiesWithTrackingLists() {
        this.ensureEntities();
        if (this.entitiesAdded == null) {
            ToMany toMany = this;
            synchronized (toMany) {
                if (this.entitiesAdded == null) {
                    this.entitiesAdded = new LinkedHashMap<TARGET, Boolean>();
                    this.entitiesRemoved = new LinkedHashMap<TARGET, Boolean>();
                    this.entityCounts = new HashMap<TARGET, Integer>();
                    for (TARGET object : this.entities) {
                        Integer old = this.entityCounts.put(object, ONE);
                        if (old == null) continue;
                        this.entityCounts.put(object, old + 1);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureEntities() {
        if (this.entities == null) {
            List<TARGET> newEntities;
            long id = this.relationInfo.sourceInfo.getIdGetter().getId(this.entity);
            if (id == 0L) {
                ToMany toMany = this;
                synchronized (toMany) {
                    if (this.entities == null) {
                        this.entities = this.getListFactory().createList();
                    }
                }
            }
            this.ensureBoxes();
            int relationId = this.relationInfo.relationId;
            if (relationId != 0) {
                int sourceEntityId = this.relationInfo.sourceInfo.getEntityId();
                newEntities = this.targetBox.internalGetRelationEntities(sourceEntityId, relationId, id, false);
            } else {
                newEntities = this.relationInfo.targetIdProperty != null ? this.targetBox.internalGetBacklinkEntities(this.relationInfo.targetInfo.getEntityId(), this.relationInfo.targetIdProperty, id) : this.targetBox.internalGetRelationEntities(this.relationInfo.targetInfo.getEntityId(), this.relationInfo.targetRelationId, id, true);
            }
            if (this.comparator != null) {
                Collections.sort(newEntities, this.comparator);
            }
            ToMany toMany = this;
            synchronized (toMany) {
                if (this.entities == null) {
                    this.entities = newEntities;
                }
            }
        }
    }

    @Override
    public synchronized boolean add(TARGET object) {
        this.trackAdd(object);
        return this.entities.add(object);
    }

    private void trackAdd(TARGET object) {
        this.ensureEntitiesWithTrackingLists();
        Integer old = this.entityCounts.put(object, ONE);
        if (old != null) {
            this.entityCounts.put(object, old + 1);
        }
        this.entitiesAdded.put(object, Boolean.TRUE);
        this.entitiesRemoved.remove(object);
    }

    private void trackAdd(Collection<? extends TARGET> objects) {
        this.ensureEntitiesWithTrackingLists();
        for (TARGET object : objects) {
            this.trackAdd(object);
        }
    }

    private void trackRemove(TARGET object) {
        this.ensureEntitiesWithTrackingLists();
        Integer count = this.entityCounts.remove(object);
        if (count != null) {
            if (count == 1) {
                this.entityCounts.remove(object);
                this.entitiesAdded.remove(object);
                this.entitiesRemoved.put(object, Boolean.TRUE);
            } else if (count > 1) {
                this.entityCounts.put(object, count - 1);
            } else {
                throw new IllegalStateException("Illegal count: " + count);
            }
        }
    }

    @Override
    public synchronized void add(int location, TARGET object) {
        this.trackAdd(object);
        this.entities.add(location, object);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends TARGET> objects) {
        this.trackAdd(objects);
        return this.entities.addAll(objects);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends TARGET> objects) {
        this.trackAdd(objects);
        return this.entities.addAll(index, objects);
    }

    @Override
    public synchronized void clear() {
        Map<TARGET, Integer> entityCountsToClear;
        Map<TARGET, Boolean> setToClear;
        this.ensureEntitiesWithTrackingLists();
        List<TARGET> entitiesToClear = this.entities;
        if (entitiesToClear != null) {
            for (TARGET target : entitiesToClear) {
                this.entitiesRemoved.put(target, Boolean.TRUE);
            }
            entitiesToClear.clear();
        }
        if ((setToClear = this.entitiesAdded) != null) {
            setToClear.clear();
        }
        if ((entityCountsToClear = this.entityCounts) != null) {
            entityCountsToClear.clear();
        }
    }

    @Override
    public boolean contains(Object object) {
        this.ensureEntities();
        return this.entities.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.ensureEntities();
        return this.entities.containsAll(collection);
    }

    @Override
    public TARGET get(int location) {
        this.ensureEntities();
        return this.entities.get(location);
    }

    @Override
    public int indexOf(Object object) {
        this.ensureEntities();
        return this.entities.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        this.ensureEntities();
        return this.entities.isEmpty();
    }

    @Override
    @Nonnull
    public Iterator<TARGET> iterator() {
        this.ensureEntities();
        return this.entities.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        this.ensureEntities();
        return this.entities.lastIndexOf(object);
    }

    @Override
    @Nonnull
    public ListIterator<TARGET> listIterator() {
        this.ensureEntities();
        return this.entities.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<TARGET> listIterator(int location) {
        this.ensureEntities();
        return this.entities.listIterator(location);
    }

    @Override
    public synchronized TARGET remove(int location) {
        this.ensureEntitiesWithTrackingLists();
        TARGET removed = this.entities.remove(location);
        this.trackRemove(removed);
        return removed;
    }

    @Override
    public synchronized boolean remove(Object object) {
        this.ensureEntitiesWithTrackingLists();
        boolean removed = this.entities.remove(object);
        if (removed) {
            this.trackRemove(object);
        }
        return removed;
    }

    public synchronized TARGET removeById(long id) {
        this.ensureEntities();
        int size = this.entities.size();
        IdGetter idGetter = this.relationInfo.targetInfo.getIdGetter();
        for (int i = 0; i < size; ++i) {
            TARGET candidate = this.entities.get(i);
            if (idGetter.getId(candidate) != id) continue;
            TARGET removed = this.remove(i);
            if (removed != candidate) {
                throw new IllegalStateException("Mismatch: " + removed + " vs. " + candidate);
            }
            return candidate;
        }
        return null;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> objects) {
        boolean changes = false;
        for (Object object : objects) {
            changes |= this.remove(object);
        }
        return changes;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> objects) {
        this.ensureEntitiesWithTrackingLists();
        boolean changes = false;
        ArrayList<TARGET> toRemove = null;
        for (TARGET target : this.entities) {
            if (objects.contains(target)) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<TARGET>();
            }
            toRemove.add(target);
            changes = true;
        }
        if (toRemove != null) {
            this.removeAll(toRemove);
        }
        return changes;
    }

    @Override
    public synchronized TARGET set(int location, TARGET object) {
        this.ensureEntitiesWithTrackingLists();
        TARGET old = this.entities.set(location, object);
        this.trackRemove(old);
        this.trackAdd(object);
        return old;
    }

    @Override
    public int size() {
        this.ensureEntities();
        return this.entities.size();
    }

    @Override
    @Nonnull
    public List<TARGET> subList(int start, int end) {
        this.ensureEntities();
        return this.entities.subList(start, end);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        this.ensureEntities();
        return this.entities.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(T[] array) {
        this.ensureEntities();
        return this.entities.toArray(array);
    }

    public synchronized void reset() {
        this.entities = null;
        this.entitiesAdded = null;
        this.entitiesRemoved = null;
        this.entitiesToRemoveFromDb = null;
        this.entitiesToPut = null;
        this.entityCounts = null;
    }

    public boolean isResolved() {
        return this.entities != null;
    }

    public int getAddCount() {
        Map<TARGET, Boolean> set = this.entitiesAdded;
        return set != null ? set.size() : 0;
    }

    public int getRemoveCount() {
        Map<TARGET, Boolean> set = this.entitiesRemoved;
        return set != null ? set.size() : 0;
    }

    public void sortById() {
        this.ensureEntities();
        Collections.sort(this.entities, new Comparator<TARGET>(){
            IdGetter<TARGET> idGetter;
            {
                this.idGetter = ((ToMany)ToMany.this).relationInfo.targetInfo.getIdGetter();
            }

            @Override
            public int compare(TARGET o1, TARGET o2) {
                long delta;
                long id1 = this.idGetter.getId(o1);
                long id2 = this.idGetter.getId(o2);
                if (id1 == 0L) {
                    id1 = Long.MAX_VALUE;
                }
                if (id2 == 0L) {
                    id2 = Long.MAX_VALUE;
                }
                if ((delta = id1 - id2) < 0L) {
                    return -1;
                }
                if (delta > 0L) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void applyChangesToDb() {
        long id = this.relationInfo.sourceInfo.getIdGetter().getId(this.entity);
        if (id == 0L) {
            throw new IllegalStateException("The object with the ToMany was not yet persisted (no ID), use box.put() on it instead");
        }
        try {
            this.ensureBoxes();
        }
        catch (DbDetachedException e) {
            throw new IllegalStateException("The object with the ToMany was not yet persisted, use box.put() on it instead");
        }
        if (this.internalCheckApplyToDbRequired()) {
            this.boxStore.runInTx(() -> {
                Cursor<Object> sourceCursor = InternalAccess.getActiveTxCursor(this.entityBox);
                Cursor<TARGET> targetCursor = InternalAccess.getActiveTxCursor(this.targetBox);
                this.internalApplyToDb(sourceCursor, targetCursor);
            });
        }
    }

    @Beta
    public boolean hasA(QueryFilter<TARGET> filter) {
        Object[] objects;
        for (Object target : objects = this.toArray()) {
            if (!filter.keep(target)) continue;
            return true;
        }
        return false;
    }

    @Beta
    public boolean hasAll(QueryFilter<TARGET> filter) {
        Object[] objects = this.toArray();
        if (objects.length == 0) {
            return false;
        }
        for (Object target : objects) {
            if (filter.keep(target)) continue;
            return false;
        }
        return true;
    }

    @Beta
    public TARGET getById(long id) {
        this.ensureEntities();
        Object[] objects = this.entities.toArray();
        IdGetter idGetter = this.relationInfo.targetInfo.getIdGetter();
        for (Object target : objects) {
            if (idGetter.getId(target) != id) continue;
            return (TARGET)target;
        }
        return null;
    }

    @Beta
    public int indexOfId(long id) {
        this.ensureEntities();
        Object[] objects = this.entities.toArray();
        IdGetter idGetter = this.relationInfo.targetInfo.getIdGetter();
        int index = 0;
        for (Object target : objects) {
            if (idGetter.getId(target) == id) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean hasPendingDbChanges() {
        Map<TARGET, Boolean> setAdded = this.entitiesAdded;
        if (setAdded != null && !setAdded.isEmpty()) {
            return true;
        }
        Map<TARGET, Boolean> setRemoved = this.entitiesRemoved;
        return setRemoved != null && !setRemoved.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public boolean internalCheckApplyToDbRequired() {
        if (!this.hasPendingDbChanges()) {
            return false;
        }
        ToMany toMany = this;
        synchronized (toMany) {
            if (this.entitiesToPut == null) {
                this.entitiesToPut = new ArrayList<TARGET>();
                this.entitiesToRemoveFromDb = new ArrayList<TARGET>();
            }
        }
        if (this.relationInfo.relationId != 0) {
            return true;
        }
        long entityId = this.relationInfo.sourceInfo.getIdGetter().getId(this.entity);
        if (entityId == 0L) {
            throw new IllegalStateException("Object with the ToMany has no ID (should have been put before)");
        }
        IdGetter idGetter = this.relationInfo.targetInfo.getIdGetter();
        Map<TARGET, Boolean> setAdded = this.entitiesAdded;
        Map<TARGET, Boolean> setRemoved = this.entitiesRemoved;
        if (this.relationInfo.targetRelationId != 0) {
            return this.prepareToManyBacklinkEntitiesForDb(entityId, idGetter, setAdded, setRemoved);
        }
        return this.prepareToOneBacklinkEntitiesForDb(entityId, idGetter, setAdded, setRemoved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToManyBacklinkEntitiesForDb(long entityId, IdGetter<TARGET> idGetter, @Nullable Map<TARGET, Boolean> setAdded, @Nullable Map<TARGET, Boolean> setRemoved) {
        ToManyGetter backlinkToManyGetter = this.relationInfo.backlinkToManyGetter;
        ToMany toMany = this;
        synchronized (toMany) {
            ToMany toMany2;
            if (setAdded != null && !setAdded.isEmpty()) {
                for (TARGET target : setAdded.keySet()) {
                    toMany2 = (ToMany)backlinkToManyGetter.getToMany(target);
                    if (toMany2 == null) {
                        throw new IllegalStateException("The ToMany property for " + this.relationInfo.targetInfo.getEntityName() + " is null");
                    }
                    if (toMany2.getById(entityId) == null) {
                        toMany2.add((TARGET)this.entity);
                        this.entitiesToPut.add(target);
                        continue;
                    }
                    if (idGetter.getId(target) != 0L) continue;
                    this.entitiesToPut.add(target);
                }
                setAdded.clear();
            }
            if (setRemoved != null) {
                for (TARGET target : setRemoved.keySet()) {
                    toMany2 = (ToMany)backlinkToManyGetter.getToMany(target);
                    if (toMany2.getById(entityId) == null) continue;
                    toMany2.removeById(entityId);
                    if (idGetter.getId(target) == 0L) continue;
                    if (this.removeFromTargetBox) {
                        this.entitiesToRemoveFromDb.add(target);
                        continue;
                    }
                    this.entitiesToPut.add(target);
                }
                setRemoved.clear();
            }
            return !this.entitiesToPut.isEmpty() || !this.entitiesToRemoveFromDb.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToOneBacklinkEntitiesForDb(long entityId, IdGetter<TARGET> idGetter, @Nullable Map<TARGET, Boolean> setAdded, @Nullable Map<TARGET, Boolean> setRemoved) {
        ToOneGetter backlinkToOneGetter = this.relationInfo.backlinkToOneGetter;
        ToMany toMany = this;
        synchronized (toMany) {
            long toOneTargetId;
            ToOne toOne;
            if (setAdded != null && !setAdded.isEmpty()) {
                for (TARGET target : setAdded.keySet()) {
                    toOne = backlinkToOneGetter.getToOne(target);
                    if (toOne == null) {
                        throw new IllegalStateException("The ToOne property for " + this.relationInfo.targetInfo.getEntityName() + "." + this.relationInfo.targetIdProperty.name + " is null");
                    }
                    toOneTargetId = toOne.getTargetId();
                    if (toOneTargetId != entityId) {
                        toOne.setTarget(this.entity);
                        this.entitiesToPut.add(target);
                        continue;
                    }
                    if (idGetter.getId(target) != 0L) continue;
                    this.entitiesToPut.add(target);
                }
                setAdded.clear();
            }
            if (setRemoved != null) {
                for (TARGET target : setRemoved.keySet()) {
                    toOne = backlinkToOneGetter.getToOne(target);
                    toOneTargetId = toOne.getTargetId();
                    if (toOneTargetId != entityId) continue;
                    toOne.setTarget(null);
                    if (idGetter.getId(target) == 0L) continue;
                    if (this.removeFromTargetBox) {
                        this.entitiesToRemoveFromDb.add(target);
                        continue;
                    }
                    this.entitiesToPut.add(target);
                }
                setRemoved.clear();
            }
            return !this.entitiesToPut.isEmpty() || !this.entitiesToRemoveFromDb.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void internalApplyToDb(Cursor<?> sourceCursor, Cursor<TARGET> targetCursor) {
        Object[] addedStandalone = null;
        ArrayList<TARGET> removedStandalone = null;
        boolean isStandaloneRelation = this.relationInfo.relationId != 0;
        IdGetter targetIdGetter = this.relationInfo.targetInfo.getIdGetter();
        Object[] objectArray = this;
        synchronized (this) {
            if (isStandaloneRelation) {
                for (TARGET target : this.entitiesAdded.keySet()) {
                    if (targetIdGetter.getId(target) != 0L) continue;
                    this.entitiesToPut.add(target);
                }
                if (this.removeFromTargetBox) {
                    this.entitiesToRemoveFromDb.addAll(this.entitiesRemoved.keySet());
                }
                if (!this.entitiesAdded.isEmpty()) {
                    addedStandalone = this.entitiesAdded.keySet().toArray();
                    this.entitiesAdded.clear();
                }
                if (!this.entitiesRemoved.isEmpty()) {
                    removedStandalone = new ArrayList<TARGET>(this.entitiesRemoved.keySet());
                    this.entitiesRemoved.clear();
                }
            }
            Object[] toRemoveFromDb = this.entitiesToRemoveFromDb.isEmpty() ? null : this.entitiesToRemoveFromDb.toArray();
            this.entitiesToRemoveFromDb.clear();
            Object[] toPut = this.entitiesToPut.isEmpty() ? null : this.entitiesToPut.toArray();
            this.entitiesToPut.clear();
            // ** MonitorExit[var9_7] (shouldn't be in output)
            if (toRemoveFromDb != null) {
                for (Object target : toRemoveFromDb) {
                    long id = targetIdGetter.getId(target);
                    if (id == 0L) continue;
                    targetCursor.deleteEntity(id);
                }
            }
            if (toPut != null) {
                for (Object target : toPut) {
                    targetCursor.put(target);
                }
            }
            if (isStandaloneRelation) {
                long entityId = this.relationInfo.sourceInfo.getIdGetter().getId(this.entity);
                if (entityId == 0L) {
                    throw new IllegalStateException("Object with the ToMany has no ID (should have been put before)");
                }
                if (removedStandalone != null) {
                    super.removeStandaloneRelations(sourceCursor, entityId, removedStandalone, targetIdGetter);
                }
                if (addedStandalone != null) {
                    super.addStandaloneRelations(sourceCursor, entityId, addedStandalone, targetIdGetter);
                }
            }
            return;
        }
    }

    private void removeStandaloneRelations(Cursor<?> cursor, long sourceEntityId, List<TARGET> removed, IdGetter<TARGET> targetIdGetter) {
        Iterator<TARGET> iterator = removed.iterator();
        while (iterator.hasNext()) {
            if (targetIdGetter.getId(iterator.next()) != 0L) continue;
            iterator.remove();
        }
        int size = removed.size();
        if (size > 0) {
            long[] targetIds = new long[size];
            for (int i = 0; i < size; ++i) {
                targetIds[i] = targetIdGetter.getId(removed.get(i));
            }
            cursor.modifyRelations(this.relationInfo.relationId, sourceEntityId, targetIds, true);
        }
    }

    private void addStandaloneRelations(Cursor<?> cursor, long sourceEntityId, TARGET[] added, IdGetter<TARGET> targetIdGetter) {
        int length = added.length;
        long[] targetIds = new long[length];
        for (int i = 0; i < length; ++i) {
            long targetId = targetIdGetter.getId(added[i]);
            if (targetId == 0L) {
                throw new IllegalStateException("Target object has no ID (should have been put before)");
            }
            targetIds[i] = targetId;
        }
        cursor.modifyRelations(this.relationInfo.relationId, sourceEntityId, targetIds, false);
    }

    Object getEntity() {
        return this.entity;
    }
}

