/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle;

import io.objectbox.gradle.GradleBuildTracker;
import io.objectbox.gradle.ProjectEnv;
import io.objectbox.reporting.ObjectBoxBuildConfig;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0002R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/objectbox/gradle/PrepareTask;", "Lorg/gradle/api/DefaultTask;", "env", "Lio/objectbox/gradle/ProjectEnv;", "buildTracker", "Lio/objectbox/gradle/GradleBuildTracker;", "(Lio/objectbox/gradle/ProjectEnv;Lio/objectbox/gradle/GradleBuildTracker;)V", "buildConfigFile", "Ljava/io/File;", "getBuildConfigFile", "()Ljava/io/File;", "buildDir", "kotlin.jvm.PlatformType", "run", "", "writeBuildConfig", "objectbox-gradle-plugin"})
public class PrepareTask
extends DefaultTask {
    @NotNull
    private final ProjectEnv env;
    @NotNull
    private final GradleBuildTracker buildTracker;
    private final File buildDir;
    @OutputFile
    @NotNull
    private final File buildConfigFile;

    @Inject
    public PrepareTask(@NotNull ProjectEnv env, @NotNull GradleBuildTracker buildTracker) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)((Object)buildTracker), (String)"buildTracker");
        this.env = env;
        this.buildTracker = buildTracker;
        File file = this.buildDir = this.env.getProject().getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"buildDir");
        this.buildConfigFile = ObjectBoxBuildConfig.Companion.buildFile(file);
        this.setGroup("objectbox");
    }

    @NotNull
    public final File getBuildConfigFile() {
        return this.buildConfigFile;
    }

    @TaskAction
    public final void run() {
        this.buildTracker.trackBuild(this.env);
        this.writeBuildConfig();
    }

    private final void writeBuildConfig() {
        String string = this.env.getProject().getProjectDir().getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"env.project.projectDir.absolutePath");
        new ObjectBoxBuildConfig(string, null).writeInto(this.buildConfigFile);
    }
}

