/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.android;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import io.objectbox.BoxStore;
import io.objectbox.android.AdminNotificationReceiver;
import io.objectbox.android.R;

public class Admin {
    private static final String TAG = "ObjectBoxAdmin";
    private static final String NOTIFICATION_CHANNEL_ID = "objectbox-browser";
    private final BoxStore boxStore;
    private int notificationId;

    public Admin(BoxStore boxStore) {
        this.boxStore = boxStore;
    }

    public int getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(int notificationId) {
        this.notificationId = notificationId;
    }

    public boolean start(Context context) {
        int alreadyRunningPort;
        if (!BoxStore.isObjectBrowserAvailable()) {
            return false;
        }
        context.enforcePermission("android.permission.INTERNET", Process.myPid(), Process.myUid(), null);
        if (Build.VERSION.SDK_INT >= 28 && context.getApplicationInfo().targetSdkVersion >= 28) {
            context.enforcePermission("android.permission.FOREGROUND_SERVICE", Process.myPid(), Process.myUid(), null);
        }
        if ((alreadyRunningPort = this.boxStore.getObjectBrowserPort()) != 0) {
            Log.w((String)TAG, (String)("ObjectBox Admin is already running at port " + alreadyRunningPort));
            return false;
        }
        String url = this.boxStore.startObjectBrowser();
        if (url == null) {
            return false;
        }
        Log.i((String)TAG, (String)("ObjectBox Admin running at URL: " + url));
        int port = this.boxStore.getObjectBrowserPort();
        Log.i((String)TAG, (String)("To access the ObjectBox Admin URL on your machine run: adb forward tcp:" + port + " tcp:" + port));
        if (this.notificationId == 0) {
            this.notificationId = 19770000 + port;
        }
        Intent intent = new Intent(context, AdminNotificationReceiver.class);
        intent.setAction("io.objectbox.action.KEEP_ALIVE");
        intent.putExtra("url", url);
        intent.putExtra("port", port);
        intent.putExtra("notificationId", this.notificationId);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)Admin.buildPendingIntentFlags(0x10000000));
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        Notification.Builder builder = Admin.buildBaseNotification(context, port, manager);
        builder.setContentIntent(pendingIntent);
        if (manager != null) {
            manager.notify(this.notificationId, builder.getNotification());
        }
        return true;
    }

    static Notification.Builder buildBaseNotification(Context context, int port, NotificationManager manager) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(NOTIFICATION_CHANNEL_ID, (CharSequence)"ObjectBox Admin", 2);
            manager.createNotificationChannel(channel);
        }
        Notification.Builder builder = Build.VERSION.SDK_INT >= 26 ? new Notification.Builder(context, NOTIFICATION_CHANNEL_ID) : new Notification.Builder(context);
        builder.setContentTitle((CharSequence)context.getString(R.string.objectbox_objectBrowserNotificationTitle)).setContentText((CharSequence)context.getString(R.string.objectbox_objectBrowserNotificationText, new Object[]{port})).setSmallIcon(R.drawable.objectbox_notification);
        return builder;
    }

    static Intent viewIntent(String url) {
        Intent viewIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        viewIntent.setFlags(0x10000000);
        return viewIntent;
    }

    static int buildPendingIntentFlags(int flags) {
        if (Build.VERSION.SDK_INT >= 31) {
            return flags | 0x4000000;
        }
        return flags;
    }
}

