/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.network;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.ImageItem;
import io.noties.markwon.image.SchemeHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;

public class NetworkSchemeHandler
extends SchemeHandler {
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";

    @NonNull
    public static NetworkSchemeHandler create() {
        return new NetworkSchemeHandler();
    }

    NetworkSchemeHandler() {
    }

    @Override
    @NonNull
    public ImageItem handle(@NonNull String raw, @NonNull Uri uri) {
        ImageItem imageItem;
        try {
            URL url = new URL(raw);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode < 200 || responseCode >= 300) {
                throw new IOException("Bad response code: " + responseCode + ", url: " + raw);
            }
            String contentType = NetworkSchemeHandler.contentType(connection.getHeaderField("Content-Type"));
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            imageItem = ImageItem.withDecodingNeeded(contentType, inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception obtaining network resource: " + raw, e);
        }
        return imageItem;
    }

    @Override
    @NonNull
    public Collection<String> supportedSchemes() {
        return Arrays.asList(SCHEME_HTTP, SCHEME_HTTPS);
    }

    @Nullable
    static String contentType(@Nullable String contentType) {
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(59);
        if (index > -1) {
            return contentType.substring(0, index);
        }
        return contentType;
    }
}

