/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.glide;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Spanned;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonSpansFactory;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableLoader;
import io.noties.markwon.image.AsyncDrawableScheduler;
import io.noties.markwon.image.DrawableUtils;
import io.noties.markwon.image.ImageSpanFactory;
import java.util.HashMap;
import java.util.Map;
import org.commonmark.node.Image;

public class GlideImagesPlugin
extends AbstractMarkwonPlugin {
    private final GlideAsyncDrawableLoader glideAsyncDrawableLoader;

    @NonNull
    public static GlideImagesPlugin create(@NonNull Context context) {
        return GlideImagesPlugin.create(Glide.with((Context)context));
    }

    @NonNull
    public static GlideImagesPlugin create(final @NonNull RequestManager requestManager) {
        return GlideImagesPlugin.create(new GlideStore(){

            @Override
            @NonNull
            public RequestBuilder<Drawable> load(@NonNull AsyncDrawable drawable) {
                return requestManager.load(drawable.getDestination());
            }

            @Override
            public void cancel(@NonNull Target<?> target) {
                requestManager.clear(target);
            }
        });
    }

    @NonNull
    public static GlideImagesPlugin create(@NonNull GlideStore glideStore) {
        return new GlideImagesPlugin(glideStore);
    }

    GlideImagesPlugin(@NonNull GlideStore glideStore) {
        this.glideAsyncDrawableLoader = new GlideAsyncDrawableLoader(glideStore);
    }

    public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
        builder.setFactory(Image.class, (SpanFactory)new ImageSpanFactory());
    }

    public void configureConfiguration(@NonNull MarkwonConfiguration.Builder builder) {
        builder.asyncDrawableLoader((AsyncDrawableLoader)this.glideAsyncDrawableLoader);
    }

    public void beforeSetText(@NonNull TextView textView, @NonNull Spanned markdown) {
        AsyncDrawableScheduler.unschedule((TextView)textView);
    }

    public void afterSetText(@NonNull TextView textView) {
        AsyncDrawableScheduler.schedule((TextView)textView);
    }

    private static class GlideAsyncDrawableLoader
    extends AsyncDrawableLoader {
        private final GlideStore glideStore;
        private final Map<AsyncDrawable, Target<?>> cache = new HashMap(2);

        GlideAsyncDrawableLoader(@NonNull GlideStore glideStore) {
            this.glideStore = glideStore;
        }

        public void load(@NonNull AsyncDrawable drawable) {
            AsyncDrawableTarget target = new AsyncDrawableTarget(drawable);
            this.cache.put(drawable, (Target<?>)target);
            this.glideStore.load(drawable).into((Target)target);
        }

        public void cancel(@NonNull AsyncDrawable drawable) {
            Target<?> target = this.cache.remove(drawable);
            if (target != null) {
                this.glideStore.cancel(target);
            }
        }

        @Nullable
        public Drawable placeholder(@NonNull AsyncDrawable drawable) {
            return null;
        }

        private class AsyncDrawableTarget
        extends CustomTarget<Drawable> {
            private final AsyncDrawable drawable;

            AsyncDrawableTarget(AsyncDrawable drawable) {
                this.drawable = drawable;
            }

            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                if (GlideAsyncDrawableLoader.this.cache.remove(this.drawable) != null && this.drawable.isAttached()) {
                    DrawableUtils.applyIntrinsicBoundsIfEmpty((Drawable)resource);
                    this.drawable.setResult(resource);
                }
            }

            public void onLoadStarted(@Nullable Drawable placeholder) {
                if (placeholder != null && this.drawable.isAttached()) {
                    DrawableUtils.applyIntrinsicBoundsIfEmpty((Drawable)placeholder);
                    this.drawable.setResult(placeholder);
                }
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                if (GlideAsyncDrawableLoader.this.cache.remove(this.drawable) != null && errorDrawable != null && this.drawable.isAttached()) {
                    DrawableUtils.applyIntrinsicBoundsIfEmpty((Drawable)errorDrawable);
                    this.drawable.setResult(errorDrawable);
                }
            }

            public void onLoadCleared(@Nullable Drawable placeholder) {
                if (this.drawable.isAttached()) {
                    this.drawable.clearResult();
                }
            }
        }
    }

    public static interface GlideStore {
        @NonNull
        public RequestBuilder<Drawable> load(@NonNull AsyncDrawable var1);

        public void cancel(@NonNull Target<?> var1);
    }
}

