/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.html;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.html.HtmlEmptyTagReplacement;
import io.noties.markwon.html.MarkwonHtmlParser;
import io.noties.markwon.html.MarkwonHtmlParserImpl;
import io.noties.markwon.html.MarkwonHtmlRenderer;
import io.noties.markwon.html.MarkwonHtmlRendererImpl;
import io.noties.markwon.html.TagHandler;
import io.noties.markwon.html.tag.BlockquoteHandler;
import io.noties.markwon.html.tag.EmphasisHandler;
import io.noties.markwon.html.tag.HeadingHandler;
import io.noties.markwon.html.tag.ImageHandler;
import io.noties.markwon.html.tag.LinkHandler;
import io.noties.markwon.html.tag.ListHandler;
import io.noties.markwon.html.tag.StrikeHandler;
import io.noties.markwon.html.tag.StrongEmphasisHandler;
import io.noties.markwon.html.tag.SubScriptHandler;
import io.noties.markwon.html.tag.SuperScriptHandler;
import io.noties.markwon.html.tag.UnderlineHandler;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Node;

public class HtmlPlugin
extends AbstractMarkwonPlugin {
    public static final float SCRIPT_DEF_TEXT_SIZE_RATIO = 0.75f;
    private final MarkwonHtmlRendererImpl.Builder builder;
    private MarkwonHtmlParser htmlParser;
    private MarkwonHtmlRenderer htmlRenderer;
    private HtmlEmptyTagReplacement emptyTagReplacement = new HtmlEmptyTagReplacement();

    @NonNull
    public static HtmlPlugin create() {
        return new HtmlPlugin();
    }

    @NonNull
    public static HtmlPlugin create(@NonNull HtmlConfigure configure) {
        HtmlPlugin plugin = HtmlPlugin.create();
        configure.configureHtml(plugin);
        return plugin;
    }

    HtmlPlugin() {
        this.builder = new MarkwonHtmlRendererImpl.Builder();
    }

    @NonNull
    public HtmlPlugin allowNonClosedTags(boolean allowNonClosedTags) {
        this.builder.allowNonClosedTags(allowNonClosedTags);
        return this;
    }

    @NonNull
    public HtmlPlugin addHandler(@NonNull TagHandler tagHandler) {
        this.builder.addHandler(tagHandler);
        return this;
    }

    @Nullable
    public TagHandler getHandler(@NonNull String tagName) {
        return this.builder.getHandler(tagName);
    }

    @NonNull
    public HtmlPlugin excludeDefaults(boolean excludeDefaults) {
        this.builder.excludeDefaults(excludeDefaults);
        return this;
    }

    @NonNull
    public HtmlPlugin emptyTagReplacement(@NonNull HtmlEmptyTagReplacement emptyTagReplacement) {
        this.emptyTagReplacement = emptyTagReplacement;
        return this;
    }

    public void configureConfiguration(@NonNull MarkwonConfiguration.Builder configurationBuilder) {
        MarkwonHtmlRendererImpl.Builder builder = this.builder;
        if (!builder.excludeDefaults()) {
            builder.addDefaultTagHandler(ImageHandler.create());
            builder.addDefaultTagHandler(new LinkHandler());
            builder.addDefaultTagHandler(new BlockquoteHandler());
            builder.addDefaultTagHandler(new SubScriptHandler());
            builder.addDefaultTagHandler(new SuperScriptHandler());
            builder.addDefaultTagHandler(new StrongEmphasisHandler());
            builder.addDefaultTagHandler(new StrikeHandler());
            builder.addDefaultTagHandler(new UnderlineHandler());
            builder.addDefaultTagHandler(new ListHandler());
            builder.addDefaultTagHandler(new EmphasisHandler());
            builder.addDefaultTagHandler(new HeadingHandler());
        }
        this.htmlParser = MarkwonHtmlParserImpl.create(this.emptyTagReplacement);
        this.htmlRenderer = builder.build();
    }

    public void afterRender(@NonNull Node node, @NonNull MarkwonVisitor visitor) {
        MarkwonHtmlRenderer htmlRenderer = this.htmlRenderer;
        if (htmlRenderer == null) {
            throw new IllegalStateException("Unexpected state, html-renderer is not defined");
        }
        htmlRenderer.render(visitor, this.htmlParser);
    }

    public void configureVisitor(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(HtmlBlock.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<HtmlBlock>(){

            public void visit(@NonNull MarkwonVisitor visitor, @NonNull HtmlBlock htmlBlock) {
                HtmlPlugin.this.visitHtml(visitor, htmlBlock.getLiteral());
            }
        }).on(HtmlInline.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<HtmlInline>(){

            public void visit(@NonNull MarkwonVisitor visitor, @NonNull HtmlInline htmlInline) {
                HtmlPlugin.this.visitHtml(visitor, htmlInline.getLiteral());
            }
        });
    }

    private void visitHtml(@NonNull MarkwonVisitor visitor, @Nullable String html) {
        if (html != null) {
            this.htmlParser.processFragment(visitor.builder(), html);
        }
    }

    public static interface HtmlConfigure {
        public void configureHtml(@NonNull HtmlPlugin var1);
    }
}

