/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.tasklist;

import android.text.TextUtils;
import io.noties.markwon.ext.tasklist.TaskListItem;
import io.noties.markwon.utils.ParserUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.parser.PostProcessor;

class TaskListPostProcessor
implements PostProcessor {
    TaskListPostProcessor() {
    }

    public Node process(Node node) {
        TaskListVisitor visitor = new TaskListVisitor();
        node.accept((Visitor)visitor);
        return node;
    }

    private static class TaskListVisitor
    extends AbstractVisitor {
        private static final Pattern REGEX_TASK_LIST_ITEM = Pattern.compile("^\\[([xX\\s])]\\s+(.*)");

        private TaskListVisitor() {
        }

        public void visit(ListItem listItem) {
            Text textNode;
            Matcher matcher;
            Node node;
            Node child = listItem.getFirstChild();
            if (child instanceof Paragraph && (node = child.getFirstChild()) instanceof Text && (matcher = REGEX_TASK_LIST_ITEM.matcher((textNode = (Text)node).getLiteral())).matches()) {
                String checked = matcher.group(1);
                boolean isChecked = "x".equals(checked) || "X".equals(checked);
                TaskListItem taskListItem = new TaskListItem(isChecked);
                Paragraph paragraph = new Paragraph();
                listItem.insertBefore((Node)taskListItem);
                String restMatchedText = matcher.group(2);
                if (!TextUtils.isEmpty((CharSequence)restMatchedText)) {
                    paragraph.appendChild((Node)new Text(restMatchedText));
                }
                ParserUtils.moveChildren((Node)paragraph, (Node)node);
                taskListItem.appendChild((Node)paragraph);
                ParserUtils.moveChildren((Node)taskListItem, (Node)child);
                listItem.unlink();
                this.visitChildren((Node)taskListItem);
                return;
            }
            this.visitChildren((Node)listItem);
        }
    }
}

