/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.tasklist;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class TaskListDrawable
extends Drawable {
    private static final Point POINT_0 = new Point(0.15277778f, 0.45833334f);
    private static final Point POINT_1 = new Point(0.3888889f, 0.6944444f);
    private static final Point POINT_2 = new Point(0.8472222f, 0.2638889f);
    private final int checkedFillColor;
    private final int normalOutlineColor;
    private final Paint paint = new Paint(1);
    private final RectF rectF = new RectF();
    private final Paint checkMarkPaint = new Paint(1);
    private final Path checkMarkPath = new Path();
    private boolean isChecked;

    public TaskListDrawable(@ColorInt int checkedFillColor, @ColorInt int normalOutlineColor, @ColorInt int checkMarkColor) {
        this.checkedFillColor = checkedFillColor;
        this.normalOutlineColor = normalOutlineColor;
        this.checkMarkPaint.setColor(checkMarkColor);
        this.checkMarkPaint.setStyle(Paint.Style.STROKE);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        float min = Math.min(bounds.width(), bounds.height());
        float stroke = min / 8.0f;
        float side = min - stroke;
        this.rectF.set(0.0f, 0.0f, side, side);
        this.paint.setStrokeWidth(stroke);
        this.checkMarkPaint.setStrokeWidth(stroke);
        this.checkMarkPath.reset();
        POINT_0.moveTo(this.checkMarkPath, side);
        POINT_1.lineTo(this.checkMarkPath, side);
        POINT_2.lineTo(this.checkMarkPath, side);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NonNull Canvas canvas) {
        int color;
        Paint.Style style;
        if (this.isChecked) {
            style = Paint.Style.FILL_AND_STROKE;
            color = this.checkedFillColor;
        } else {
            style = Paint.Style.STROKE;
            color = this.normalOutlineColor;
        }
        this.paint.setStyle(style);
        this.paint.setColor(color);
        Rect bounds = this.getBounds();
        float left = ((float)bounds.width() - this.rectF.width()) / 2.0f;
        float top = ((float)bounds.height() - this.rectF.height()) / 2.0f;
        float radius = this.rectF.width() / 8.0f;
        int save = canvas.save();
        try {
            canvas.translate(left, top);
            canvas.drawRoundRect(this.rectF, radius, radius, this.paint);
            if (this.isChecked) {
                canvas.drawPath(this.checkMarkPath, this.checkMarkPaint);
            }
        }
        finally {
            canvas.restoreToCount(save);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -1;
    }

    public boolean isStateful() {
        return true;
    }

    protected boolean onStateChange(int[] state) {
        boolean result;
        boolean checked;
        int length;
        int n = length = state != null ? state.length : 0;
        if (length > 0) {
            boolean inner = false;
            for (int i = 0; i < length; ++i) {
                if (0x10100A0 != state[i]) continue;
                inner = true;
                break;
            }
            checked = inner;
        } else {
            checked = false;
        }
        boolean bl = result = checked != this.isChecked;
        if (result) {
            this.invalidateSelf();
            this.isChecked = checked;
        }
        return result;
    }

    private static class Point {
        final float x;
        final float y;

        Point(float x, float y) {
            this.x = x;
            this.y = y;
        }

        void moveTo(@NonNull Path path, float side) {
            path.moveTo(side * this.x, side * this.y);
        }

        void lineTo(@NonNull Path path, float side) {
            path.lineTo(side * this.x, side * this.y);
        }
    }
}

