/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.tables;

import android.content.Context;
import android.text.Spanned;
import android.widget.TextView;
import androidx.annotation.NonNull;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.SpannableBuilder;
import io.noties.markwon.ext.tables.TableRowSpan;
import io.noties.markwon.ext.tables.TableRowsScheduler;
import io.noties.markwon.ext.tables.TableSpan;
import io.noties.markwon.ext.tables.TableTheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;

public class TablePlugin
extends AbstractMarkwonPlugin {
    private final TableTheme theme;
    private final TableVisitor visitor;

    @NonNull
    public static TablePlugin create(@NonNull Context context) {
        return new TablePlugin(TableTheme.create(context));
    }

    @NonNull
    public static TablePlugin create(@NonNull TableTheme tableTheme) {
        return new TablePlugin(tableTheme);
    }

    @NonNull
    public static TablePlugin create(@NonNull ThemeConfigure themeConfigure) {
        TableTheme.Builder builder = new TableTheme.Builder();
        themeConfigure.configureTheme(builder);
        return new TablePlugin(builder.build());
    }

    TablePlugin(@NonNull TableTheme tableTheme) {
        this.theme = tableTheme;
        this.visitor = new TableVisitor(tableTheme);
    }

    @NonNull
    public TableTheme theme() {
        return this.theme;
    }

    public void configureParser(@NonNull Parser.Builder builder) {
        builder.extensions(Collections.singleton(TablesExtension.create()));
    }

    public void configureVisitor(@NonNull MarkwonVisitor.Builder builder) {
        this.visitor.configure(builder);
    }

    public void beforeRender(@NonNull Node node) {
        this.visitor.clear();
    }

    public void beforeSetText(@NonNull TextView textView, @NonNull Spanned markdown) {
        TableRowsScheduler.unschedule(textView);
    }

    public void afterSetText(@NonNull TextView textView) {
        TableRowsScheduler.schedule(textView);
    }

    private static class TableVisitor {
        private final TableTheme tableTheme;
        private List<TableRowSpan.Cell> pendingTableRow;
        private boolean tableRowIsHeader;
        private int tableRows;

        TableVisitor(@NonNull TableTheme tableTheme) {
            this.tableTheme = tableTheme;
        }

        void clear() {
            this.pendingTableRow = null;
            this.tableRowIsHeader = false;
            this.tableRows = 0;
        }

        void configure(@NonNull MarkwonVisitor.Builder builder) {
            builder.on(TableBlock.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<TableBlock>(){

                public void visit(@NonNull MarkwonVisitor visitor, @NonNull TableBlock tableBlock) {
                    visitor.blockStart((Node)tableBlock);
                    int length = visitor.length();
                    visitor.visitChildren((Node)tableBlock);
                    visitor.setSpans(length, (Object)new TableSpan());
                    visitor.blockEnd((Node)tableBlock);
                }
            }).on(TableBody.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<TableBody>(){

                public void visit(@NonNull MarkwonVisitor visitor, @NonNull TableBody tableBody) {
                    visitor.visitChildren((Node)tableBody);
                    TableVisitor.this.tableRows = 0;
                }
            }).on(TableRow.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<TableRow>(){

                public void visit(@NonNull MarkwonVisitor visitor, @NonNull TableRow tableRow) {
                    TableVisitor.this.visitRow(visitor, (Node)tableRow);
                }
            }).on(TableHead.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<TableHead>(){

                public void visit(@NonNull MarkwonVisitor visitor, @NonNull TableHead tableHead) {
                    TableVisitor.this.visitRow(visitor, (Node)tableHead);
                }
            }).on(TableCell.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<TableCell>(){

                public void visit(@NonNull MarkwonVisitor visitor, @NonNull TableCell tableCell) {
                    int length = visitor.length();
                    visitor.visitChildren((Node)tableCell);
                    if (TableVisitor.this.pendingTableRow == null) {
                        TableVisitor.this.pendingTableRow = new ArrayList(2);
                    }
                    TableVisitor.this.pendingTableRow.add(new TableRowSpan.Cell(TableVisitor.tableCellAlignment(tableCell.getAlignment()), visitor.builder().removeFromEnd(length)));
                    TableVisitor.this.tableRowIsHeader = tableCell.isHeader();
                }
            });
        }

        private void visitRow(@NonNull MarkwonVisitor visitor, @NonNull Node node) {
            int length = visitor.length();
            visitor.visitChildren(node);
            if (this.pendingTableRow != null) {
                boolean addNewLine;
                SpannableBuilder builder = visitor.builder();
                int builderLength = builder.length();
                boolean bl = addNewLine = builderLength > 0 && '\n' != builder.charAt(builderLength - 1);
                if (addNewLine) {
                    visitor.forceNewLine();
                }
                builder.append('\u00a0');
                TableRowSpan span = new TableRowSpan(this.tableTheme, this.pendingTableRow, this.tableRowIsHeader, this.tableRows % 2 == 1);
                this.tableRows = this.tableRowIsHeader ? 0 : this.tableRows + 1;
                visitor.setSpans(addNewLine ? length + 1 : length, (Object)span);
                this.pendingTableRow = null;
            }
        }

        private static int tableCellAlignment(TableCell.Alignment alignment) {
            int out;
            if (alignment != null) {
                switch (alignment) {
                    case CENTER: {
                        out = 1;
                        break;
                    }
                    case RIGHT: {
                        out = 2;
                        break;
                    }
                    default: {
                        out = 0;
                        break;
                    }
                }
            } else {
                out = 0;
            }
            return out;
        }
    }

    public static interface ThemeConfigure {
        public void configureTheme(@NonNull TableTheme.Builder var1);
    }
}

